/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.healthlake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFhirDatastoreRequest extends HealthLakeRequest implements
        ToCopyableBuilder<CreateFhirDatastoreRequest.Builder, CreateFhirDatastoreRequest> {
    private static final SdkField<String> DATASTORE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatastoreName").getter(getter(CreateFhirDatastoreRequest::datastoreName))
            .setter(setter(Builder::datastoreName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreName").build()).build();

    private static final SdkField<String> DATASTORE_TYPE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatastoreTypeVersion").getter(getter(CreateFhirDatastoreRequest::datastoreTypeVersionAsString))
            .setter(setter(Builder::datastoreTypeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreTypeVersion").build())
            .build();

    private static final SdkField<SseConfiguration> SSE_CONFIGURATION_FIELD = SdkField
            .<SseConfiguration> builder(MarshallingType.SDK_POJO).memberName("SseConfiguration")
            .getter(getter(CreateFhirDatastoreRequest::sseConfiguration)).setter(setter(Builder::sseConfiguration))
            .constructor(SseConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseConfiguration").build()).build();

    private static final SdkField<PreloadDataConfig> PRELOAD_DATA_CONFIG_FIELD = SdkField
            .<PreloadDataConfig> builder(MarshallingType.SDK_POJO).memberName("PreloadDataConfig")
            .getter(getter(CreateFhirDatastoreRequest::preloadDataConfig)).setter(setter(Builder::preloadDataConfig))
            .constructor(PreloadDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreloadDataConfig").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateFhirDatastoreRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateFhirDatastoreRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<IdentityProviderConfiguration> IDENTITY_PROVIDER_CONFIGURATION_FIELD = SdkField
            .<IdentityProviderConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("IdentityProviderConfiguration")
            .getter(getter(CreateFhirDatastoreRequest::identityProviderConfiguration))
            .setter(setter(Builder::identityProviderConfiguration))
            .constructor(IdentityProviderConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_NAME_FIELD,
            DATASTORE_TYPE_VERSION_FIELD, SSE_CONFIGURATION_FIELD, PRELOAD_DATA_CONFIG_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD,
            IDENTITY_PROVIDER_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String datastoreName;

    private final String datastoreTypeVersion;

    private final SseConfiguration sseConfiguration;

    private final PreloadDataConfig preloadDataConfig;

    private final String clientToken;

    private final List<Tag> tags;

    private final IdentityProviderConfiguration identityProviderConfiguration;

    private CreateFhirDatastoreRequest(BuilderImpl builder) {
        super(builder);
        this.datastoreName = builder.datastoreName;
        this.datastoreTypeVersion = builder.datastoreTypeVersion;
        this.sseConfiguration = builder.sseConfiguration;
        this.preloadDataConfig = builder.preloadDataConfig;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.identityProviderConfiguration = builder.identityProviderConfiguration;
    }

    /**
     * <p>
     * The data store name (user-generated).
     * </p>
     * 
     * @return The data store name (user-generated).
     */
    public final String datastoreName() {
        return datastoreName;
    }

    /**
     * <p>
     * The FHIR release version supported by the data store. Current support is for version <code>R4</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #datastoreTypeVersion} will return {@link FHIRVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #datastoreTypeVersionAsString}.
     * </p>
     * 
     * @return The FHIR release version supported by the data store. Current support is for version <code>R4</code>.
     * @see FHIRVersion
     */
    public final FHIRVersion datastoreTypeVersion() {
        return FHIRVersion.fromValue(datastoreTypeVersion);
    }

    /**
     * <p>
     * The FHIR release version supported by the data store. Current support is for version <code>R4</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #datastoreTypeVersion} will return {@link FHIRVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #datastoreTypeVersionAsString}.
     * </p>
     * 
     * @return The FHIR release version supported by the data store. Current support is for version <code>R4</code>.
     * @see FHIRVersion
     */
    public final String datastoreTypeVersionAsString() {
        return datastoreTypeVersion;
    }

    /**
     * <p>
     * The server-side encryption key configuration for a customer-provided encryption key specified for creating a data
     * store.
     * </p>
     * 
     * @return The server-side encryption key configuration for a customer-provided encryption key specified for
     *         creating a data store.
     */
    public final SseConfiguration sseConfiguration() {
        return sseConfiguration;
    }

    /**
     * <p>
     * An optional parameter to preload (import) open source Synthea FHIR data upon creation of the data store.
     * </p>
     * 
     * @return An optional parameter to preload (import) open source Synthea FHIR data upon creation of the data store.
     */
    public final PreloadDataConfig preloadDataConfig() {
        return preloadDataConfig;
    }

    /**
     * <p>
     * An optional user-provided token to ensure API idempotency.
     * </p>
     * 
     * @return An optional user-provided token to ensure API idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource tags applied to a data store when it is created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The resource tags applied to a data store when it is created.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The identity provider configuration to use for the data store.
     * </p>
     * 
     * @return The identity provider configuration to use for the data store.
     */
    public final IdentityProviderConfiguration identityProviderConfiguration() {
        return identityProviderConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datastoreName());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreTypeVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sseConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(preloadDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFhirDatastoreRequest)) {
            return false;
        }
        CreateFhirDatastoreRequest other = (CreateFhirDatastoreRequest) obj;
        return Objects.equals(datastoreName(), other.datastoreName())
                && Objects.equals(datastoreTypeVersionAsString(), other.datastoreTypeVersionAsString())
                && Objects.equals(sseConfiguration(), other.sseConfiguration())
                && Objects.equals(preloadDataConfig(), other.preloadDataConfig())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(identityProviderConfiguration(), other.identityProviderConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFhirDatastoreRequest").add("DatastoreName", datastoreName())
                .add("DatastoreTypeVersion", datastoreTypeVersionAsString()).add("SseConfiguration", sseConfiguration())
                .add("PreloadDataConfig", preloadDataConfig()).add("ClientToken", clientToken())
                .add("Tags", hasTags() ? tags() : null).add("IdentityProviderConfiguration", identityProviderConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatastoreName":
            return Optional.ofNullable(clazz.cast(datastoreName()));
        case "DatastoreTypeVersion":
            return Optional.ofNullable(clazz.cast(datastoreTypeVersionAsString()));
        case "SseConfiguration":
            return Optional.ofNullable(clazz.cast(sseConfiguration()));
        case "PreloadDataConfig":
            return Optional.ofNullable(clazz.cast(preloadDataConfig()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "IdentityProviderConfiguration":
            return Optional.ofNullable(clazz.cast(identityProviderConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatastoreName", DATASTORE_NAME_FIELD);
        map.put("DatastoreTypeVersion", DATASTORE_TYPE_VERSION_FIELD);
        map.put("SseConfiguration", SSE_CONFIGURATION_FIELD);
        map.put("PreloadDataConfig", PRELOAD_DATA_CONFIG_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("IdentityProviderConfiguration", IDENTITY_PROVIDER_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFhirDatastoreRequest, T> g) {
        return obj -> g.apply((CreateFhirDatastoreRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends HealthLakeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFhirDatastoreRequest> {
        /**
         * <p>
         * The data store name (user-generated).
         * </p>
         * 
         * @param datastoreName
         *        The data store name (user-generated).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreName(String datastoreName);

        /**
         * <p>
         * The FHIR release version supported by the data store. Current support is for version <code>R4</code>.
         * </p>
         * 
         * @param datastoreTypeVersion
         *        The FHIR release version supported by the data store. Current support is for version <code>R4</code>.
         * @see FHIRVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FHIRVersion
         */
        Builder datastoreTypeVersion(String datastoreTypeVersion);

        /**
         * <p>
         * The FHIR release version supported by the data store. Current support is for version <code>R4</code>.
         * </p>
         * 
         * @param datastoreTypeVersion
         *        The FHIR release version supported by the data store. Current support is for version <code>R4</code>.
         * @see FHIRVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FHIRVersion
         */
        Builder datastoreTypeVersion(FHIRVersion datastoreTypeVersion);

        /**
         * <p>
         * The server-side encryption key configuration for a customer-provided encryption key specified for creating a
         * data store.
         * </p>
         * 
         * @param sseConfiguration
         *        The server-side encryption key configuration for a customer-provided encryption key specified for
         *        creating a data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseConfiguration(SseConfiguration sseConfiguration);

        /**
         * <p>
         * The server-side encryption key configuration for a customer-provided encryption key specified for creating a
         * data store.
         * </p>
         * This is a convenience method that creates an instance of the {@link SseConfiguration.Builder} avoiding the
         * need to create one manually via {@link SseConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SseConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #sseConfiguration(SseConfiguration)}.
         * 
         * @param sseConfiguration
         *        a consumer that will call methods on {@link SseConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseConfiguration(SseConfiguration)
         */
        default Builder sseConfiguration(Consumer<SseConfiguration.Builder> sseConfiguration) {
            return sseConfiguration(SseConfiguration.builder().applyMutation(sseConfiguration).build());
        }

        /**
         * <p>
         * An optional parameter to preload (import) open source Synthea FHIR data upon creation of the data store.
         * </p>
         * 
         * @param preloadDataConfig
         *        An optional parameter to preload (import) open source Synthea FHIR data upon creation of the data
         *        store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preloadDataConfig(PreloadDataConfig preloadDataConfig);

        /**
         * <p>
         * An optional parameter to preload (import) open source Synthea FHIR data upon creation of the data store.
         * </p>
         * This is a convenience method that creates an instance of the {@link PreloadDataConfig.Builder} avoiding the
         * need to create one manually via {@link PreloadDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PreloadDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #preloadDataConfig(PreloadDataConfig)}.
         * 
         * @param preloadDataConfig
         *        a consumer that will call methods on {@link PreloadDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preloadDataConfig(PreloadDataConfig)
         */
        default Builder preloadDataConfig(Consumer<PreloadDataConfig.Builder> preloadDataConfig) {
            return preloadDataConfig(PreloadDataConfig.builder().applyMutation(preloadDataConfig).build());
        }

        /**
         * <p>
         * An optional user-provided token to ensure API idempotency.
         * </p>
         * 
         * @param clientToken
         *        An optional user-provided token to ensure API idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The resource tags applied to a data store when it is created.
         * </p>
         * 
         * @param tags
         *        The resource tags applied to a data store when it is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The resource tags applied to a data store when it is created.
         * </p>
         * 
         * @param tags
         *        The resource tags applied to a data store when it is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The resource tags applied to a data store when it is created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.healthlake.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.healthlake.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.healthlake.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.healthlake.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The identity provider configuration to use for the data store.
         * </p>
         * 
         * @param identityProviderConfiguration
         *        The identity provider configuration to use for the data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderConfiguration(IdentityProviderConfiguration identityProviderConfiguration);

        /**
         * <p>
         * The identity provider configuration to use for the data store.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdentityProviderConfiguration.Builder}
         * avoiding the need to create one manually via {@link IdentityProviderConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentityProviderConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #identityProviderConfiguration(IdentityProviderConfiguration)}.
         * 
         * @param identityProviderConfiguration
         *        a consumer that will call methods on {@link IdentityProviderConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProviderConfiguration(IdentityProviderConfiguration)
         */
        default Builder identityProviderConfiguration(
                Consumer<IdentityProviderConfiguration.Builder> identityProviderConfiguration) {
            return identityProviderConfiguration(IdentityProviderConfiguration.builder()
                    .applyMutation(identityProviderConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends HealthLakeRequest.BuilderImpl implements Builder {
        private String datastoreName;

        private String datastoreTypeVersion;

        private SseConfiguration sseConfiguration;

        private PreloadDataConfig preloadDataConfig;

        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private IdentityProviderConfiguration identityProviderConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFhirDatastoreRequest model) {
            super(model);
            datastoreName(model.datastoreName);
            datastoreTypeVersion(model.datastoreTypeVersion);
            sseConfiguration(model.sseConfiguration);
            preloadDataConfig(model.preloadDataConfig);
            clientToken(model.clientToken);
            tags(model.tags);
            identityProviderConfiguration(model.identityProviderConfiguration);
        }

        public final String getDatastoreName() {
            return datastoreName;
        }

        public final void setDatastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
        }

        @Override
        public final Builder datastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        public final String getDatastoreTypeVersion() {
            return datastoreTypeVersion;
        }

        public final void setDatastoreTypeVersion(String datastoreTypeVersion) {
            this.datastoreTypeVersion = datastoreTypeVersion;
        }

        @Override
        public final Builder datastoreTypeVersion(String datastoreTypeVersion) {
            this.datastoreTypeVersion = datastoreTypeVersion;
            return this;
        }

        @Override
        public final Builder datastoreTypeVersion(FHIRVersion datastoreTypeVersion) {
            this.datastoreTypeVersion(datastoreTypeVersion == null ? null : datastoreTypeVersion.toString());
            return this;
        }

        public final SseConfiguration.Builder getSseConfiguration() {
            return sseConfiguration != null ? sseConfiguration.toBuilder() : null;
        }

        public final void setSseConfiguration(SseConfiguration.BuilderImpl sseConfiguration) {
            this.sseConfiguration = sseConfiguration != null ? sseConfiguration.build() : null;
        }

        @Override
        public final Builder sseConfiguration(SseConfiguration sseConfiguration) {
            this.sseConfiguration = sseConfiguration;
            return this;
        }

        public final PreloadDataConfig.Builder getPreloadDataConfig() {
            return preloadDataConfig != null ? preloadDataConfig.toBuilder() : null;
        }

        public final void setPreloadDataConfig(PreloadDataConfig.BuilderImpl preloadDataConfig) {
            this.preloadDataConfig = preloadDataConfig != null ? preloadDataConfig.build() : null;
        }

        @Override
        public final Builder preloadDataConfig(PreloadDataConfig preloadDataConfig) {
            this.preloadDataConfig = preloadDataConfig;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final IdentityProviderConfiguration.Builder getIdentityProviderConfiguration() {
            return identityProviderConfiguration != null ? identityProviderConfiguration.toBuilder() : null;
        }

        public final void setIdentityProviderConfiguration(IdentityProviderConfiguration.BuilderImpl identityProviderConfiguration) {
            this.identityProviderConfiguration = identityProviderConfiguration != null ? identityProviderConfiguration.build()
                    : null;
        }

        @Override
        public final Builder identityProviderConfiguration(IdentityProviderConfiguration identityProviderConfiguration) {
            this.identityProviderConfiguration = identityProviderConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFhirDatastoreRequest build() {
            return new CreateFhirDatastoreRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
