/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.healthlake.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The import job properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportJobProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportJobProperties.Builder, ImportJobProperties> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(ImportJobProperties::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(ImportJobProperties::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(ImportJobProperties::jobStatusAsString)).setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<Instant> SUBMIT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmitTime").getter(getter(ImportJobProperties::submitTime)).setter(setter(Builder::submitTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ImportJobProperties::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatastoreId").getter(getter(ImportJobProperties::datastoreId)).setter(setter(Builder::datastoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreId").build()).build();

    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField
            .<InputDataConfig> builder(MarshallingType.SDK_POJO).memberName("InputDataConfig")
            .getter(getter(ImportJobProperties::inputDataConfig)).setter(setter(Builder::inputDataConfig))
            .constructor(InputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()).build();

    private static final SdkField<OutputDataConfig> JOB_OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<OutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("JobOutputDataConfig")
            .getter(getter(ImportJobProperties::jobOutputDataConfig)).setter(setter(Builder::jobOutputDataConfig))
            .constructor(OutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobOutputDataConfig").build())
            .build();

    private static final SdkField<JobProgressReport> JOB_PROGRESS_REPORT_FIELD = SdkField
            .<JobProgressReport> builder(MarshallingType.SDK_POJO).memberName("JobProgressReport")
            .getter(getter(ImportJobProperties::jobProgressReport)).setter(setter(Builder::jobProgressReport))
            .constructor(JobProgressReport::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobProgressReport").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(ImportJobProperties::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(ImportJobProperties::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> VALIDATION_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationLevel").getter(getter(ImportJobProperties::validationLevelAsString))
            .setter(setter(Builder::validationLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_NAME_FIELD,
            JOB_STATUS_FIELD, SUBMIT_TIME_FIELD, END_TIME_FIELD, DATASTORE_ID_FIELD, INPUT_DATA_CONFIG_FIELD,
            JOB_OUTPUT_DATA_CONFIG_FIELD, JOB_PROGRESS_REPORT_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, MESSAGE_FIELD,
            VALIDATION_LEVEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final String jobName;

    private final String jobStatus;

    private final Instant submitTime;

    private final Instant endTime;

    private final String datastoreId;

    private final InputDataConfig inputDataConfig;

    private final OutputDataConfig jobOutputDataConfig;

    private final JobProgressReport jobProgressReport;

    private final String dataAccessRoleArn;

    private final String message;

    private final String validationLevel;

    private ImportJobProperties(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.jobStatus = builder.jobStatus;
        this.submitTime = builder.submitTime;
        this.endTime = builder.endTime;
        this.datastoreId = builder.datastoreId;
        this.inputDataConfig = builder.inputDataConfig;
        this.jobOutputDataConfig = builder.jobOutputDataConfig;
        this.jobProgressReport = builder.jobProgressReport;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.message = builder.message;
        this.validationLevel = builder.validationLevel;
    }

    /**
     * <p>
     * The import job identifier.
     * </p>
     * 
     * @return The import job identifier.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The import job name.
     * </p>
     * 
     * @return The import job name.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The import job status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The import job status.
     * @see JobStatus
     */
    public final JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The import job status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The import job status.
     * @see JobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The time the import job was submitted for processing.
     * </p>
     * 
     * @return The time the import job was submitted for processing.
     */
    public final Instant submitTime() {
        return submitTime;
    }

    /**
     * <p>
     * The time the import job was completed.
     * </p>
     * 
     * @return The time the import job was completed.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The data store identifier.
     * </p>
     * 
     * @return The data store identifier.
     */
    public final String datastoreId() {
        return datastoreId;
    }

    /**
     * <p>
     * The input data configuration supplied when the import job was created.
     * </p>
     * 
     * @return The input data configuration supplied when the import job was created.
     */
    public final InputDataConfig inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * Returns the value of the JobOutputDataConfig property for this object.
     * 
     * @return The value of the JobOutputDataConfig property for this object.
     */
    public final OutputDataConfig jobOutputDataConfig() {
        return jobOutputDataConfig;
    }

    /**
     * <p>
     * Displays the progress of the import job, including total resources scanned, total resources imported, and total
     * size of data imported.
     * </p>
     * 
     * @return Displays the progress of the import job, including total resources scanned, total resources imported, and
     *         total size of data imported.
     */
    public final JobProgressReport jobProgressReport() {
        return jobProgressReport;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that grants AWS HealthLake access to the input data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that grants AWS HealthLake access to the input data.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * <p>
     * An explanation of any errors that might have occurred during the FHIR import job.
     * </p>
     * 
     * @return An explanation of any errors that might have occurred during the FHIR import job.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The validation level of the import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationLevel}
     * will return {@link ValidationLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #validationLevelAsString}.
     * </p>
     * 
     * @return The validation level of the import job.
     * @see ValidationLevel
     */
    public final ValidationLevel validationLevel() {
        return ValidationLevel.fromValue(validationLevel);
    }

    /**
     * <p>
     * The validation level of the import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationLevel}
     * will return {@link ValidationLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #validationLevelAsString}.
     * </p>
     * 
     * @return The validation level of the import job.
     * @see ValidationLevel
     */
    public final String validationLevelAsString() {
        return validationLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(submitTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobOutputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobProgressReport());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(validationLevelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportJobProperties)) {
            return false;
        }
        ImportJobProperties other = (ImportJobProperties) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(submitTime(), other.submitTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(datastoreId(), other.datastoreId())
                && Objects.equals(inputDataConfig(), other.inputDataConfig())
                && Objects.equals(jobOutputDataConfig(), other.jobOutputDataConfig())
                && Objects.equals(jobProgressReport(), other.jobProgressReport())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(message(), other.message())
                && Objects.equals(validationLevelAsString(), other.validationLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportJobProperties").add("JobId", jobId()).add("JobName", jobName())
                .add("JobStatus", jobStatusAsString()).add("SubmitTime", submitTime()).add("EndTime", endTime())
                .add("DatastoreId", datastoreId()).add("InputDataConfig", inputDataConfig())
                .add("JobOutputDataConfig", jobOutputDataConfig()).add("JobProgressReport", jobProgressReport())
                .add("DataAccessRoleArn", dataAccessRoleArn()).add("Message", message())
                .add("ValidationLevel", validationLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "SubmitTime":
            return Optional.ofNullable(clazz.cast(submitTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "DatastoreId":
            return Optional.ofNullable(clazz.cast(datastoreId()));
        case "InputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "JobOutputDataConfig":
            return Optional.ofNullable(clazz.cast(jobOutputDataConfig()));
        case "JobProgressReport":
            return Optional.ofNullable(clazz.cast(jobProgressReport()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "ValidationLevel":
            return Optional.ofNullable(clazz.cast(validationLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobId", JOB_ID_FIELD);
        map.put("JobName", JOB_NAME_FIELD);
        map.put("JobStatus", JOB_STATUS_FIELD);
        map.put("SubmitTime", SUBMIT_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("DatastoreId", DATASTORE_ID_FIELD);
        map.put("InputDataConfig", INPUT_DATA_CONFIG_FIELD);
        map.put("JobOutputDataConfig", JOB_OUTPUT_DATA_CONFIG_FIELD);
        map.put("JobProgressReport", JOB_PROGRESS_REPORT_FIELD);
        map.put("DataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("ValidationLevel", VALIDATION_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportJobProperties, T> g) {
        return obj -> g.apply((ImportJobProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportJobProperties> {
        /**
         * <p>
         * The import job identifier.
         * </p>
         * 
         * @param jobId
         *        The import job identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The import job name.
         * </p>
         * 
         * @param jobName
         *        The import job name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The import job status.
         * </p>
         * 
         * @param jobStatus
         *        The import job status.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The import job status.
         * </p>
         * 
         * @param jobStatus
         *        The import job status.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * The time the import job was submitted for processing.
         * </p>
         * 
         * @param submitTime
         *        The time the import job was submitted for processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTime(Instant submitTime);

        /**
         * <p>
         * The time the import job was completed.
         * </p>
         * 
         * @param endTime
         *        The time the import job was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The data store identifier.
         * </p>
         * 
         * @param datastoreId
         *        The data store identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreId(String datastoreId);

        /**
         * <p>
         * The input data configuration supplied when the import job was created.
         * </p>
         * 
         * @param inputDataConfig
         *        The input data configuration supplied when the import job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(InputDataConfig inputDataConfig);

        /**
         * <p>
         * The input data configuration supplied when the import job was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputDataConfig.Builder} avoiding the
         * need to create one manually via {@link InputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #inputDataConfig(InputDataConfig)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on {@link InputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(InputDataConfig)
         */
        default Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return inputDataConfig(InputDataConfig.builder().applyMutation(inputDataConfig).build());
        }

        /**
         * Sets the value of the JobOutputDataConfig property for this object.
         *
         * @param jobOutputDataConfig
         *        The new value for the JobOutputDataConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobOutputDataConfig(OutputDataConfig jobOutputDataConfig);

        /**
         * Sets the value of the JobOutputDataConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OutputDataConfig.Builder} avoiding the
         * need to create one manually via {@link OutputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #jobOutputDataConfig(OutputDataConfig)}.
         * 
         * @param jobOutputDataConfig
         *        a consumer that will call methods on {@link OutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobOutputDataConfig(OutputDataConfig)
         */
        default Builder jobOutputDataConfig(Consumer<OutputDataConfig.Builder> jobOutputDataConfig) {
            return jobOutputDataConfig(OutputDataConfig.builder().applyMutation(jobOutputDataConfig).build());
        }

        /**
         * <p>
         * Displays the progress of the import job, including total resources scanned, total resources imported, and
         * total size of data imported.
         * </p>
         * 
         * @param jobProgressReport
         *        Displays the progress of the import job, including total resources scanned, total resources imported,
         *        and total size of data imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobProgressReport(JobProgressReport jobProgressReport);

        /**
         * <p>
         * Displays the progress of the import job, including total resources scanned, total resources imported, and
         * total size of data imported.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobProgressReport.Builder} avoiding the
         * need to create one manually via {@link JobProgressReport#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobProgressReport.Builder#build()} is called immediately and its
         * result is passed to {@link #jobProgressReport(JobProgressReport)}.
         * 
         * @param jobProgressReport
         *        a consumer that will call methods on {@link JobProgressReport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobProgressReport(JobProgressReport)
         */
        default Builder jobProgressReport(Consumer<JobProgressReport.Builder> jobProgressReport) {
            return jobProgressReport(JobProgressReport.builder().applyMutation(jobProgressReport).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) that grants AWS HealthLake access to the input data.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) that grants AWS HealthLake access to the input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * An explanation of any errors that might have occurred during the FHIR import job.
         * </p>
         * 
         * @param message
         *        An explanation of any errors that might have occurred during the FHIR import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The validation level of the import job.
         * </p>
         * 
         * @param validationLevel
         *        The validation level of the import job.
         * @see ValidationLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationLevel
         */
        Builder validationLevel(String validationLevel);

        /**
         * <p>
         * The validation level of the import job.
         * </p>
         * 
         * @param validationLevel
         *        The validation level of the import job.
         * @see ValidationLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationLevel
         */
        Builder validationLevel(ValidationLevel validationLevel);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String jobName;

        private String jobStatus;

        private Instant submitTime;

        private Instant endTime;

        private String datastoreId;

        private InputDataConfig inputDataConfig;

        private OutputDataConfig jobOutputDataConfig;

        private JobProgressReport jobProgressReport;

        private String dataAccessRoleArn;

        private String message;

        private String validationLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportJobProperties model) {
            jobId(model.jobId);
            jobName(model.jobName);
            jobStatus(model.jobStatus);
            submitTime(model.submitTime);
            endTime(model.endTime);
            datastoreId(model.datastoreId);
            inputDataConfig(model.inputDataConfig);
            jobOutputDataConfig(model.jobOutputDataConfig);
            jobProgressReport(model.jobProgressReport);
            dataAccessRoleArn(model.dataAccessRoleArn);
            message(model.message);
            validationLevel(model.validationLevel);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final Instant getSubmitTime() {
            return submitTime;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        @Override
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getDatastoreId() {
            return datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return inputDataConfig != null ? inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final OutputDataConfig.Builder getJobOutputDataConfig() {
            return jobOutputDataConfig != null ? jobOutputDataConfig.toBuilder() : null;
        }

        public final void setJobOutputDataConfig(OutputDataConfig.BuilderImpl jobOutputDataConfig) {
            this.jobOutputDataConfig = jobOutputDataConfig != null ? jobOutputDataConfig.build() : null;
        }

        @Override
        public final Builder jobOutputDataConfig(OutputDataConfig jobOutputDataConfig) {
            this.jobOutputDataConfig = jobOutputDataConfig;
            return this;
        }

        public final JobProgressReport.Builder getJobProgressReport() {
            return jobProgressReport != null ? jobProgressReport.toBuilder() : null;
        }

        public final void setJobProgressReport(JobProgressReport.BuilderImpl jobProgressReport) {
            this.jobProgressReport = jobProgressReport != null ? jobProgressReport.build() : null;
        }

        @Override
        public final Builder jobProgressReport(JobProgressReport jobProgressReport) {
            this.jobProgressReport = jobProgressReport;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getValidationLevel() {
            return validationLevel;
        }

        public final void setValidationLevel(String validationLevel) {
            this.validationLevel = validationLevel;
        }

        @Override
        public final Builder validationLevel(String validationLevel) {
            this.validationLevel = validationLevel;
            return this;
        }

        @Override
        public final Builder validationLevel(ValidationLevel validationLevel) {
            this.validationLevel(validationLevel == null ? null : validationLevel.toString());
            return this;
        }

        @Override
        public ImportJobProperties build() {
            return new ImportJobProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
