/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.healthlake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The progress report for the import job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobProgressReport implements SdkPojo, Serializable,
        ToCopyableBuilder<JobProgressReport.Builder, JobProgressReport> {
    private static final SdkField<Long> TOTAL_NUMBER_OF_SCANNED_FILES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalNumberOfScannedFiles").getter(getter(JobProgressReport::totalNumberOfScannedFiles))
            .setter(setter(Builder::totalNumberOfScannedFiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfScannedFiles").build())
            .build();

    private static final SdkField<Double> TOTAL_SIZE_OF_SCANNED_FILES_IN_MB_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("TotalSizeOfScannedFilesInMB")
            .getter(getter(JobProgressReport::totalSizeOfScannedFilesInMB))
            .setter(setter(Builder::totalSizeOfScannedFilesInMB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSizeOfScannedFilesInMB")
                    .build()).build();

    private static final SdkField<Long> TOTAL_NUMBER_OF_IMPORTED_FILES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("TotalNumberOfImportedFiles")
            .getter(getter(JobProgressReport::totalNumberOfImportedFiles))
            .setter(setter(Builder::totalNumberOfImportedFiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfImportedFiles").build())
            .build();

    private static final SdkField<Long> TOTAL_NUMBER_OF_RESOURCES_SCANNED_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("TotalNumberOfResourcesScanned")
            .getter(getter(JobProgressReport::totalNumberOfResourcesScanned))
            .setter(setter(Builder::totalNumberOfResourcesScanned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfResourcesScanned")
                    .build()).build();

    private static final SdkField<Long> TOTAL_NUMBER_OF_RESOURCES_IMPORTED_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("TotalNumberOfResourcesImported")
            .getter(getter(JobProgressReport::totalNumberOfResourcesImported))
            .setter(setter(Builder::totalNumberOfResourcesImported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfResourcesImported")
                    .build()).build();

    private static final SdkField<Long> TOTAL_NUMBER_OF_RESOURCES_WITH_CUSTOMER_ERROR_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("TotalNumberOfResourcesWithCustomerError")
            .getter(getter(JobProgressReport::totalNumberOfResourcesWithCustomerError))
            .setter(setter(Builder::totalNumberOfResourcesWithCustomerError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("TotalNumberOfResourcesWithCustomerError").build()).build();

    private static final SdkField<Long> TOTAL_NUMBER_OF_FILES_READ_WITH_CUSTOMER_ERROR_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("TotalNumberOfFilesReadWithCustomerError")
            .getter(getter(JobProgressReport::totalNumberOfFilesReadWithCustomerError))
            .setter(setter(Builder::totalNumberOfFilesReadWithCustomerError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("TotalNumberOfFilesReadWithCustomerError").build()).build();

    private static final SdkField<Double> THROUGHPUT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Throughput").getter(getter(JobProgressReport::throughput)).setter(setter(Builder::throughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Throughput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TOTAL_NUMBER_OF_SCANNED_FILES_FIELD, TOTAL_SIZE_OF_SCANNED_FILES_IN_MB_FIELD, TOTAL_NUMBER_OF_IMPORTED_FILES_FIELD,
            TOTAL_NUMBER_OF_RESOURCES_SCANNED_FIELD, TOTAL_NUMBER_OF_RESOURCES_IMPORTED_FIELD,
            TOTAL_NUMBER_OF_RESOURCES_WITH_CUSTOMER_ERROR_FIELD, TOTAL_NUMBER_OF_FILES_READ_WITH_CUSTOMER_ERROR_FIELD,
            THROUGHPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long totalNumberOfScannedFiles;

    private final Double totalSizeOfScannedFilesInMB;

    private final Long totalNumberOfImportedFiles;

    private final Long totalNumberOfResourcesScanned;

    private final Long totalNumberOfResourcesImported;

    private final Long totalNumberOfResourcesWithCustomerError;

    private final Long totalNumberOfFilesReadWithCustomerError;

    private final Double throughput;

    private JobProgressReport(BuilderImpl builder) {
        this.totalNumberOfScannedFiles = builder.totalNumberOfScannedFiles;
        this.totalSizeOfScannedFilesInMB = builder.totalSizeOfScannedFilesInMB;
        this.totalNumberOfImportedFiles = builder.totalNumberOfImportedFiles;
        this.totalNumberOfResourcesScanned = builder.totalNumberOfResourcesScanned;
        this.totalNumberOfResourcesImported = builder.totalNumberOfResourcesImported;
        this.totalNumberOfResourcesWithCustomerError = builder.totalNumberOfResourcesWithCustomerError;
        this.totalNumberOfFilesReadWithCustomerError = builder.totalNumberOfFilesReadWithCustomerError;
        this.throughput = builder.throughput;
    }

    /**
     * <p>
     * The number of files scanned from the S3 input bucket.
     * </p>
     * 
     * @return The number of files scanned from the S3 input bucket.
     */
    public final Long totalNumberOfScannedFiles() {
        return totalNumberOfScannedFiles;
    }

    /**
     * <p>
     * The size (in MB) of files scanned from the S3 input bucket.
     * </p>
     * 
     * @return The size (in MB) of files scanned from the S3 input bucket.
     */
    public final Double totalSizeOfScannedFilesInMB() {
        return totalSizeOfScannedFilesInMB;
    }

    /**
     * <p>
     * The number of files imported.
     * </p>
     * 
     * @return The number of files imported.
     */
    public final Long totalNumberOfImportedFiles() {
        return totalNumberOfImportedFiles;
    }

    /**
     * <p>
     * The number of resources scanned from the S3 input bucket.
     * </p>
     * 
     * @return The number of resources scanned from the S3 input bucket.
     */
    public final Long totalNumberOfResourcesScanned() {
        return totalNumberOfResourcesScanned;
    }

    /**
     * <p>
     * The number of resources imported.
     * </p>
     * 
     * @return The number of resources imported.
     */
    public final Long totalNumberOfResourcesImported() {
        return totalNumberOfResourcesImported;
    }

    /**
     * <p>
     * The number of resources that failed due to customer error.
     * </p>
     * 
     * @return The number of resources that failed due to customer error.
     */
    public final Long totalNumberOfResourcesWithCustomerError() {
        return totalNumberOfResourcesWithCustomerError;
    }

    /**
     * <p>
     * The number of files that failed to be read from the S3 input bucket due to customer error.
     * </p>
     * 
     * @return The number of files that failed to be read from the S3 input bucket due to customer error.
     */
    public final Long totalNumberOfFilesReadWithCustomerError() {
        return totalNumberOfFilesReadWithCustomerError;
    }

    /**
     * <p>
     * The transaction rate the import job is processed at.
     * </p>
     * 
     * @return The transaction rate the import job is processed at.
     */
    public final Double throughput() {
        return throughput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalNumberOfScannedFiles());
        hashCode = 31 * hashCode + Objects.hashCode(totalSizeOfScannedFilesInMB());
        hashCode = 31 * hashCode + Objects.hashCode(totalNumberOfImportedFiles());
        hashCode = 31 * hashCode + Objects.hashCode(totalNumberOfResourcesScanned());
        hashCode = 31 * hashCode + Objects.hashCode(totalNumberOfResourcesImported());
        hashCode = 31 * hashCode + Objects.hashCode(totalNumberOfResourcesWithCustomerError());
        hashCode = 31 * hashCode + Objects.hashCode(totalNumberOfFilesReadWithCustomerError());
        hashCode = 31 * hashCode + Objects.hashCode(throughput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobProgressReport)) {
            return false;
        }
        JobProgressReport other = (JobProgressReport) obj;
        return Objects.equals(totalNumberOfScannedFiles(), other.totalNumberOfScannedFiles())
                && Objects.equals(totalSizeOfScannedFilesInMB(), other.totalSizeOfScannedFilesInMB())
                && Objects.equals(totalNumberOfImportedFiles(), other.totalNumberOfImportedFiles())
                && Objects.equals(totalNumberOfResourcesScanned(), other.totalNumberOfResourcesScanned())
                && Objects.equals(totalNumberOfResourcesImported(), other.totalNumberOfResourcesImported())
                && Objects.equals(totalNumberOfResourcesWithCustomerError(), other.totalNumberOfResourcesWithCustomerError())
                && Objects.equals(totalNumberOfFilesReadWithCustomerError(), other.totalNumberOfFilesReadWithCustomerError())
                && Objects.equals(throughput(), other.throughput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobProgressReport").add("TotalNumberOfScannedFiles", totalNumberOfScannedFiles())
                .add("TotalSizeOfScannedFilesInMB", totalSizeOfScannedFilesInMB())
                .add("TotalNumberOfImportedFiles", totalNumberOfImportedFiles())
                .add("TotalNumberOfResourcesScanned", totalNumberOfResourcesScanned())
                .add("TotalNumberOfResourcesImported", totalNumberOfResourcesImported())
                .add("TotalNumberOfResourcesWithCustomerError", totalNumberOfResourcesWithCustomerError())
                .add("TotalNumberOfFilesReadWithCustomerError", totalNumberOfFilesReadWithCustomerError())
                .add("Throughput", throughput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalNumberOfScannedFiles":
            return Optional.ofNullable(clazz.cast(totalNumberOfScannedFiles()));
        case "TotalSizeOfScannedFilesInMB":
            return Optional.ofNullable(clazz.cast(totalSizeOfScannedFilesInMB()));
        case "TotalNumberOfImportedFiles":
            return Optional.ofNullable(clazz.cast(totalNumberOfImportedFiles()));
        case "TotalNumberOfResourcesScanned":
            return Optional.ofNullable(clazz.cast(totalNumberOfResourcesScanned()));
        case "TotalNumberOfResourcesImported":
            return Optional.ofNullable(clazz.cast(totalNumberOfResourcesImported()));
        case "TotalNumberOfResourcesWithCustomerError":
            return Optional.ofNullable(clazz.cast(totalNumberOfResourcesWithCustomerError()));
        case "TotalNumberOfFilesReadWithCustomerError":
            return Optional.ofNullable(clazz.cast(totalNumberOfFilesReadWithCustomerError()));
        case "Throughput":
            return Optional.ofNullable(clazz.cast(throughput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TotalNumberOfScannedFiles", TOTAL_NUMBER_OF_SCANNED_FILES_FIELD);
        map.put("TotalSizeOfScannedFilesInMB", TOTAL_SIZE_OF_SCANNED_FILES_IN_MB_FIELD);
        map.put("TotalNumberOfImportedFiles", TOTAL_NUMBER_OF_IMPORTED_FILES_FIELD);
        map.put("TotalNumberOfResourcesScanned", TOTAL_NUMBER_OF_RESOURCES_SCANNED_FIELD);
        map.put("TotalNumberOfResourcesImported", TOTAL_NUMBER_OF_RESOURCES_IMPORTED_FIELD);
        map.put("TotalNumberOfResourcesWithCustomerError", TOTAL_NUMBER_OF_RESOURCES_WITH_CUSTOMER_ERROR_FIELD);
        map.put("TotalNumberOfFilesReadWithCustomerError", TOTAL_NUMBER_OF_FILES_READ_WITH_CUSTOMER_ERROR_FIELD);
        map.put("Throughput", THROUGHPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobProgressReport, T> g) {
        return obj -> g.apply((JobProgressReport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobProgressReport> {
        /**
         * <p>
         * The number of files scanned from the S3 input bucket.
         * </p>
         * 
         * @param totalNumberOfScannedFiles
         *        The number of files scanned from the S3 input bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumberOfScannedFiles(Long totalNumberOfScannedFiles);

        /**
         * <p>
         * The size (in MB) of files scanned from the S3 input bucket.
         * </p>
         * 
         * @param totalSizeOfScannedFilesInMB
         *        The size (in MB) of files scanned from the S3 input bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalSizeOfScannedFilesInMB(Double totalSizeOfScannedFilesInMB);

        /**
         * <p>
         * The number of files imported.
         * </p>
         * 
         * @param totalNumberOfImportedFiles
         *        The number of files imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumberOfImportedFiles(Long totalNumberOfImportedFiles);

        /**
         * <p>
         * The number of resources scanned from the S3 input bucket.
         * </p>
         * 
         * @param totalNumberOfResourcesScanned
         *        The number of resources scanned from the S3 input bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumberOfResourcesScanned(Long totalNumberOfResourcesScanned);

        /**
         * <p>
         * The number of resources imported.
         * </p>
         * 
         * @param totalNumberOfResourcesImported
         *        The number of resources imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumberOfResourcesImported(Long totalNumberOfResourcesImported);

        /**
         * <p>
         * The number of resources that failed due to customer error.
         * </p>
         * 
         * @param totalNumberOfResourcesWithCustomerError
         *        The number of resources that failed due to customer error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumberOfResourcesWithCustomerError(Long totalNumberOfResourcesWithCustomerError);

        /**
         * <p>
         * The number of files that failed to be read from the S3 input bucket due to customer error.
         * </p>
         * 
         * @param totalNumberOfFilesReadWithCustomerError
         *        The number of files that failed to be read from the S3 input bucket due to customer error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumberOfFilesReadWithCustomerError(Long totalNumberOfFilesReadWithCustomerError);

        /**
         * <p>
         * The transaction rate the import job is processed at.
         * </p>
         * 
         * @param throughput
         *        The transaction rate the import job is processed at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughput(Double throughput);
    }

    static final class BuilderImpl implements Builder {
        private Long totalNumberOfScannedFiles;

        private Double totalSizeOfScannedFilesInMB;

        private Long totalNumberOfImportedFiles;

        private Long totalNumberOfResourcesScanned;

        private Long totalNumberOfResourcesImported;

        private Long totalNumberOfResourcesWithCustomerError;

        private Long totalNumberOfFilesReadWithCustomerError;

        private Double throughput;

        private BuilderImpl() {
        }

        private BuilderImpl(JobProgressReport model) {
            totalNumberOfScannedFiles(model.totalNumberOfScannedFiles);
            totalSizeOfScannedFilesInMB(model.totalSizeOfScannedFilesInMB);
            totalNumberOfImportedFiles(model.totalNumberOfImportedFiles);
            totalNumberOfResourcesScanned(model.totalNumberOfResourcesScanned);
            totalNumberOfResourcesImported(model.totalNumberOfResourcesImported);
            totalNumberOfResourcesWithCustomerError(model.totalNumberOfResourcesWithCustomerError);
            totalNumberOfFilesReadWithCustomerError(model.totalNumberOfFilesReadWithCustomerError);
            throughput(model.throughput);
        }

        public final Long getTotalNumberOfScannedFiles() {
            return totalNumberOfScannedFiles;
        }

        public final void setTotalNumberOfScannedFiles(Long totalNumberOfScannedFiles) {
            this.totalNumberOfScannedFiles = totalNumberOfScannedFiles;
        }

        @Override
        public final Builder totalNumberOfScannedFiles(Long totalNumberOfScannedFiles) {
            this.totalNumberOfScannedFiles = totalNumberOfScannedFiles;
            return this;
        }

        public final Double getTotalSizeOfScannedFilesInMB() {
            return totalSizeOfScannedFilesInMB;
        }

        public final void setTotalSizeOfScannedFilesInMB(Double totalSizeOfScannedFilesInMB) {
            this.totalSizeOfScannedFilesInMB = totalSizeOfScannedFilesInMB;
        }

        @Override
        public final Builder totalSizeOfScannedFilesInMB(Double totalSizeOfScannedFilesInMB) {
            this.totalSizeOfScannedFilesInMB = totalSizeOfScannedFilesInMB;
            return this;
        }

        public final Long getTotalNumberOfImportedFiles() {
            return totalNumberOfImportedFiles;
        }

        public final void setTotalNumberOfImportedFiles(Long totalNumberOfImportedFiles) {
            this.totalNumberOfImportedFiles = totalNumberOfImportedFiles;
        }

        @Override
        public final Builder totalNumberOfImportedFiles(Long totalNumberOfImportedFiles) {
            this.totalNumberOfImportedFiles = totalNumberOfImportedFiles;
            return this;
        }

        public final Long getTotalNumberOfResourcesScanned() {
            return totalNumberOfResourcesScanned;
        }

        public final void setTotalNumberOfResourcesScanned(Long totalNumberOfResourcesScanned) {
            this.totalNumberOfResourcesScanned = totalNumberOfResourcesScanned;
        }

        @Override
        public final Builder totalNumberOfResourcesScanned(Long totalNumberOfResourcesScanned) {
            this.totalNumberOfResourcesScanned = totalNumberOfResourcesScanned;
            return this;
        }

        public final Long getTotalNumberOfResourcesImported() {
            return totalNumberOfResourcesImported;
        }

        public final void setTotalNumberOfResourcesImported(Long totalNumberOfResourcesImported) {
            this.totalNumberOfResourcesImported = totalNumberOfResourcesImported;
        }

        @Override
        public final Builder totalNumberOfResourcesImported(Long totalNumberOfResourcesImported) {
            this.totalNumberOfResourcesImported = totalNumberOfResourcesImported;
            return this;
        }

        public final Long getTotalNumberOfResourcesWithCustomerError() {
            return totalNumberOfResourcesWithCustomerError;
        }

        public final void setTotalNumberOfResourcesWithCustomerError(Long totalNumberOfResourcesWithCustomerError) {
            this.totalNumberOfResourcesWithCustomerError = totalNumberOfResourcesWithCustomerError;
        }

        @Override
        public final Builder totalNumberOfResourcesWithCustomerError(Long totalNumberOfResourcesWithCustomerError) {
            this.totalNumberOfResourcesWithCustomerError = totalNumberOfResourcesWithCustomerError;
            return this;
        }

        public final Long getTotalNumberOfFilesReadWithCustomerError() {
            return totalNumberOfFilesReadWithCustomerError;
        }

        public final void setTotalNumberOfFilesReadWithCustomerError(Long totalNumberOfFilesReadWithCustomerError) {
            this.totalNumberOfFilesReadWithCustomerError = totalNumberOfFilesReadWithCustomerError;
        }

        @Override
        public final Builder totalNumberOfFilesReadWithCustomerError(Long totalNumberOfFilesReadWithCustomerError) {
            this.totalNumberOfFilesReadWithCustomerError = totalNumberOfFilesReadWithCustomerError;
            return this;
        }

        public final Double getThroughput() {
            return throughput;
        }

        public final void setThroughput(Double throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Double throughput) {
            this.throughput = throughput;
            return this;
        }

        @Override
        public JobProgressReport build() {
            return new JobProgressReport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
