/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.healthlake.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFhirExportJobsRequest extends HealthLakeRequest implements
        ToCopyableBuilder<ListFhirExportJobsRequest.Builder, ListFhirExportJobsRequest> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatastoreId").getter(getter(ListFhirExportJobsRequest::datastoreId))
            .setter(setter(Builder::datastoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFhirExportJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListFhirExportJobsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(ListFhirExportJobsRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(ListFhirExportJobsRequest::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<Instant> SUBMITTED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmittedBefore").getter(getter(ListFhirExportJobsRequest::submittedBefore))
            .setter(setter(Builder::submittedBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmittedBefore").build()).build();

    private static final SdkField<Instant> SUBMITTED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmittedAfter").getter(getter(ListFhirExportJobsRequest::submittedAfter))
            .setter(setter(Builder::submittedAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmittedAfter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, JOB_NAME_FIELD,
                    JOB_STATUS_FIELD, SUBMITTED_BEFORE_FIELD, SUBMITTED_AFTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String datastoreId;

    private final String nextToken;

    private final Integer maxResults;

    private final String jobName;

    private final String jobStatus;

    private final Instant submittedBefore;

    private final Instant submittedAfter;

    private ListFhirExportJobsRequest(BuilderImpl builder) {
        super(builder);
        this.datastoreId = builder.datastoreId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.jobName = builder.jobName;
        this.jobStatus = builder.jobStatus;
        this.submittedBefore = builder.submittedBefore;
        this.submittedAfter = builder.submittedAfter;
    }

    /**
     * <p>
     * Limits the response to the export job with the specified data store ID.
     * </p>
     * 
     * @return Limits the response to the export job with the specified data store ID.
     */
    public final String datastoreId() {
        return datastoreId;
    }

    /**
     * <p>
     * A pagination token used to identify the next page of results to return.
     * </p>
     * 
     * @return A pagination token used to identify the next page of results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Limits the number of results returned for a ListFHIRExportJobs to a maximum quantity specified by the user.
     * </p>
     * 
     * @return Limits the number of results returned for a ListFHIRExportJobs to a maximum quantity specified by the
     *         user.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Limits the response to the export job with the specified job name.
     * </p>
     * 
     * @return Limits the response to the export job with the specified job name.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * Limits the response to export jobs with the specified job status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return Limits the response to export jobs with the specified job status.
     * @see JobStatus
     */
    public final JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * Limits the response to export jobs with the specified job status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return Limits the response to export jobs with the specified job status.
     * @see JobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * Limits the response to FHIR export jobs submitted before a user- specified date.
     * </p>
     * 
     * @return Limits the response to FHIR export jobs submitted before a user- specified date.
     */
    public final Instant submittedBefore() {
        return submittedBefore;
    }

    /**
     * <p>
     * Limits the response to FHIR export jobs submitted after a user-specified date.
     * </p>
     * 
     * @return Limits the response to FHIR export jobs submitted after a user-specified date.
     */
    public final Instant submittedAfter() {
        return submittedAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(submittedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(submittedAfter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFhirExportJobsRequest)) {
            return false;
        }
        ListFhirExportJobsRequest other = (ListFhirExportJobsRequest) obj;
        return Objects.equals(datastoreId(), other.datastoreId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(submittedBefore(), other.submittedBefore())
                && Objects.equals(submittedAfter(), other.submittedAfter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFhirExportJobsRequest").add("DatastoreId", datastoreId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("JobName", jobName()).add("JobStatus", jobStatusAsString())
                .add("SubmittedBefore", submittedBefore()).add("SubmittedAfter", submittedAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatastoreId":
            return Optional.ofNullable(clazz.cast(datastoreId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "SubmittedBefore":
            return Optional.ofNullable(clazz.cast(submittedBefore()));
        case "SubmittedAfter":
            return Optional.ofNullable(clazz.cast(submittedAfter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatastoreId", DATASTORE_ID_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("JobName", JOB_NAME_FIELD);
        map.put("JobStatus", JOB_STATUS_FIELD);
        map.put("SubmittedBefore", SUBMITTED_BEFORE_FIELD);
        map.put("SubmittedAfter", SUBMITTED_AFTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFhirExportJobsRequest, T> g) {
        return obj -> g.apply((ListFhirExportJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends HealthLakeRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListFhirExportJobsRequest> {
        /**
         * <p>
         * Limits the response to the export job with the specified data store ID.
         * </p>
         * 
         * @param datastoreId
         *        Limits the response to the export job with the specified data store ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreId(String datastoreId);

        /**
         * <p>
         * A pagination token used to identify the next page of results to return.
         * </p>
         * 
         * @param nextToken
         *        A pagination token used to identify the next page of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Limits the number of results returned for a ListFHIRExportJobs to a maximum quantity specified by the user.
         * </p>
         * 
         * @param maxResults
         *        Limits the number of results returned for a ListFHIRExportJobs to a maximum quantity specified by the
         *        user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Limits the response to the export job with the specified job name.
         * </p>
         * 
         * @param jobName
         *        Limits the response to the export job with the specified job name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * Limits the response to export jobs with the specified job status.
         * </p>
         * 
         * @param jobStatus
         *        Limits the response to export jobs with the specified job status.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * Limits the response to export jobs with the specified job status.
         * </p>
         * 
         * @param jobStatus
         *        Limits the response to export jobs with the specified job status.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * Limits the response to FHIR export jobs submitted before a user- specified date.
         * </p>
         * 
         * @param submittedBefore
         *        Limits the response to FHIR export jobs submitted before a user- specified date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedBefore(Instant submittedBefore);

        /**
         * <p>
         * Limits the response to FHIR export jobs submitted after a user-specified date.
         * </p>
         * 
         * @param submittedAfter
         *        Limits the response to FHIR export jobs submitted after a user-specified date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedAfter(Instant submittedAfter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends HealthLakeRequest.BuilderImpl implements Builder {
        private String datastoreId;

        private String nextToken;

        private Integer maxResults;

        private String jobName;

        private String jobStatus;

        private Instant submittedBefore;

        private Instant submittedAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFhirExportJobsRequest model) {
            super(model);
            datastoreId(model.datastoreId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            jobName(model.jobName);
            jobStatus(model.jobStatus);
            submittedBefore(model.submittedBefore);
            submittedAfter(model.submittedAfter);
        }

        public final String getDatastoreId() {
            return datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final Instant getSubmittedBefore() {
            return submittedBefore;
        }

        public final void setSubmittedBefore(Instant submittedBefore) {
            this.submittedBefore = submittedBefore;
        }

        @Override
        public final Builder submittedBefore(Instant submittedBefore) {
            this.submittedBefore = submittedBefore;
            return this;
        }

        public final Instant getSubmittedAfter() {
            return submittedAfter;
        }

        public final void setSubmittedAfter(Instant submittedAfter) {
            this.submittedAfter = submittedAfter;
        }

        @Override
        public final Builder submittedAfter(Instant submittedAfter) {
            this.submittedAfter = submittedAfter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFhirExportJobsRequest build() {
            return new ListFhirExportJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
