/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.healthlake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output data configuration supplied when the export job was created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputDataConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<OutputDataConfig.Builder, OutputDataConfig> {
    private static final SdkField<S3Configuration> S3_CONFIGURATION_FIELD = SdkField
            .<S3Configuration> builder(MarshallingType.SDK_POJO).memberName("S3Configuration")
            .getter(getter(OutputDataConfig::s3Configuration)).setter(setter(Builder::s3Configuration))
            .constructor(S3Configuration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3Configuration s3Configuration;

    private final Type type;

    private OutputDataConfig(BuilderImpl builder) {
        this.s3Configuration = builder.s3Configuration;
        this.type = builder.type;
    }

    /**
     * <p>
     * The output data configuration supplied when the export job was created.
     * </p>
     * 
     * @return The output data configuration supplied when the export job was created.
     */
    public final S3Configuration s3Configuration() {
        return s3Configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputDataConfig)) {
            return false;
        }
        OutputDataConfig other = (OutputDataConfig) obj;
        return Objects.equals(s3Configuration(), other.s3Configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputDataConfig").add("S3Configuration", s3Configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Configuration":
            return Optional.ofNullable(clazz.cast(s3Configuration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #s3Configuration()} initialized to the given value.
     *
     * <p>
     * The output data configuration supplied when the export job was created.
     * </p>
     * 
     * @param s3Configuration
     *        The output data configuration supplied when the export job was created.
     */
    public static OutputDataConfig fromS3Configuration(S3Configuration s3Configuration) {
        return builder().s3Configuration(s3Configuration).build();
    }

    /**
     * Create an instance of this class with {@link #s3Configuration()} initialized to the given value.
     *
     * <p>
     * The output data configuration supplied when the export job was created.
     * </p>
     * 
     * @param s3Configuration
     *        The output data configuration supplied when the export job was created.
     */
    public static OutputDataConfig fromS3Configuration(Consumer<S3Configuration.Builder> s3Configuration) {
        S3Configuration.Builder builder = S3Configuration.builder();
        s3Configuration.accept(builder);
        return fromS3Configuration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3Configuration", S3_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutputDataConfig, T> g) {
        return obj -> g.apply((OutputDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputDataConfig> {
        /**
         * <p>
         * The output data configuration supplied when the export job was created.
         * </p>
         * 
         * @param s3Configuration
         *        The output data configuration supplied when the export job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Configuration(S3Configuration s3Configuration);

        /**
         * <p>
         * The output data configuration supplied when the export job was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Configuration.Builder} avoiding the
         * need to create one manually via {@link S3Configuration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Configuration.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Configuration(S3Configuration)}.
         * 
         * @param s3Configuration
         *        a consumer that will call methods on {@link S3Configuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Configuration(S3Configuration)
         */
        default Builder s3Configuration(Consumer<S3Configuration.Builder> s3Configuration) {
            return s3Configuration(S3Configuration.builder().applyMutation(s3Configuration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3Configuration s3Configuration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(OutputDataConfig model) {
            s3Configuration(model.s3Configuration);
        }

        public final S3Configuration.Builder getS3Configuration() {
            return s3Configuration != null ? s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3Configuration.BuilderImpl s3Configuration) {
            Object oldValue = this.s3Configuration;
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
            handleUnionValueChange(Type.S3_CONFIGURATION, oldValue, this.s3Configuration);
        }

        @Override
        public final Builder s3Configuration(S3Configuration s3Configuration) {
            Object oldValue = this.s3Configuration;
            this.s3Configuration = s3Configuration;
            handleUnionValueChange(Type.S3_CONFIGURATION, oldValue, this.s3Configuration);
            return this;
        }

        @Override
        public OutputDataConfig build() {
            return new OutputDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see OutputDataConfig#type()
     */
    public enum Type {
        S3_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
