/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.honeycode.model.GetScreenDataRequest;
import software.amazon.awssdk.services.honeycode.model.GetScreenDataResponse;
import software.amazon.awssdk.services.honeycode.model.InvokeScreenAutomationRequest;
import software.amazon.awssdk.services.honeycode.model.InvokeScreenAutomationResponse;

/**
 * Service client for accessing Honeycode asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon Honeycode is a fully managed service that allows you to quickly build mobile and web apps for teams—without
 * programming. Build Honeycode apps for managing almost anything, like projects, customers, operations, approvals,
 * resources, and even your team.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface HoneycodeAsyncClient extends SdkClient {
    String SERVICE_NAME = "honeycode";

    /**
     * Create a {@link HoneycodeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static HoneycodeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link HoneycodeAsyncClient}.
     */
    static HoneycodeAsyncClientBuilder builder() {
        return new DefaultHoneycodeAsyncClientBuilder();
    }

    /**
     * <p>
     * The GetScreenData API allows retrieval of data from a screen in a Honeycode app. The API allows setting local
     * variables in the screen to filter, sort or otherwise affect what will be displayed on the screen.
     * </p>
     *
     * @param getScreenDataRequest
     * @return A Java Future containing the result of the GetScreenData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the screen/automation in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ResourceNotFoundException A Workbook, App, Screen or Screen Automation was not found with the given
     *         ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.GetScreenData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/GetScreenData" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetScreenDataResponse> getScreenData(GetScreenDataRequest getScreenDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The GetScreenData API allows retrieval of data from a screen in a Honeycode app. The API allows setting local
     * variables in the screen to filter, sort or otherwise affect what will be displayed on the screen.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetScreenDataRequest.Builder} avoiding the need to
     * create one manually via {@link GetScreenDataRequest#builder()}
     * </p>
     *
     * @param getScreenDataRequest
     *        A {@link Consumer} that will call methods on {@link GetScreenDataRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetScreenData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the screen/automation in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ResourceNotFoundException A Workbook, App, Screen or Screen Automation was not found with the given
     *         ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.GetScreenData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/GetScreenData" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetScreenDataResponse> getScreenData(Consumer<GetScreenDataRequest.Builder> getScreenDataRequest) {
        return getScreenData(GetScreenDataRequest.builder().applyMutation(getScreenDataRequest).build());
    }

    /**
     * <p>
     * The InvokeScreenAutomation API allows invoking an action defined in a screen in a Honeycode app. The API allows
     * setting local variables, which can then be used in the automation being invoked. This allows automating the
     * Honeycode app interactions to write, update or delete data in the workbook.
     * </p>
     *
     * @param invokeScreenAutomationRequest
     * @return A Java Future containing the result of the InvokeScreenAutomation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the screen/automation in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>ResourceNotFoundException A Workbook, App, Screen or Screen Automation was not found with the given
     *         ID.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>AutomationExecutionException The automation execution did not end successfully.</li>
     *         <li>AutomationExecutionTimeoutException The automation execution timed out.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.InvokeScreenAutomation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/InvokeScreenAutomation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<InvokeScreenAutomationResponse> invokeScreenAutomation(
            InvokeScreenAutomationRequest invokeScreenAutomationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The InvokeScreenAutomation API allows invoking an action defined in a screen in a Honeycode app. The API allows
     * setting local variables, which can then be used in the automation being invoked. This allows automating the
     * Honeycode app interactions to write, update or delete data in the workbook.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeScreenAutomationRequest.Builder} avoiding the
     * need to create one manually via {@link InvokeScreenAutomationRequest#builder()}
     * </p>
     *
     * @param invokeScreenAutomationRequest
     *        A {@link Consumer} that will call methods on {@link InvokeScreenAutomationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the InvokeScreenAutomation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the screen/automation in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>ResourceNotFoundException A Workbook, App, Screen or Screen Automation was not found with the given
     *         ID.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>AutomationExecutionException The automation execution did not end successfully.</li>
     *         <li>AutomationExecutionTimeoutException The automation execution timed out.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.InvokeScreenAutomation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/InvokeScreenAutomation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<InvokeScreenAutomationResponse> invokeScreenAutomation(
            Consumer<InvokeScreenAutomationRequest.Builder> invokeScreenAutomationRequest) {
        return invokeScreenAutomation(InvokeScreenAutomationRequest.builder().applyMutation(invokeScreenAutomationRequest)
                .build());
    }
}
