/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.honeycode.model.AccessDeniedException;
import software.amazon.awssdk.services.honeycode.model.AutomationExecutionException;
import software.amazon.awssdk.services.honeycode.model.AutomationExecutionTimeoutException;
import software.amazon.awssdk.services.honeycode.model.GetScreenDataRequest;
import software.amazon.awssdk.services.honeycode.model.GetScreenDataResponse;
import software.amazon.awssdk.services.honeycode.model.HoneycodeException;
import software.amazon.awssdk.services.honeycode.model.InternalServerException;
import software.amazon.awssdk.services.honeycode.model.InvokeScreenAutomationRequest;
import software.amazon.awssdk.services.honeycode.model.InvokeScreenAutomationResponse;
import software.amazon.awssdk.services.honeycode.model.RequestTimeoutException;
import software.amazon.awssdk.services.honeycode.model.ResourceNotFoundException;
import software.amazon.awssdk.services.honeycode.model.ServiceUnavailableException;
import software.amazon.awssdk.services.honeycode.model.ThrottlingException;
import software.amazon.awssdk.services.honeycode.model.ValidationException;

/**
 * Service client for accessing Honeycode. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Honeycode is a fully managed service that allows you to quickly build mobile and web apps for teams—without
 * programming. Build Honeycode apps for managing almost anything, like projects, customers, operations, approvals,
 * resources, and even your team.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface HoneycodeClient extends SdkClient {
    String SERVICE_NAME = "honeycode";

    /**
     * Create a {@link HoneycodeClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static HoneycodeClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link HoneycodeClient}.
     */
    static HoneycodeClientBuilder builder() {
        return new DefaultHoneycodeClientBuilder();
    }

    /**
     * <p>
     * The GetScreenData API allows retrieval of data from a screen in a Honeycode app. The API allows setting local
     * variables in the screen to filter, sort or otherwise affect what will be displayed on the screen.
     * </p>
     *
     * @param getScreenDataRequest
     * @return Result of the GetScreenData operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the screen/automation in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ResourceNotFoundException
     *         A Workbook, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.GetScreenData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/GetScreenData" target="_top">AWS API
     *      Documentation</a>
     */
    default GetScreenDataResponse getScreenData(GetScreenDataRequest getScreenDataRequest) throws AccessDeniedException,
            InternalServerException, RequestTimeoutException, ResourceNotFoundException, ServiceUnavailableException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException, HoneycodeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The GetScreenData API allows retrieval of data from a screen in a Honeycode app. The API allows setting local
     * variables in the screen to filter, sort or otherwise affect what will be displayed on the screen.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetScreenDataRequest.Builder} avoiding the need to
     * create one manually via {@link GetScreenDataRequest#builder()}
     * </p>
     *
     * @param getScreenDataRequest
     *        A {@link Consumer} that will call methods on {@link GetScreenDataRequest.Builder} to create a request.
     * @return Result of the GetScreenData operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the screen/automation in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ResourceNotFoundException
     *         A Workbook, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.GetScreenData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/GetScreenData" target="_top">AWS API
     *      Documentation</a>
     */
    default GetScreenDataResponse getScreenData(Consumer<GetScreenDataRequest.Builder> getScreenDataRequest)
            throws AccessDeniedException, InternalServerException, RequestTimeoutException, ResourceNotFoundException,
            ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            HoneycodeException {
        return getScreenData(GetScreenDataRequest.builder().applyMutation(getScreenDataRequest).build());
    }

    /**
     * <p>
     * The InvokeScreenAutomation API allows invoking an action defined in a screen in a Honeycode app. The API allows
     * setting local variables, which can then be used in the automation being invoked. This allows automating the
     * Honeycode app interactions to write, update or delete data in the workbook.
     * </p>
     *
     * @param invokeScreenAutomationRequest
     * @return Result of the InvokeScreenAutomation operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the screen/automation in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws ResourceNotFoundException
     *         A Workbook, App, Screen or Screen Automation was not found with the given ID.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws AutomationExecutionException
     *         The automation execution did not end successfully.
     * @throws AutomationExecutionTimeoutException
     *         The automation execution timed out.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.InvokeScreenAutomation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/InvokeScreenAutomation"
     *      target="_top">AWS API Documentation</a>
     */
    default InvokeScreenAutomationResponse invokeScreenAutomation(InvokeScreenAutomationRequest invokeScreenAutomationRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ValidationException,
            ThrottlingException, ServiceUnavailableException, AutomationExecutionException, AutomationExecutionTimeoutException,
            RequestTimeoutException, AwsServiceException, SdkClientException, HoneycodeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The InvokeScreenAutomation API allows invoking an action defined in a screen in a Honeycode app. The API allows
     * setting local variables, which can then be used in the automation being invoked. This allows automating the
     * Honeycode app interactions to write, update or delete data in the workbook.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeScreenAutomationRequest.Builder} avoiding the
     * need to create one manually via {@link InvokeScreenAutomationRequest#builder()}
     * </p>
     *
     * @param invokeScreenAutomationRequest
     *        A {@link Consumer} that will call methods on {@link InvokeScreenAutomationRequest.Builder} to create a
     *        request.
     * @return Result of the InvokeScreenAutomation operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the screen/automation in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws ResourceNotFoundException
     *         A Workbook, App, Screen or Screen Automation was not found with the given ID.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws AutomationExecutionException
     *         The automation execution did not end successfully.
     * @throws AutomationExecutionTimeoutException
     *         The automation execution timed out.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.InvokeScreenAutomation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/InvokeScreenAutomation"
     *      target="_top">AWS API Documentation</a>
     */
    default InvokeScreenAutomationResponse invokeScreenAutomation(
            Consumer<InvokeScreenAutomationRequest.Builder> invokeScreenAutomationRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ValidationException, ThrottlingException,
            ServiceUnavailableException, AutomationExecutionException, AutomationExecutionTimeoutException,
            RequestTimeoutException, AwsServiceException, SdkClientException, HoneycodeException {
        return invokeScreenAutomation(InvokeScreenAutomationRequest.builder().applyMutation(invokeScreenAutomationRequest)
                .build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("honeycode");
    }
}
