/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data in a particular data cell defined on the screen.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataItem implements SdkPojo, Serializable, ToCopyableBuilder<DataItem.Builder, DataItem> {
    private static final SdkField<String> OVERRIDE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataItem::overrideFormatAsString)).setter(setter(Builder::overrideFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideFormat").build()).build();

    private static final SdkField<String> RAW_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataItem::rawValue)).setter(setter(Builder::rawValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawValue").build()).build();

    private static final SdkField<String> FORMATTED_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataItem::formattedValue)).setter(setter(Builder::formattedValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formattedValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OVERRIDE_FORMAT_FIELD,
            RAW_VALUE_FIELD, FORMATTED_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String overrideFormat;

    private final String rawValue;

    private final String formattedValue;

    private DataItem(BuilderImpl builder) {
        this.overrideFormat = builder.overrideFormat;
        this.rawValue = builder.rawValue;
        this.formattedValue = builder.formattedValue;
    }

    /**
     * <p>
     * The overrideFormat is optional and is specified only if a particular row of data has a different format for the
     * data than the default format defined on the screen or the table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overrideFormat}
     * will return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #overrideFormatAsString}.
     * </p>
     * 
     * @return The overrideFormat is optional and is specified only if a particular row of data has a different format
     *         for the data than the default format defined on the screen or the table.
     * @see Format
     */
    public Format overrideFormat() {
        return Format.fromValue(overrideFormat);
    }

    /**
     * <p>
     * The overrideFormat is optional and is specified only if a particular row of data has a different format for the
     * data than the default format defined on the screen or the table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overrideFormat}
     * will return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #overrideFormatAsString}.
     * </p>
     * 
     * @return The overrideFormat is optional and is specified only if a particular row of data has a different format
     *         for the data than the default format defined on the screen or the table.
     * @see Format
     */
    public String overrideFormatAsString() {
        return overrideFormat;
    }

    /**
     * <p>
     * The raw value of the data. e.g. jsmith@example.com
     * </p>
     * 
     * @return The raw value of the data. e.g. jsmith@example.com
     */
    public String rawValue() {
        return rawValue;
    }

    /**
     * <p>
     * The formatted value of the data. e.g. John Smith.
     * </p>
     * 
     * @return The formatted value of the data. e.g. John Smith.
     */
    public String formattedValue() {
        return formattedValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(overrideFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rawValue());
        hashCode = 31 * hashCode + Objects.hashCode(formattedValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataItem)) {
            return false;
        }
        DataItem other = (DataItem) obj;
        return Objects.equals(overrideFormatAsString(), other.overrideFormatAsString())
                && Objects.equals(rawValue(), other.rawValue()) && Objects.equals(formattedValue(), other.formattedValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DataItem").add("OverrideFormat", overrideFormatAsString()).add("RawValue", rawValue())
                .add("FormattedValue", formattedValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "overrideFormat":
            return Optional.ofNullable(clazz.cast(overrideFormatAsString()));
        case "rawValue":
            return Optional.ofNullable(clazz.cast(rawValue()));
        case "formattedValue":
            return Optional.ofNullable(clazz.cast(formattedValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataItem, T> g) {
        return obj -> g.apply((DataItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataItem> {
        /**
         * <p>
         * The overrideFormat is optional and is specified only if a particular row of data has a different format for
         * the data than the default format defined on the screen or the table.
         * </p>
         * 
         * @param overrideFormat
         *        The overrideFormat is optional and is specified only if a particular row of data has a different
         *        format for the data than the default format defined on the screen or the table.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder overrideFormat(String overrideFormat);

        /**
         * <p>
         * The overrideFormat is optional and is specified only if a particular row of data has a different format for
         * the data than the default format defined on the screen or the table.
         * </p>
         * 
         * @param overrideFormat
         *        The overrideFormat is optional and is specified only if a particular row of data has a different
         *        format for the data than the default format defined on the screen or the table.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder overrideFormat(Format overrideFormat);

        /**
         * <p>
         * The raw value of the data. e.g. jsmith@example.com
         * </p>
         * 
         * @param rawValue
         *        The raw value of the data. e.g. jsmith@example.com
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawValue(String rawValue);

        /**
         * <p>
         * The formatted value of the data. e.g. John Smith.
         * </p>
         * 
         * @param formattedValue
         *        The formatted value of the data. e.g. John Smith.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formattedValue(String formattedValue);
    }

    static final class BuilderImpl implements Builder {
        private String overrideFormat;

        private String rawValue;

        private String formattedValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DataItem model) {
            overrideFormat(model.overrideFormat);
            rawValue(model.rawValue);
            formattedValue(model.formattedValue);
        }

        public final String getOverrideFormat() {
            return overrideFormat;
        }

        @Override
        public final Builder overrideFormat(String overrideFormat) {
            this.overrideFormat = overrideFormat;
            return this;
        }

        @Override
        public final Builder overrideFormat(Format overrideFormat) {
            this.overrideFormat(overrideFormat == null ? null : overrideFormat.toString());
            return this;
        }

        public final void setOverrideFormat(String overrideFormat) {
            this.overrideFormat = overrideFormat;
        }

        public final String getRawValue() {
            return rawValue;
        }

        @Override
        public final Builder rawValue(String rawValue) {
            this.rawValue = rawValue;
            return this;
        }

        public final void setRawValue(String rawValue) {
            this.rawValue = rawValue;
        }

        public final String getFormattedValue() {
            return formattedValue;
        }

        @Override
        public final Builder formattedValue(String formattedValue) {
            this.formattedValue = formattedValue;
            return this;
        }

        public final void setFormattedValue(String formattedValue) {
            this.formattedValue = formattedValue;
        }

        @Override
        public DataItem build() {
            return new DataItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
