/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.honeycode.model.Format;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cell
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cell> {
    private static final SdkField<String> FORMULA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("formula").getter(Cell.getter(Cell::formula)).setter(Cell.setter(Builder::formula)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formula").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(Cell.getter(Cell::formatAsString)).setter(Cell.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> RAW_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rawValue").getter(Cell.getter(Cell::rawValue)).setter(Cell.setter(Builder::rawValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawValue").build()}).build();
    private static final SdkField<String> FORMATTED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("formattedValue").getter(Cell.getter(Cell::formattedValue)).setter(Cell.setter(Builder::formattedValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formattedValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMULA_FIELD, FORMAT_FIELD, RAW_VALUE_FIELD, FORMATTED_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String formula;
    private final String format;
    private final String rawValue;
    private final String formattedValue;

    private Cell(BuilderImpl builder) {
        this.formula = builder.formula;
        this.format = builder.format;
        this.rawValue = builder.rawValue;
        this.formattedValue = builder.formattedValue;
    }

    public String formula() {
        return this.formula;
    }

    public Format format() {
        return Format.fromValue(this.format);
    }

    public String formatAsString() {
        return this.format;
    }

    public String rawValue() {
        return this.rawValue;
    }

    public String formattedValue() {
        return this.formattedValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formula());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.formattedValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cell)) {
            return false;
        }
        Cell other = (Cell)obj;
        return Objects.equals(this.formula(), other.formula()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.rawValue(), other.rawValue()) && Objects.equals(this.formattedValue(), other.formattedValue());
    }

    public String toString() {
        return ToString.builder((String)"Cell").add("Formula", (Object)(this.formula() == null ? null : "*** Sensitive Data Redacted ***")).add("Format", (Object)this.formatAsString()).add("RawValue", (Object)this.rawValue()).add("FormattedValue", (Object)this.formattedValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "formula": {
                return Optional.ofNullable(clazz.cast(this.formula()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "rawValue": {
                return Optional.ofNullable(clazz.cast(this.rawValue()));
            }
            case "formattedValue": {
                return Optional.ofNullable(clazz.cast(this.formattedValue()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cell, T> g) {
        return obj -> g.apply((Cell)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String formula;
        private String format;
        private String rawValue;
        private String formattedValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Cell model) {
            this.formula(model.formula);
            this.format(model.format);
            this.rawValue(model.rawValue);
            this.formattedValue(model.formattedValue);
        }

        public final String getFormula() {
            return this.formula;
        }

        @Override
        public final Builder formula(String formula) {
            this.formula = formula;
            return this;
        }

        public final void setFormula(String formula) {
            this.formula = formula;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getRawValue() {
            return this.rawValue;
        }

        @Override
        public final Builder rawValue(String rawValue) {
            this.rawValue = rawValue;
            return this;
        }

        public final void setRawValue(String rawValue) {
            this.rawValue = rawValue;
        }

        public final String getFormattedValue() {
            return this.formattedValue;
        }

        @Override
        public final Builder formattedValue(String formattedValue) {
            this.formattedValue = formattedValue;
            return this;
        }

        public final void setFormattedValue(String formattedValue) {
            this.formattedValue = formattedValue;
        }

        public Cell build() {
            return new Cell(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cell> {
        public Builder formula(String var1);

        public Builder format(String var1);

        public Builder format(Format var1);

        public Builder rawValue(String var1);

        public Builder formattedValue(String var1);
    }
}

