/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DelimitedTextImportOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DelimitedTextImportOptions> {
    private static final SdkField<String> DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("delimiter").getter(DelimitedTextImportOptions.getter(DelimitedTextImportOptions::delimiter)).setter(DelimitedTextImportOptions.setter(Builder::delimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delimiter").build()}).build();
    private static final SdkField<Boolean> HAS_HEADER_ROW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("hasHeaderRow").getter(DelimitedTextImportOptions.getter(DelimitedTextImportOptions::hasHeaderRow)).setter(DelimitedTextImportOptions.setter(Builder::hasHeaderRow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasHeaderRow").build()}).build();
    private static final SdkField<Boolean> IGNORE_EMPTY_ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ignoreEmptyRows").getter(DelimitedTextImportOptions.getter(DelimitedTextImportOptions::ignoreEmptyRows)).setter(DelimitedTextImportOptions.setter(Builder::ignoreEmptyRows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignoreEmptyRows").build()}).build();
    private static final SdkField<String> DATA_CHARACTER_ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataCharacterEncoding").getter(DelimitedTextImportOptions.getter(DelimitedTextImportOptions::dataCharacterEncodingAsString)).setter(DelimitedTextImportOptions.setter(Builder::dataCharacterEncoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataCharacterEncoding").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIMITER_FIELD, HAS_HEADER_ROW_FIELD, IGNORE_EMPTY_ROWS_FIELD, DATA_CHARACTER_ENCODING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String delimiter;
    private final Boolean hasHeaderRow;
    private final Boolean ignoreEmptyRows;
    private final String dataCharacterEncoding;

    private DelimitedTextImportOptions(BuilderImpl builder) {
        this.delimiter = builder.delimiter;
        this.hasHeaderRow = builder.hasHeaderRow;
        this.ignoreEmptyRows = builder.ignoreEmptyRows;
        this.dataCharacterEncoding = builder.dataCharacterEncoding;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public Boolean hasHeaderRow() {
        return this.hasHeaderRow;
    }

    public Boolean ignoreEmptyRows() {
        return this.ignoreEmptyRows;
    }

    public ImportDataCharacterEncoding dataCharacterEncoding() {
        return ImportDataCharacterEncoding.fromValue(this.dataCharacterEncoding);
    }

    public String dataCharacterEncodingAsString() {
        return this.dataCharacterEncoding;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.delimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaderRow());
        hashCode = 31 * hashCode + Objects.hashCode(this.ignoreEmptyRows());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCharacterEncodingAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DelimitedTextImportOptions)) {
            return false;
        }
        DelimitedTextImportOptions other = (DelimitedTextImportOptions)obj;
        return Objects.equals(this.delimiter(), other.delimiter()) && Objects.equals(this.hasHeaderRow(), other.hasHeaderRow()) && Objects.equals(this.ignoreEmptyRows(), other.ignoreEmptyRows()) && Objects.equals(this.dataCharacterEncodingAsString(), other.dataCharacterEncodingAsString());
    }

    public String toString() {
        return ToString.builder((String)"DelimitedTextImportOptions").add("Delimiter", (Object)this.delimiter()).add("HasHeaderRow", (Object)this.hasHeaderRow()).add("IgnoreEmptyRows", (Object)this.ignoreEmptyRows()).add("DataCharacterEncoding", (Object)this.dataCharacterEncodingAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "delimiter": {
                return Optional.ofNullable(clazz.cast(this.delimiter()));
            }
            case "hasHeaderRow": {
                return Optional.ofNullable(clazz.cast(this.hasHeaderRow()));
            }
            case "ignoreEmptyRows": {
                return Optional.ofNullable(clazz.cast(this.ignoreEmptyRows()));
            }
            case "dataCharacterEncoding": {
                return Optional.ofNullable(clazz.cast(this.dataCharacterEncodingAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DelimitedTextImportOptions, T> g) {
        return obj -> g.apply((DelimitedTextImportOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String delimiter;
        private Boolean hasHeaderRow;
        private Boolean ignoreEmptyRows;
        private String dataCharacterEncoding;

        private BuilderImpl() {
        }

        private BuilderImpl(DelimitedTextImportOptions model) {
            this.delimiter(model.delimiter);
            this.hasHeaderRow(model.hasHeaderRow);
            this.ignoreEmptyRows(model.ignoreEmptyRows);
            this.dataCharacterEncoding(model.dataCharacterEncoding);
        }

        public final String getDelimiter() {
            return this.delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public final Boolean getHasHeaderRow() {
            return this.hasHeaderRow;
        }

        @Override
        public final Builder hasHeaderRow(Boolean hasHeaderRow) {
            this.hasHeaderRow = hasHeaderRow;
            return this;
        }

        public final void setHasHeaderRow(Boolean hasHeaderRow) {
            this.hasHeaderRow = hasHeaderRow;
        }

        public final Boolean getIgnoreEmptyRows() {
            return this.ignoreEmptyRows;
        }

        @Override
        public final Builder ignoreEmptyRows(Boolean ignoreEmptyRows) {
            this.ignoreEmptyRows = ignoreEmptyRows;
            return this;
        }

        public final void setIgnoreEmptyRows(Boolean ignoreEmptyRows) {
            this.ignoreEmptyRows = ignoreEmptyRows;
        }

        public final String getDataCharacterEncoding() {
            return this.dataCharacterEncoding;
        }

        @Override
        public final Builder dataCharacterEncoding(String dataCharacterEncoding) {
            this.dataCharacterEncoding = dataCharacterEncoding;
            return this;
        }

        @Override
        public final Builder dataCharacterEncoding(ImportDataCharacterEncoding dataCharacterEncoding) {
            this.dataCharacterEncoding(dataCharacterEncoding == null ? null : dataCharacterEncoding.toString());
            return this;
        }

        public final void setDataCharacterEncoding(String dataCharacterEncoding) {
            this.dataCharacterEncoding = dataCharacterEncoding;
        }

        public DelimitedTextImportOptions build() {
            return new DelimitedTextImportOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DelimitedTextImportOptions> {
        public Builder delimiter(String var1);

        public Builder hasHeaderRow(Boolean var1);

        public Builder ignoreEmptyRows(Boolean var1);

        public Builder dataCharacterEncoding(String var1);

        public Builder dataCharacterEncoding(ImportDataCharacterEncoding var1);
    }
}

