/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.honeycode.model.AccessDeniedException;
import software.amazon.awssdk.services.honeycode.model.AutomationExecutionException;
import software.amazon.awssdk.services.honeycode.model.AutomationExecutionTimeoutException;
import software.amazon.awssdk.services.honeycode.model.BatchCreateTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.BatchCreateTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.BatchDeleteTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.BatchDeleteTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.BatchUpdateTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.BatchUpdateTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.BatchUpsertTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.BatchUpsertTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.DescribeTableDataImportJobRequest;
import software.amazon.awssdk.services.honeycode.model.DescribeTableDataImportJobResponse;
import software.amazon.awssdk.services.honeycode.model.GetScreenDataRequest;
import software.amazon.awssdk.services.honeycode.model.GetScreenDataResponse;
import software.amazon.awssdk.services.honeycode.model.HoneycodeException;
import software.amazon.awssdk.services.honeycode.model.InternalServerException;
import software.amazon.awssdk.services.honeycode.model.InvokeScreenAutomationRequest;
import software.amazon.awssdk.services.honeycode.model.InvokeScreenAutomationResponse;
import software.amazon.awssdk.services.honeycode.model.ListTableColumnsRequest;
import software.amazon.awssdk.services.honeycode.model.ListTableColumnsResponse;
import software.amazon.awssdk.services.honeycode.model.ListTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.ListTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.ListTablesRequest;
import software.amazon.awssdk.services.honeycode.model.ListTablesResponse;
import software.amazon.awssdk.services.honeycode.model.QueryTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.QueryTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.RequestTimeoutException;
import software.amazon.awssdk.services.honeycode.model.ResourceNotFoundException;
import software.amazon.awssdk.services.honeycode.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.honeycode.model.ServiceUnavailableException;
import software.amazon.awssdk.services.honeycode.model.StartTableDataImportJobRequest;
import software.amazon.awssdk.services.honeycode.model.StartTableDataImportJobResponse;
import software.amazon.awssdk.services.honeycode.model.ThrottlingException;
import software.amazon.awssdk.services.honeycode.model.ValidationException;
import software.amazon.awssdk.services.honeycode.paginators.ListTableColumnsIterable;
import software.amazon.awssdk.services.honeycode.paginators.ListTableRowsIterable;
import software.amazon.awssdk.services.honeycode.paginators.ListTablesIterable;
import software.amazon.awssdk.services.honeycode.paginators.QueryTableRowsIterable;

/**
 * Service client for accessing Honeycode. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Honeycode is a fully managed service that allows you to quickly build mobile and web apps for teams—without
 * programming. Build Honeycode apps for managing almost anything, like projects, customers, operations, approvals,
 * resources, and even your team.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface HoneycodeClient extends SdkClient {
    String SERVICE_NAME = "honeycode";

    /**
     * Create a {@link HoneycodeClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static HoneycodeClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link HoneycodeClient}.
     */
    static HoneycodeClientBuilder builder() {
        return new DefaultHoneycodeClientBuilder();
    }

    /**
     * <p>
     * The BatchCreateTableRows API allows you to create one or more rows at the end of a table in a workbook. The API
     * allows you to specify the values to set in some or all of the columns in the new rows.
     * </p>
     * <p>
     * If a column is not explicitly set in a specific row, then the column level formula specified in the table will be
     * applied to the new row. If there is no column level formula but the last row of the table has a formula, then
     * that formula will be copied down to the new row. If there is no column level formula and no formula in the last
     * row of the table, then that column will be left blank for the new rows.
     * </p>
     *
     * @param batchCreateTableRowsRequest
     * @return Result of the BatchCreateTableRows operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceQuotaExceededException
     *         The request caused service quota to be breached.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.BatchCreateTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchCreateTableRows" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchCreateTableRowsResponse batchCreateTableRows(BatchCreateTableRowsRequest batchCreateTableRowsRequest)
            throws AccessDeniedException, InternalServerException, RequestTimeoutException, ResourceNotFoundException,
            ServiceQuotaExceededException, ServiceUnavailableException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, HoneycodeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The BatchCreateTableRows API allows you to create one or more rows at the end of a table in a workbook. The API
     * allows you to specify the values to set in some or all of the columns in the new rows.
     * </p>
     * <p>
     * If a column is not explicitly set in a specific row, then the column level formula specified in the table will be
     * applied to the new row. If there is no column level formula but the last row of the table has a formula, then
     * that formula will be copied down to the new row. If there is no column level formula and no formula in the last
     * row of the table, then that column will be left blank for the new rows.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreateTableRowsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchCreateTableRowsRequest#builder()}
     * </p>
     *
     * @param batchCreateTableRowsRequest
     *        A {@link Consumer} that will call methods on {@link BatchCreateTableRowsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchCreateTableRows operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceQuotaExceededException
     *         The request caused service quota to be breached.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.BatchCreateTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchCreateTableRows" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchCreateTableRowsResponse batchCreateTableRows(
            Consumer<BatchCreateTableRowsRequest.Builder> batchCreateTableRowsRequest) throws AccessDeniedException,
            InternalServerException, RequestTimeoutException, ResourceNotFoundException, ServiceQuotaExceededException,
            ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            HoneycodeException {
        return batchCreateTableRows(BatchCreateTableRowsRequest.builder().applyMutation(batchCreateTableRowsRequest).build());
    }

    /**
     * <p>
     * The BatchDeleteTableRows API allows you to delete one or more rows from a table in a workbook. You need to
     * specify the ids of the rows that you want to delete from the table.
     * </p>
     *
     * @param batchDeleteTableRowsRequest
     * @return Result of the BatchDeleteTableRows operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.BatchDeleteTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchDeleteTableRows" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchDeleteTableRowsResponse batchDeleteTableRows(BatchDeleteTableRowsRequest batchDeleteTableRowsRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ServiceUnavailableException,
            ValidationException, RequestTimeoutException, ThrottlingException, AwsServiceException, SdkClientException,
            HoneycodeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The BatchDeleteTableRows API allows you to delete one or more rows from a table in a workbook. You need to
     * specify the ids of the rows that you want to delete from the table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteTableRowsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeleteTableRowsRequest#builder()}
     * </p>
     *
     * @param batchDeleteTableRowsRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteTableRowsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDeleteTableRows operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.BatchDeleteTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchDeleteTableRows" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchDeleteTableRowsResponse batchDeleteTableRows(
            Consumer<BatchDeleteTableRowsRequest.Builder> batchDeleteTableRowsRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ServiceUnavailableException, ValidationException,
            RequestTimeoutException, ThrottlingException, AwsServiceException, SdkClientException, HoneycodeException {
        return batchDeleteTableRows(BatchDeleteTableRowsRequest.builder().applyMutation(batchDeleteTableRowsRequest).build());
    }

    /**
     * <p>
     * The BatchUpdateTableRows API allows you to update one or more rows in a table in a workbook.
     * </p>
     * <p>
     * You can specify the values to set in some or all of the columns in the table for the specified rows. If a column
     * is not explicitly specified in a particular row, then that column will not be updated for that row. To clear out
     * the data in a specific cell, you need to set the value as an empty string ("").
     * </p>
     *
     * @param batchUpdateTableRowsRequest
     * @return Result of the BatchUpdateTableRows operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.BatchUpdateTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchUpdateTableRows" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchUpdateTableRowsResponse batchUpdateTableRows(BatchUpdateTableRowsRequest batchUpdateTableRowsRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ServiceUnavailableException,
            ValidationException, RequestTimeoutException, ThrottlingException, AwsServiceException, SdkClientException,
            HoneycodeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The BatchUpdateTableRows API allows you to update one or more rows in a table in a workbook.
     * </p>
     * <p>
     * You can specify the values to set in some or all of the columns in the table for the specified rows. If a column
     * is not explicitly specified in a particular row, then that column will not be updated for that row. To clear out
     * the data in a specific cell, you need to set the value as an empty string ("").
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateTableRowsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdateTableRowsRequest#builder()}
     * </p>
     *
     * @param batchUpdateTableRowsRequest
     *        A {@link Consumer} that will call methods on {@link BatchUpdateTableRowsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchUpdateTableRows operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.BatchUpdateTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchUpdateTableRows" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchUpdateTableRowsResponse batchUpdateTableRows(
            Consumer<BatchUpdateTableRowsRequest.Builder> batchUpdateTableRowsRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ServiceUnavailableException, ValidationException,
            RequestTimeoutException, ThrottlingException, AwsServiceException, SdkClientException, HoneycodeException {
        return batchUpdateTableRows(BatchUpdateTableRowsRequest.builder().applyMutation(batchUpdateTableRowsRequest).build());
    }

    /**
     * <p>
     * The BatchUpsertTableRows API allows you to upsert one or more rows in a table. The upsert operation takes a
     * filter expression as input and evaluates it to find matching rows on the destination table. If matching rows are
     * found, it will update the cells in the matching rows to new values specified in the request. If no matching rows
     * are found, a new row is added at the end of the table and the cells in that row are set to the new values
     * specified in the request.
     * </p>
     * <p>
     * You can specify the values to set in some or all of the columns in the table for the matching or newly appended
     * rows. If a column is not explicitly specified for a particular row, then that column will not be updated for that
     * row. To clear out the data in a specific cell, you need to set the value as an empty string ("").
     * </p>
     *
     * @param batchUpsertTableRowsRequest
     * @return Result of the BatchUpsertTableRows operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceQuotaExceededException
     *         The request caused service quota to be breached.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.BatchUpsertTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchUpsertTableRows" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchUpsertTableRowsResponse batchUpsertTableRows(BatchUpsertTableRowsRequest batchUpsertTableRowsRequest)
            throws AccessDeniedException, InternalServerException, RequestTimeoutException, ResourceNotFoundException,
            ServiceQuotaExceededException, ServiceUnavailableException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, HoneycodeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The BatchUpsertTableRows API allows you to upsert one or more rows in a table. The upsert operation takes a
     * filter expression as input and evaluates it to find matching rows on the destination table. If matching rows are
     * found, it will update the cells in the matching rows to new values specified in the request. If no matching rows
     * are found, a new row is added at the end of the table and the cells in that row are set to the new values
     * specified in the request.
     * </p>
     * <p>
     * You can specify the values to set in some or all of the columns in the table for the matching or newly appended
     * rows. If a column is not explicitly specified for a particular row, then that column will not be updated for that
     * row. To clear out the data in a specific cell, you need to set the value as an empty string ("").
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpsertTableRowsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpsertTableRowsRequest#builder()}
     * </p>
     *
     * @param batchUpsertTableRowsRequest
     *        A {@link Consumer} that will call methods on {@link BatchUpsertTableRowsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchUpsertTableRows operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceQuotaExceededException
     *         The request caused service quota to be breached.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.BatchUpsertTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchUpsertTableRows" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchUpsertTableRowsResponse batchUpsertTableRows(
            Consumer<BatchUpsertTableRowsRequest.Builder> batchUpsertTableRowsRequest) throws AccessDeniedException,
            InternalServerException, RequestTimeoutException, ResourceNotFoundException, ServiceQuotaExceededException,
            ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            HoneycodeException {
        return batchUpsertTableRows(BatchUpsertTableRowsRequest.builder().applyMutation(batchUpsertTableRowsRequest).build());
    }

    /**
     * <p>
     * The DescribeTableDataImportJob API allows you to retrieve the status and details of a table data import job.
     * </p>
     *
     * @param describeTableDataImportJobRequest
     * @return Result of the DescribeTableDataImportJob operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.DescribeTableDataImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/DescribeTableDataImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTableDataImportJobResponse describeTableDataImportJob(
            DescribeTableDataImportJobRequest describeTableDataImportJobRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ServiceUnavailableException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, HoneycodeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The DescribeTableDataImportJob API allows you to retrieve the status and details of a table data import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTableDataImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTableDataImportJobRequest#builder()}
     * </p>
     *
     * @param describeTableDataImportJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTableDataImportJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeTableDataImportJob operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.DescribeTableDataImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/DescribeTableDataImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTableDataImportJobResponse describeTableDataImportJob(
            Consumer<DescribeTableDataImportJobRequest.Builder> describeTableDataImportJobRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ServiceUnavailableException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, HoneycodeException {
        return describeTableDataImportJob(DescribeTableDataImportJobRequest.builder()
                .applyMutation(describeTableDataImportJobRequest).build());
    }

    /**
     * <p>
     * The GetScreenData API allows retrieval of data from a screen in a Honeycode app. The API allows setting local
     * variables in the screen to filter, sort or otherwise affect what will be displayed on the screen.
     * </p>
     *
     * @param getScreenDataRequest
     * @return Result of the GetScreenData operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.GetScreenData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/GetScreenData" target="_top">AWS API
     *      Documentation</a>
     */
    default GetScreenDataResponse getScreenData(GetScreenDataRequest getScreenDataRequest) throws AccessDeniedException,
            InternalServerException, RequestTimeoutException, ResourceNotFoundException, ServiceUnavailableException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException, HoneycodeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The GetScreenData API allows retrieval of data from a screen in a Honeycode app. The API allows setting local
     * variables in the screen to filter, sort or otherwise affect what will be displayed on the screen.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetScreenDataRequest.Builder} avoiding the need to
     * create one manually via {@link GetScreenDataRequest#builder()}
     * </p>
     *
     * @param getScreenDataRequest
     *        A {@link Consumer} that will call methods on {@link GetScreenDataRequest.Builder} to create a request.
     * @return Result of the GetScreenData operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.GetScreenData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/GetScreenData" target="_top">AWS API
     *      Documentation</a>
     */
    default GetScreenDataResponse getScreenData(Consumer<GetScreenDataRequest.Builder> getScreenDataRequest)
            throws AccessDeniedException, InternalServerException, RequestTimeoutException, ResourceNotFoundException,
            ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            HoneycodeException {
        return getScreenData(GetScreenDataRequest.builder().applyMutation(getScreenDataRequest).build());
    }

    /**
     * <p>
     * The InvokeScreenAutomation API allows invoking an action defined in a screen in a Honeycode app. The API allows
     * setting local variables, which can then be used in the automation being invoked. This allows automating the
     * Honeycode app interactions to write, update or delete data in the workbook.
     * </p>
     *
     * @param invokeScreenAutomationRequest
     * @return Result of the InvokeScreenAutomation operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws AutomationExecutionException
     *         The automation execution did not end successfully.
     * @throws AutomationExecutionTimeoutException
     *         The automation execution timed out.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.InvokeScreenAutomation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/InvokeScreenAutomation"
     *      target="_top">AWS API Documentation</a>
     */
    default InvokeScreenAutomationResponse invokeScreenAutomation(InvokeScreenAutomationRequest invokeScreenAutomationRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ValidationException,
            ThrottlingException, ServiceUnavailableException, AutomationExecutionException, AutomationExecutionTimeoutException,
            RequestTimeoutException, AwsServiceException, SdkClientException, HoneycodeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The InvokeScreenAutomation API allows invoking an action defined in a screen in a Honeycode app. The API allows
     * setting local variables, which can then be used in the automation being invoked. This allows automating the
     * Honeycode app interactions to write, update or delete data in the workbook.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeScreenAutomationRequest.Builder} avoiding the
     * need to create one manually via {@link InvokeScreenAutomationRequest#builder()}
     * </p>
     *
     * @param invokeScreenAutomationRequest
     *        A {@link Consumer} that will call methods on {@link InvokeScreenAutomationRequest.Builder} to create a
     *        request.
     * @return Result of the InvokeScreenAutomation operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws AutomationExecutionException
     *         The automation execution did not end successfully.
     * @throws AutomationExecutionTimeoutException
     *         The automation execution timed out.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.InvokeScreenAutomation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/InvokeScreenAutomation"
     *      target="_top">AWS API Documentation</a>
     */
    default InvokeScreenAutomationResponse invokeScreenAutomation(
            Consumer<InvokeScreenAutomationRequest.Builder> invokeScreenAutomationRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ValidationException, ThrottlingException,
            ServiceUnavailableException, AutomationExecutionException, AutomationExecutionTimeoutException,
            RequestTimeoutException, AwsServiceException, SdkClientException, HoneycodeException {
        return invokeScreenAutomation(InvokeScreenAutomationRequest.builder().applyMutation(invokeScreenAutomationRequest)
                .build());
    }

    /**
     * <p>
     * The ListTableColumns API allows you to retrieve a list of all the columns in a table in a workbook.
     * </p>
     *
     * @param listTableColumnsRequest
     * @return Result of the ListTableColumns operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.ListTableColumns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTableColumns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTableColumnsResponse listTableColumns(ListTableColumnsRequest listTableColumnsRequest)
            throws AccessDeniedException, InternalServerException, RequestTimeoutException, ResourceNotFoundException,
            ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            HoneycodeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The ListTableColumns API allows you to retrieve a list of all the columns in a table in a workbook.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableColumnsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTableColumnsRequest#builder()}
     * </p>
     *
     * @param listTableColumnsRequest
     *        A {@link Consumer} that will call methods on {@link ListTableColumnsRequest.Builder} to create a request.
     * @return Result of the ListTableColumns operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.ListTableColumns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTableColumns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTableColumnsResponse listTableColumns(Consumer<ListTableColumnsRequest.Builder> listTableColumnsRequest)
            throws AccessDeniedException, InternalServerException, RequestTimeoutException, ResourceNotFoundException,
            ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            HoneycodeException {
        return listTableColumns(ListTableColumnsRequest.builder().applyMutation(listTableColumnsRequest).build());
    }

    /**
     * <p>
     * The ListTableColumns API allows you to retrieve a list of all the columns in a table in a workbook.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTableColumns(software.amazon.awssdk.services.honeycode.model.ListTableColumnsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTableColumnsIterable responses = client.listTableColumnsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.honeycode.paginators.ListTableColumnsIterable responses = client
     *             .listTableColumnsPaginator(request);
     *     for (software.amazon.awssdk.services.honeycode.model.ListTableColumnsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTableColumnsIterable responses = client.listTableColumnsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableColumns(software.amazon.awssdk.services.honeycode.model.ListTableColumnsRequest)} operation.</b>
     * </p>
     *
     * @param listTableColumnsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.ListTableColumns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTableColumns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTableColumnsIterable listTableColumnsPaginator(ListTableColumnsRequest listTableColumnsRequest)
            throws AccessDeniedException, InternalServerException, RequestTimeoutException, ResourceNotFoundException,
            ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            HoneycodeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The ListTableColumns API allows you to retrieve a list of all the columns in a table in a workbook.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTableColumns(software.amazon.awssdk.services.honeycode.model.ListTableColumnsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTableColumnsIterable responses = client.listTableColumnsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.honeycode.paginators.ListTableColumnsIterable responses = client
     *             .listTableColumnsPaginator(request);
     *     for (software.amazon.awssdk.services.honeycode.model.ListTableColumnsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTableColumnsIterable responses = client.listTableColumnsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableColumns(software.amazon.awssdk.services.honeycode.model.ListTableColumnsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableColumnsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTableColumnsRequest#builder()}
     * </p>
     *
     * @param listTableColumnsRequest
     *        A {@link Consumer} that will call methods on {@link ListTableColumnsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.ListTableColumns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTableColumns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTableColumnsIterable listTableColumnsPaginator(Consumer<ListTableColumnsRequest.Builder> listTableColumnsRequest)
            throws AccessDeniedException, InternalServerException, RequestTimeoutException, ResourceNotFoundException,
            ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            HoneycodeException {
        return listTableColumnsPaginator(ListTableColumnsRequest.builder().applyMutation(listTableColumnsRequest).build());
    }

    /**
     * <p>
     * The ListTableRows API allows you to retrieve a list of all the rows in a table in a workbook.
     * </p>
     *
     * @param listTableRowsRequest
     * @return Result of the ListTableRows operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.ListTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTableRows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTableRowsResponse listTableRows(ListTableRowsRequest listTableRowsRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ServiceUnavailableException, ValidationException,
            RequestTimeoutException, ThrottlingException, AwsServiceException, SdkClientException, HoneycodeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The ListTableRows API allows you to retrieve a list of all the rows in a table in a workbook.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableRowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTableRowsRequest#builder()}
     * </p>
     *
     * @param listTableRowsRequest
     *        A {@link Consumer} that will call methods on {@link ListTableRowsRequest.Builder} to create a request.
     * @return Result of the ListTableRows operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.ListTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTableRows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTableRowsResponse listTableRows(Consumer<ListTableRowsRequest.Builder> listTableRowsRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ServiceUnavailableException,
            ValidationException, RequestTimeoutException, ThrottlingException, AwsServiceException, SdkClientException,
            HoneycodeException {
        return listTableRows(ListTableRowsRequest.builder().applyMutation(listTableRowsRequest).build());
    }

    /**
     * <p>
     * The ListTableRows API allows you to retrieve a list of all the rows in a table in a workbook.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTableRows(software.amazon.awssdk.services.honeycode.model.ListTableRowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTableRowsIterable responses = client.listTableRowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.honeycode.paginators.ListTableRowsIterable responses = client.listTableRowsPaginator(request);
     *     for (software.amazon.awssdk.services.honeycode.model.ListTableRowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTableRowsIterable responses = client.listTableRowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableRows(software.amazon.awssdk.services.honeycode.model.ListTableRowsRequest)} operation.</b>
     * </p>
     *
     * @param listTableRowsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.ListTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTableRows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTableRowsIterable listTableRowsPaginator(ListTableRowsRequest listTableRowsRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ServiceUnavailableException, ValidationException,
            RequestTimeoutException, ThrottlingException, AwsServiceException, SdkClientException, HoneycodeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The ListTableRows API allows you to retrieve a list of all the rows in a table in a workbook.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTableRows(software.amazon.awssdk.services.honeycode.model.ListTableRowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTableRowsIterable responses = client.listTableRowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.honeycode.paginators.ListTableRowsIterable responses = client.listTableRowsPaginator(request);
     *     for (software.amazon.awssdk.services.honeycode.model.ListTableRowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTableRowsIterable responses = client.listTableRowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableRows(software.amazon.awssdk.services.honeycode.model.ListTableRowsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableRowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTableRowsRequest#builder()}
     * </p>
     *
     * @param listTableRowsRequest
     *        A {@link Consumer} that will call methods on {@link ListTableRowsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.ListTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTableRows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTableRowsIterable listTableRowsPaginator(Consumer<ListTableRowsRequest.Builder> listTableRowsRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ServiceUnavailableException,
            ValidationException, RequestTimeoutException, ThrottlingException, AwsServiceException, SdkClientException,
            HoneycodeException {
        return listTableRowsPaginator(ListTableRowsRequest.builder().applyMutation(listTableRowsRequest).build());
    }

    /**
     * <p>
     * The ListTables API allows you to retrieve a list of all the tables in a workbook.
     * </p>
     *
     * @param listTablesRequest
     * @return Result of the ListTables operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.ListTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTablesResponse listTables(ListTablesRequest listTablesRequest) throws AccessDeniedException,
            InternalServerException, RequestTimeoutException, ResourceNotFoundException, ServiceUnavailableException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException, HoneycodeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The ListTables API allows you to retrieve a list of all the tables in a workbook.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTablesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTablesRequest#builder()}
     * </p>
     *
     * @param listTablesRequest
     *        A {@link Consumer} that will call methods on {@link ListTablesRequest.Builder} to create a request.
     * @return Result of the ListTables operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.ListTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTablesResponse listTables(Consumer<ListTablesRequest.Builder> listTablesRequest) throws AccessDeniedException,
            InternalServerException, RequestTimeoutException, ResourceNotFoundException, ServiceUnavailableException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException, HoneycodeException {
        return listTables(ListTablesRequest.builder().applyMutation(listTablesRequest).build());
    }

    /**
     * <p>
     * The ListTables API allows you to retrieve a list of all the tables in a workbook.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTables(software.amazon.awssdk.services.honeycode.model.ListTablesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.honeycode.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     *     for (software.amazon.awssdk.services.honeycode.model.ListTablesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTables(software.amazon.awssdk.services.honeycode.model.ListTablesRequest)} operation.</b>
     * </p>
     *
     * @param listTablesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.ListTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTablesIterable listTablesPaginator(ListTablesRequest listTablesRequest) throws AccessDeniedException,
            InternalServerException, RequestTimeoutException, ResourceNotFoundException, ServiceUnavailableException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException, HoneycodeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The ListTables API allows you to retrieve a list of all the tables in a workbook.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTables(software.amazon.awssdk.services.honeycode.model.ListTablesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.honeycode.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     *     for (software.amazon.awssdk.services.honeycode.model.ListTablesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTables(software.amazon.awssdk.services.honeycode.model.ListTablesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTablesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTablesRequest#builder()}
     * </p>
     *
     * @param listTablesRequest
     *        A {@link Consumer} that will call methods on {@link ListTablesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.ListTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTablesIterable listTablesPaginator(Consumer<ListTablesRequest.Builder> listTablesRequest)
            throws AccessDeniedException, InternalServerException, RequestTimeoutException, ResourceNotFoundException,
            ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            HoneycodeException {
        return listTablesPaginator(ListTablesRequest.builder().applyMutation(listTablesRequest).build());
    }

    /**
     * <p>
     * The QueryTableRows API allows you to use a filter formula to query for specific rows in a table.
     * </p>
     *
     * @param queryTableRowsRequest
     * @return Result of the QueryTableRows operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.QueryTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/QueryTableRows" target="_top">AWS API
     *      Documentation</a>
     */
    default QueryTableRowsResponse queryTableRows(QueryTableRowsRequest queryTableRowsRequest) throws AccessDeniedException,
            InternalServerException, RequestTimeoutException, ResourceNotFoundException, ServiceUnavailableException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException, HoneycodeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The QueryTableRows API allows you to use a filter formula to query for specific rows in a table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link QueryTableRowsRequest.Builder} avoiding the need to
     * create one manually via {@link QueryTableRowsRequest#builder()}
     * </p>
     *
     * @param queryTableRowsRequest
     *        A {@link Consumer} that will call methods on {@link QueryTableRowsRequest.Builder} to create a request.
     * @return Result of the QueryTableRows operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.QueryTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/QueryTableRows" target="_top">AWS API
     *      Documentation</a>
     */
    default QueryTableRowsResponse queryTableRows(Consumer<QueryTableRowsRequest.Builder> queryTableRowsRequest)
            throws AccessDeniedException, InternalServerException, RequestTimeoutException, ResourceNotFoundException,
            ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            HoneycodeException {
        return queryTableRows(QueryTableRowsRequest.builder().applyMutation(queryTableRowsRequest).build());
    }

    /**
     * <p>
     * The QueryTableRows API allows you to use a filter formula to query for specific rows in a table.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #queryTableRows(software.amazon.awssdk.services.honeycode.model.QueryTableRowsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.QueryTableRowsIterable responses = client.queryTableRowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.honeycode.paginators.QueryTableRowsIterable responses = client
     *             .queryTableRowsPaginator(request);
     *     for (software.amazon.awssdk.services.honeycode.model.QueryTableRowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.QueryTableRowsIterable responses = client.queryTableRowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #queryTableRows(software.amazon.awssdk.services.honeycode.model.QueryTableRowsRequest)} operation.</b>
     * </p>
     *
     * @param queryTableRowsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.QueryTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/QueryTableRows" target="_top">AWS API
     *      Documentation</a>
     */
    default QueryTableRowsIterable queryTableRowsPaginator(QueryTableRowsRequest queryTableRowsRequest)
            throws AccessDeniedException, InternalServerException, RequestTimeoutException, ResourceNotFoundException,
            ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            HoneycodeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The QueryTableRows API allows you to use a filter formula to query for specific rows in a table.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #queryTableRows(software.amazon.awssdk.services.honeycode.model.QueryTableRowsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.QueryTableRowsIterable responses = client.queryTableRowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.honeycode.paginators.QueryTableRowsIterable responses = client
     *             .queryTableRowsPaginator(request);
     *     for (software.amazon.awssdk.services.honeycode.model.QueryTableRowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.QueryTableRowsIterable responses = client.queryTableRowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #queryTableRows(software.amazon.awssdk.services.honeycode.model.QueryTableRowsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link QueryTableRowsRequest.Builder} avoiding the need to
     * create one manually via {@link QueryTableRowsRequest#builder()}
     * </p>
     *
     * @param queryTableRowsRequest
     *        A {@link Consumer} that will call methods on {@link QueryTableRowsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.QueryTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/QueryTableRows" target="_top">AWS API
     *      Documentation</a>
     */
    default QueryTableRowsIterable queryTableRowsPaginator(Consumer<QueryTableRowsRequest.Builder> queryTableRowsRequest)
            throws AccessDeniedException, InternalServerException, RequestTimeoutException, ResourceNotFoundException,
            ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            HoneycodeException {
        return queryTableRowsPaginator(QueryTableRowsRequest.builder().applyMutation(queryTableRowsRequest).build());
    }

    /**
     * <p>
     * The StartTableDataImportJob API allows you to start an import job on a table. This API will only return the id of
     * the job that was started. To find out the status of the import request, you need to call the
     * DescribeTableDataImportJob API.
     * </p>
     *
     * @param startTableDataImportJobRequest
     * @return Result of the StartTableDataImportJob operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.StartTableDataImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/StartTableDataImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTableDataImportJobResponse startTableDataImportJob(StartTableDataImportJobRequest startTableDataImportJobRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ServiceUnavailableException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException, HoneycodeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The StartTableDataImportJob API allows you to start an import job on a table. This API will only return the id of
     * the job that was started. To find out the status of the import request, you need to call the
     * DescribeTableDataImportJob API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTableDataImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartTableDataImportJobRequest#builder()}
     * </p>
     *
     * @param startTableDataImportJobRequest
     *        A {@link Consumer} that will call methods on {@link StartTableDataImportJobRequest.Builder} to create a
     *        request.
     * @return Result of the StartTableDataImportJob operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Check that the workbook is owned by you and
     *         your IAM policy allows access to the resource in the request.
     * @throws InternalServerException
     *         There were unexpected errors from the server.
     * @throws ResourceNotFoundException
     *         A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.
     * @throws ServiceUnavailableException
     *         Remote service is unreachable.
     * @throws ThrottlingException
     *         Tps(transactions per second) rate reached.
     * @throws ValidationException
     *         Request is invalid. The message in the response contains details on why the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HoneycodeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HoneycodeClient.StartTableDataImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/StartTableDataImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTableDataImportJobResponse startTableDataImportJob(
            Consumer<StartTableDataImportJobRequest.Builder> startTableDataImportJobRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ServiceUnavailableException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, HoneycodeException {
        return startTableDataImportJob(StartTableDataImportJobRequest.builder().applyMutation(startTableDataImportJobRequest)
                .build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("honeycode");
    }
}
