/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateTableRowsRequest extends HoneycodeRequest implements
        ToCopyableBuilder<BatchUpdateTableRowsRequest.Builder, BatchUpdateTableRowsRequest> {
    private static final SdkField<String> WORKBOOK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workbookId").getter(getter(BatchUpdateTableRowsRequest::workbookId)).setter(setter(Builder::workbookId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workbookId").build()).build();

    private static final SdkField<String> TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableId").getter(getter(BatchUpdateTableRowsRequest::tableId)).setter(setter(Builder::tableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableId").build()).build();

    private static final SdkField<List<UpdateRowData>> ROWS_TO_UPDATE_FIELD = SdkField
            .<List<UpdateRowData>> builder(MarshallingType.LIST)
            .memberName("rowsToUpdate")
            .getter(getter(BatchUpdateTableRowsRequest::rowsToUpdate))
            .setter(setter(Builder::rowsToUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowsToUpdate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdateRowData> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateRowData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken").getter(getter(BatchUpdateTableRowsRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKBOOK_ID_FIELD,
            TABLE_ID_FIELD, ROWS_TO_UPDATE_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String workbookId;

    private final String tableId;

    private final List<UpdateRowData> rowsToUpdate;

    private final String clientRequestToken;

    private BatchUpdateTableRowsRequest(BuilderImpl builder) {
        super(builder);
        this.workbookId = builder.workbookId;
        this.tableId = builder.tableId;
        this.rowsToUpdate = builder.rowsToUpdate;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The ID of the workbook where the rows are being updated.
     * </p>
     * <p>
     * If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
     * </p>
     * 
     * @return The ID of the workbook where the rows are being updated.</p>
     *         <p>
     *         If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
     */
    public String workbookId() {
        return workbookId;
    }

    /**
     * <p>
     * The ID of the table where the rows are being updated.
     * </p>
     * <p>
     * If a table with the specified id could not be found, this API throws ResourceNotFoundException.
     * </p>
     * 
     * @return The ID of the table where the rows are being updated.</p>
     *         <p>
     *         If a table with the specified id could not be found, this API throws ResourceNotFoundException.
     */
    public String tableId() {
        return tableId;
    }

    /**
     * Returns true if the RowsToUpdate property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRowsToUpdate() {
        return rowsToUpdate != null && !(rowsToUpdate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of rows to update in the table. Each item in this list needs to contain the row id to update along with
     * the map of column id to cell values for each column in that row that needs to be updated. You need to specify at
     * least one row in this list, and for each row, you need to specify at least one column to update.
     * </p>
     * <p>
     * Note that if one of the row or column ids in the request does not exist in the table, then the request fails and
     * no updates are made to the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRowsToUpdate()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of rows to update in the table. Each item in this list needs to contain the row id to update
     *         along with the map of column id to cell values for each column in that row that needs to be updated. You
     *         need to specify at least one row in this list, and for each row, you need to specify at least one column
     *         to update. </p>
     *         <p>
     *         Note that if one of the row or column ids in the request does not exist in the table, then the request
     *         fails and no updates are made to the table.
     */
    public List<UpdateRowData> rowsToUpdate() {
        return rowsToUpdate;
    }

    /**
     * <p>
     * The request token for performing the update action. Request tokens help to identify duplicate requests. If a call
     * times out or fails due to a transient error like a failed network connection, you can retry the call with the
     * same request token. The service ensures that if the first call using that request token is successfully
     * performed, the second call will not perform the action again.
     * </p>
     * <p>
     * Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests
     * spanning hours or days.
     * </p>
     * 
     * @return The request token for performing the update action. Request tokens help to identify duplicate requests.
     *         If a call times out or fails due to a transient error like a failed network connection, you can retry the
     *         call with the same request token. The service ensures that if the first call using that request token is
     *         successfully performed, the second call will not perform the action again. </p>
     *         <p>
     *         Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe
     *         requests spanning hours or days.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workbookId());
        hashCode = 31 * hashCode + Objects.hashCode(tableId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRowsToUpdate() ? rowsToUpdate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateTableRowsRequest)) {
            return false;
        }
        BatchUpdateTableRowsRequest other = (BatchUpdateTableRowsRequest) obj;
        return Objects.equals(workbookId(), other.workbookId()) && Objects.equals(tableId(), other.tableId())
                && hasRowsToUpdate() == other.hasRowsToUpdate() && Objects.equals(rowsToUpdate(), other.rowsToUpdate())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchUpdateTableRowsRequest").add("WorkbookId", workbookId()).add("TableId", tableId())
                .add("RowsToUpdate", hasRowsToUpdate() ? rowsToUpdate() : null).add("ClientRequestToken", clientRequestToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workbookId":
            return Optional.ofNullable(clazz.cast(workbookId()));
        case "tableId":
            return Optional.ofNullable(clazz.cast(tableId()));
        case "rowsToUpdate":
            return Optional.ofNullable(clazz.cast(rowsToUpdate()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateTableRowsRequest, T> g) {
        return obj -> g.apply((BatchUpdateTableRowsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HoneycodeRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchUpdateTableRowsRequest> {
        /**
         * <p>
         * The ID of the workbook where the rows are being updated.
         * </p>
         * <p>
         * If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
         * </p>
         * 
         * @param workbookId
         *        The ID of the workbook where the rows are being updated.</p>
         *        <p>
         *        If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workbookId(String workbookId);

        /**
         * <p>
         * The ID of the table where the rows are being updated.
         * </p>
         * <p>
         * If a table with the specified id could not be found, this API throws ResourceNotFoundException.
         * </p>
         * 
         * @param tableId
         *        The ID of the table where the rows are being updated.</p>
         *        <p>
         *        If a table with the specified id could not be found, this API throws ResourceNotFoundException.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableId(String tableId);

        /**
         * <p>
         * The list of rows to update in the table. Each item in this list needs to contain the row id to update along
         * with the map of column id to cell values for each column in that row that needs to be updated. You need to
         * specify at least one row in this list, and for each row, you need to specify at least one column to update.
         * </p>
         * <p>
         * Note that if one of the row or column ids in the request does not exist in the table, then the request fails
         * and no updates are made to the table.
         * </p>
         * 
         * @param rowsToUpdate
         *        The list of rows to update in the table. Each item in this list needs to contain the row id to update
         *        along with the map of column id to cell values for each column in that row that needs to be updated.
         *        You need to specify at least one row in this list, and for each row, you need to specify at least one
         *        column to update. </p>
         *        <p>
         *        Note that if one of the row or column ids in the request does not exist in the table, then the request
         *        fails and no updates are made to the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowsToUpdate(Collection<UpdateRowData> rowsToUpdate);

        /**
         * <p>
         * The list of rows to update in the table. Each item in this list needs to contain the row id to update along
         * with the map of column id to cell values for each column in that row that needs to be updated. You need to
         * specify at least one row in this list, and for each row, you need to specify at least one column to update.
         * </p>
         * <p>
         * Note that if one of the row or column ids in the request does not exist in the table, then the request fails
         * and no updates are made to the table.
         * </p>
         * 
         * @param rowsToUpdate
         *        The list of rows to update in the table. Each item in this list needs to contain the row id to update
         *        along with the map of column id to cell values for each column in that row that needs to be updated.
         *        You need to specify at least one row in this list, and for each row, you need to specify at least one
         *        column to update. </p>
         *        <p>
         *        Note that if one of the row or column ids in the request does not exist in the table, then the request
         *        fails and no updates are made to the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowsToUpdate(UpdateRowData... rowsToUpdate);

        /**
         * <p>
         * The list of rows to update in the table. Each item in this list needs to contain the row id to update along
         * with the map of column id to cell values for each column in that row that needs to be updated. You need to
         * specify at least one row in this list, and for each row, you need to specify at least one column to update.
         * </p>
         * <p>
         * Note that if one of the row or column ids in the request does not exist in the table, then the request fails
         * and no updates are made to the table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UpdateRowData>.Builder} avoiding the need
         * to create one manually via {@link List<UpdateRowData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UpdateRowData>.Builder#build()} is called immediately and
         * its result is passed to {@link #rowsToUpdate(List<UpdateRowData>)}.
         * 
         * @param rowsToUpdate
         *        a consumer that will call methods on {@link List<UpdateRowData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowsToUpdate(List<UpdateRowData>)
         */
        Builder rowsToUpdate(Consumer<UpdateRowData.Builder>... rowsToUpdate);

        /**
         * <p>
         * The request token for performing the update action. Request tokens help to identify duplicate requests. If a
         * call times out or fails due to a transient error like a failed network connection, you can retry the call
         * with the same request token. The service ensures that if the first call using that request token is
         * successfully performed, the second call will not perform the action again.
         * </p>
         * <p>
         * Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests
         * spanning hours or days.
         * </p>
         * 
         * @param clientRequestToken
         *        The request token for performing the update action. Request tokens help to identify duplicate
         *        requests. If a call times out or fails due to a transient error like a failed network connection, you
         *        can retry the call with the same request token. The service ensures that if the first call using that
         *        request token is successfully performed, the second call will not perform the action again. </p>
         *        <p>
         *        Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe
         *        requests spanning hours or days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends HoneycodeRequest.BuilderImpl implements Builder {
        private String workbookId;

        private String tableId;

        private List<UpdateRowData> rowsToUpdate = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateTableRowsRequest model) {
            super(model);
            workbookId(model.workbookId);
            tableId(model.tableId);
            rowsToUpdate(model.rowsToUpdate);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getWorkbookId() {
            return workbookId;
        }

        @Override
        public final Builder workbookId(String workbookId) {
            this.workbookId = workbookId;
            return this;
        }

        public final void setWorkbookId(String workbookId) {
            this.workbookId = workbookId;
        }

        public final String getTableId() {
            return tableId;
        }

        @Override
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        public final Collection<UpdateRowData.Builder> getRowsToUpdate() {
            if (rowsToUpdate instanceof SdkAutoConstructList) {
                return null;
            }
            return rowsToUpdate != null ? rowsToUpdate.stream().map(UpdateRowData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rowsToUpdate(Collection<UpdateRowData> rowsToUpdate) {
            this.rowsToUpdate = UpdateRowDataListCopier.copy(rowsToUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowsToUpdate(UpdateRowData... rowsToUpdate) {
            rowsToUpdate(Arrays.asList(rowsToUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowsToUpdate(Consumer<UpdateRowData.Builder>... rowsToUpdate) {
            rowsToUpdate(Stream.of(rowsToUpdate).map(c -> UpdateRowData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRowsToUpdate(Collection<UpdateRowData.BuilderImpl> rowsToUpdate) {
            this.rowsToUpdate = UpdateRowDataListCopier.copyFromBuilder(rowsToUpdate);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateTableRowsRequest build() {
            return new BatchUpdateTableRowsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
