/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetScreenDataRequest extends HoneycodeRequest implements
        ToCopyableBuilder<GetScreenDataRequest.Builder, GetScreenDataRequest> {
    private static final SdkField<String> WORKBOOK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workbookId").getter(getter(GetScreenDataRequest::workbookId)).setter(setter(Builder::workbookId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workbookId").build()).build();

    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(GetScreenDataRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<String> SCREEN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("screenId").getter(getter(GetScreenDataRequest::screenId)).setter(setter(Builder::screenId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("screenId").build()).build();

    private static final SdkField<Map<String, VariableValue>> VARIABLES_FIELD = SdkField
            .<Map<String, VariableValue>> builder(MarshallingType.MAP)
            .memberName("variables")
            .getter(getter(GetScreenDataRequest::variables))
            .setter(setter(Builder::variables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<VariableValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(VariableValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetScreenDataRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetScreenDataRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKBOOK_ID_FIELD,
            APP_ID_FIELD, SCREEN_ID_FIELD, VARIABLES_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String workbookId;

    private final String appId;

    private final String screenId;

    private final Map<String, VariableValue> variables;

    private final Integer maxResults;

    private final String nextToken;

    private GetScreenDataRequest(BuilderImpl builder) {
        super(builder);
        this.workbookId = builder.workbookId;
        this.appId = builder.appId;
        this.screenId = builder.screenId;
        this.variables = builder.variables;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the workbook that contains the screen.
     * </p>
     * 
     * @return The ID of the workbook that contains the screen.
     */
    public String workbookId() {
        return workbookId;
    }

    /**
     * <p>
     * The ID of the app that contains the screem.
     * </p>
     * 
     * @return The ID of the app that contains the screem.
     */
    public String appId() {
        return appId;
    }

    /**
     * <p>
     * The ID of the screen.
     * </p>
     * 
     * @return The ID of the screen.
     */
    public String screenId() {
        return screenId;
    }

    /**
     * Returns true if the Variables property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasVariables() {
        return variables != null && !(variables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Variables are optional and are needed only if the screen requires them to render correctly. Variables are
     * specified as a map where the key is the name of the variable as defined on the screen. The value is an object
     * which currently has only one property, rawValue, which holds the value of the variable to be passed to the
     * screen.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVariables()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Variables are optional and are needed only if the screen requires them to render correctly. Variables are
     *         specified as a map where the key is the name of the variable as defined on the screen. The value is an
     *         object which currently has only one property, rawValue, which holds the value of the variable to be
     *         passed to the screen.
     */
    public Map<String, VariableValue> variables() {
        return variables;
    }

    /**
     * <p>
     * The number of results to be returned on a single page. Specify a number between 1 and 100. The maximum value is
     * 100.
     * </p>
     * <p>
     * This parameter is optional. If you don't specify this parameter, the default page size is 100.
     * </p>
     * 
     * @return The number of results to be returned on a single page. Specify a number between 1 and 100. The maximum
     *         value is 100. </p>
     *         <p>
     *         This parameter is optional. If you don't specify this parameter, the default page size is 100.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
     * </p>
     * <p>
     * Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will
     * throw ValidationException.
     * </p>
     * 
     * @return This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
     *         <p>
     *         Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the
     *         API will throw ValidationException.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workbookId());
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(screenId());
        hashCode = 31 * hashCode + Objects.hashCode(hasVariables() ? variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetScreenDataRequest)) {
            return false;
        }
        GetScreenDataRequest other = (GetScreenDataRequest) obj;
        return Objects.equals(workbookId(), other.workbookId()) && Objects.equals(appId(), other.appId())
                && Objects.equals(screenId(), other.screenId()) && hasVariables() == other.hasVariables()
                && Objects.equals(variables(), other.variables()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetScreenDataRequest").add("WorkbookId", workbookId()).add("AppId", appId())
                .add("ScreenId", screenId()).add("Variables", variables() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workbookId":
            return Optional.ofNullable(clazz.cast(workbookId()));
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "screenId":
            return Optional.ofNullable(clazz.cast(screenId()));
        case "variables":
            return Optional.ofNullable(clazz.cast(variables()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetScreenDataRequest, T> g) {
        return obj -> g.apply((GetScreenDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HoneycodeRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetScreenDataRequest> {
        /**
         * <p>
         * The ID of the workbook that contains the screen.
         * </p>
         * 
         * @param workbookId
         *        The ID of the workbook that contains the screen.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workbookId(String workbookId);

        /**
         * <p>
         * The ID of the app that contains the screem.
         * </p>
         * 
         * @param appId
         *        The ID of the app that contains the screem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The ID of the screen.
         * </p>
         * 
         * @param screenId
         *        The ID of the screen.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder screenId(String screenId);

        /**
         * <p>
         * Variables are optional and are needed only if the screen requires them to render correctly. Variables are
         * specified as a map where the key is the name of the variable as defined on the screen. The value is an object
         * which currently has only one property, rawValue, which holds the value of the variable to be passed to the
         * screen.
         * </p>
         * 
         * @param variables
         *        Variables are optional and are needed only if the screen requires them to render correctly. Variables
         *        are specified as a map where the key is the name of the variable as defined on the screen. The value
         *        is an object which currently has only one property, rawValue, which holds the value of the variable to
         *        be passed to the screen.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(Map<String, VariableValue> variables);

        /**
         * <p>
         * The number of results to be returned on a single page. Specify a number between 1 and 100. The maximum value
         * is 100.
         * </p>
         * <p>
         * This parameter is optional. If you don't specify this parameter, the default page size is 100.
         * </p>
         * 
         * @param maxResults
         *        The number of results to be returned on a single page. Specify a number between 1 and 100. The maximum
         *        value is 100. </p>
         *        <p>
         *        This parameter is optional. If you don't specify this parameter, the default page size is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
         * </p>
         * <p>
         * Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API
         * will throw ValidationException.
         * </p>
         * 
         * @param nextToken
         *        This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
         *        </p>
         *        <p>
         *        Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back,
         *        the API will throw ValidationException.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends HoneycodeRequest.BuilderImpl implements Builder {
        private String workbookId;

        private String appId;

        private String screenId;

        private Map<String, VariableValue> variables = DefaultSdkAutoConstructMap.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetScreenDataRequest model) {
            super(model);
            workbookId(model.workbookId);
            appId(model.appId);
            screenId(model.screenId);
            variables(model.variables);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getWorkbookId() {
            return workbookId;
        }

        @Override
        public final Builder workbookId(String workbookId) {
            this.workbookId = workbookId;
            return this;
        }

        public final void setWorkbookId(String workbookId) {
            this.workbookId = workbookId;
        }

        public final String getAppId() {
            return appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getScreenId() {
            return screenId;
        }

        @Override
        public final Builder screenId(String screenId) {
            this.screenId = screenId;
            return this;
        }

        public final void setScreenId(String screenId) {
            this.screenId = screenId;
        }

        public final Map<String, VariableValue.Builder> getVariables() {
            if (variables instanceof SdkAutoConstructMap) {
                return null;
            }
            return variables != null ? CollectionUtils.mapValues(variables, VariableValue::toBuilder) : null;
        }

        @Override
        public final Builder variables(Map<String, VariableValue> variables) {
            this.variables = VariableValueMapCopier.copy(variables);
            return this;
        }

        public final void setVariables(Map<String, VariableValue.BuilderImpl> variables) {
            this.variables = VariableValueMapCopier.copyFromBuilder(variables);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetScreenDataRequest build() {
            return new GetScreenDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
