/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that has details about the source of the data that was submitted for import.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportDataSource implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportDataSource.Builder, ImportDataSource> {
    private static final SdkField<ImportDataSourceConfig> DATA_SOURCE_CONFIG_FIELD = SdkField
            .<ImportDataSourceConfig> builder(MarshallingType.SDK_POJO).memberName("dataSourceConfig")
            .getter(getter(ImportDataSource::dataSourceConfig)).setter(setter(Builder::dataSourceConfig))
            .constructor(ImportDataSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final ImportDataSourceConfig dataSourceConfig;

    private ImportDataSource(BuilderImpl builder) {
        this.dataSourceConfig = builder.dataSourceConfig;
    }

    /**
     * <p>
     * The configuration parameters for the data source of the import
     * </p>
     * 
     * @return The configuration parameters for the data source of the import
     */
    public ImportDataSourceConfig dataSourceConfig() {
        return dataSourceConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportDataSource)) {
            return false;
        }
        ImportDataSource other = (ImportDataSource) obj;
        return Objects.equals(dataSourceConfig(), other.dataSourceConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ImportDataSource").add("DataSourceConfig", dataSourceConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSourceConfig":
            return Optional.ofNullable(clazz.cast(dataSourceConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportDataSource, T> g) {
        return obj -> g.apply((ImportDataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportDataSource> {
        /**
         * <p>
         * The configuration parameters for the data source of the import
         * </p>
         * 
         * @param dataSourceConfig
         *        The configuration parameters for the data source of the import
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceConfig(ImportDataSourceConfig dataSourceConfig);

        /**
         * <p>
         * The configuration parameters for the data source of the import
         * </p>
         * This is a convenience that creates an instance of the {@link ImportDataSourceConfig.Builder} avoiding the
         * need to create one manually via {@link ImportDataSourceConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImportDataSourceConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSourceConfig(ImportDataSourceConfig)}.
         * 
         * @param dataSourceConfig
         *        a consumer that will call methods on {@link ImportDataSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSourceConfig(ImportDataSourceConfig)
         */
        default Builder dataSourceConfig(Consumer<ImportDataSourceConfig.Builder> dataSourceConfig) {
            return dataSourceConfig(ImportDataSourceConfig.builder().applyMutation(dataSourceConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ImportDataSourceConfig dataSourceConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportDataSource model) {
            dataSourceConfig(model.dataSourceConfig);
        }

        public final ImportDataSourceConfig.Builder getDataSourceConfig() {
            return dataSourceConfig != null ? dataSourceConfig.toBuilder() : null;
        }

        @Override
        public final Builder dataSourceConfig(ImportDataSourceConfig dataSourceConfig) {
            this.dataSourceConfig = dataSourceConfig;
            return this;
        }

        public final void setDataSourceConfig(ImportDataSourceConfig.BuilderImpl dataSourceConfig) {
            this.dataSourceConfig = dataSourceConfig != null ? dataSourceConfig.build() : null;
        }

        @Override
        public ImportDataSource build() {
            return new ImportDataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
