/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains the configuration parameters for the data source of an import request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportDataSourceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportDataSourceConfig.Builder, ImportDataSourceConfig> {
    private static final SdkField<String> DATA_SOURCE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceUrl").getter(getter(ImportDataSourceConfig::dataSourceUrl))
            .setter(setter(Builder::dataSourceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataSourceUrl;

    private ImportDataSourceConfig(BuilderImpl builder) {
        this.dataSourceUrl = builder.dataSourceUrl;
    }

    /**
     * <p>
     * The URL from which source data will be downloaded for the import request.
     * </p>
     * 
     * @return The URL from which source data will be downloaded for the import request.
     */
    public String dataSourceUrl() {
        return dataSourceUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportDataSourceConfig)) {
            return false;
        }
        ImportDataSourceConfig other = (ImportDataSourceConfig) obj;
        return Objects.equals(dataSourceUrl(), other.dataSourceUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ImportDataSourceConfig").add("DataSourceUrl", dataSourceUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSourceUrl":
            return Optional.ofNullable(clazz.cast(dataSourceUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportDataSourceConfig, T> g) {
        return obj -> g.apply((ImportDataSourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportDataSourceConfig> {
        /**
         * <p>
         * The URL from which source data will be downloaded for the import request.
         * </p>
         * 
         * @param dataSourceUrl
         *        The URL from which source data will be downloaded for the import request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceUrl(String dataSourceUrl);
    }

    static final class BuilderImpl implements Builder {
        private String dataSourceUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportDataSourceConfig model) {
            dataSourceUrl(model.dataSourceUrl);
        }

        public final String getDataSourceUrl() {
            return dataSourceUrl;
        }

        @Override
        public final Builder dataSourceUrl(String dataSourceUrl) {
            this.dataSourceUrl = dataSourceUrl;
            return this;
        }

        public final void setDataSourceUrl(String dataSourceUrl) {
            this.dataSourceUrl = dataSourceUrl;
        }

        @Override
        public ImportDataSourceConfig build() {
            return new ImportDataSourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
