/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTableColumnsRequest extends HoneycodeRequest implements
        ToCopyableBuilder<ListTableColumnsRequest.Builder, ListTableColumnsRequest> {
    private static final SdkField<String> WORKBOOK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workbookId").getter(getter(ListTableColumnsRequest::workbookId)).setter(setter(Builder::workbookId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workbookId").build()).build();

    private static final SdkField<String> TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableId").getter(getter(ListTableColumnsRequest::tableId)).setter(setter(Builder::tableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTableColumnsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKBOOK_ID_FIELD,
            TABLE_ID_FIELD, NEXT_TOKEN_FIELD));

    private final String workbookId;

    private final String tableId;

    private final String nextToken;

    private ListTableColumnsRequest(BuilderImpl builder) {
        super(builder);
        this.workbookId = builder.workbookId;
        this.tableId = builder.tableId;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the workbook that contains the table whose columns are being retrieved.
     * </p>
     * <p>
     * If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
     * </p>
     * 
     * @return The ID of the workbook that contains the table whose columns are being retrieved.</p>
     *         <p>
     *         If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
     */
    public String workbookId() {
        return workbookId;
    }

    /**
     * <p>
     * The ID of the table whose columns are being retrieved.
     * </p>
     * <p>
     * If a table with the specified id could not be found, this API throws ResourceNotFoundException.
     * </p>
     * 
     * @return The ID of the table whose columns are being retrieved.</p>
     *         <p>
     *         If a table with the specified id could not be found, this API throws ResourceNotFoundException.
     */
    public String tableId() {
        return tableId;
    }

    /**
     * <p>
     * This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
     * </p>
     * <p>
     * Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will
     * throw ValidationException.
     * </p>
     * 
     * @return This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
     *         <p>
     *         Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the
     *         API will throw ValidationException.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workbookId());
        hashCode = 31 * hashCode + Objects.hashCode(tableId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTableColumnsRequest)) {
            return false;
        }
        ListTableColumnsRequest other = (ListTableColumnsRequest) obj;
        return Objects.equals(workbookId(), other.workbookId()) && Objects.equals(tableId(), other.tableId())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTableColumnsRequest").add("WorkbookId", workbookId()).add("TableId", tableId())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workbookId":
            return Optional.ofNullable(clazz.cast(workbookId()));
        case "tableId":
            return Optional.ofNullable(clazz.cast(tableId()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTableColumnsRequest, T> g) {
        return obj -> g.apply((ListTableColumnsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HoneycodeRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTableColumnsRequest> {
        /**
         * <p>
         * The ID of the workbook that contains the table whose columns are being retrieved.
         * </p>
         * <p>
         * If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
         * </p>
         * 
         * @param workbookId
         *        The ID of the workbook that contains the table whose columns are being retrieved.</p>
         *        <p>
         *        If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workbookId(String workbookId);

        /**
         * <p>
         * The ID of the table whose columns are being retrieved.
         * </p>
         * <p>
         * If a table with the specified id could not be found, this API throws ResourceNotFoundException.
         * </p>
         * 
         * @param tableId
         *        The ID of the table whose columns are being retrieved.</p>
         *        <p>
         *        If a table with the specified id could not be found, this API throws ResourceNotFoundException.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableId(String tableId);

        /**
         * <p>
         * This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
         * </p>
         * <p>
         * Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API
         * will throw ValidationException.
         * </p>
         * 
         * @param nextToken
         *        This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
         *        </p>
         *        <p>
         *        Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back,
         *        the API will throw ValidationException.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends HoneycodeRequest.BuilderImpl implements Builder {
        private String workbookId;

        private String tableId;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTableColumnsRequest model) {
            super(model);
            workbookId(model.workbookId);
            tableId(model.tableId);
            nextToken(model.nextToken);
        }

        public final String getWorkbookId() {
            return workbookId;
        }

        @Override
        public final Builder workbookId(String workbookId) {
            this.workbookId = workbookId;
            return this;
        }

        public final void setWorkbookId(String workbookId) {
            this.workbookId = workbookId;
        }

        public final String getTableId() {
            return tableId;
        }

        @Override
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTableColumnsRequest build() {
            return new ListTableColumnsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
