/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTableColumnsResponse extends HoneycodeResponse implements
        ToCopyableBuilder<ListTableColumnsResponse.Builder, ListTableColumnsResponse> {
    private static final SdkField<List<TableColumn>> TABLE_COLUMNS_FIELD = SdkField
            .<List<TableColumn>> builder(MarshallingType.LIST)
            .memberName("tableColumns")
            .getter(getter(ListTableColumnsResponse::tableColumns))
            .setter(setter(Builder::tableColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TableColumn> builder(MarshallingType.SDK_POJO)
                                            .constructor(TableColumn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTableColumnsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Long> WORKBOOK_CURSOR_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("workbookCursor").getter(getter(ListTableColumnsResponse::workbookCursor))
            .setter(setter(Builder::workbookCursor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workbookCursor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_COLUMNS_FIELD,
            NEXT_TOKEN_FIELD, WORKBOOK_CURSOR_FIELD));

    private final List<TableColumn> tableColumns;

    private final String nextToken;

    private final Long workbookCursor;

    private ListTableColumnsResponse(BuilderImpl builder) {
        super(builder);
        this.tableColumns = builder.tableColumns;
        this.nextToken = builder.nextToken;
        this.workbookCursor = builder.workbookCursor;
    }

    /**
     * Returns true if the TableColumns property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTableColumns() {
        return tableColumns != null && !(tableColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of columns in the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTableColumns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of columns in the table.
     */
    public List<TableColumn> tableColumns() {
        return tableColumns;
    }

    /**
     * <p>
     * Provides the pagination token to load the next page if there are more results matching the request. If a
     * pagination token is not present in the response, it means that all data matching the request has been loaded.
     * </p>
     * 
     * @return Provides the pagination token to load the next page if there are more results matching the request. If a
     *         pagination token is not present in the response, it means that all data matching the request has been
     *         loaded.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps
     * increasing with every update and the increments are not sequential.
     * </p>
     * 
     * @return Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor
     *         keeps increasing with every update and the increments are not sequential.
     */
    public Long workbookCursor() {
        return workbookCursor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTableColumns() ? tableColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(workbookCursor());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTableColumnsResponse)) {
            return false;
        }
        ListTableColumnsResponse other = (ListTableColumnsResponse) obj;
        return hasTableColumns() == other.hasTableColumns() && Objects.equals(tableColumns(), other.tableColumns())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(workbookCursor(), other.workbookCursor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTableColumnsResponse").add("TableColumns", hasTableColumns() ? tableColumns() : null)
                .add("NextToken", nextToken()).add("WorkbookCursor", workbookCursor()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tableColumns":
            return Optional.ofNullable(clazz.cast(tableColumns()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "workbookCursor":
            return Optional.ofNullable(clazz.cast(workbookCursor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTableColumnsResponse, T> g) {
        return obj -> g.apply((ListTableColumnsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HoneycodeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTableColumnsResponse> {
        /**
         * <p>
         * The list of columns in the table.
         * </p>
         * 
         * @param tableColumns
         *        The list of columns in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableColumns(Collection<TableColumn> tableColumns);

        /**
         * <p>
         * The list of columns in the table.
         * </p>
         * 
         * @param tableColumns
         *        The list of columns in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableColumns(TableColumn... tableColumns);

        /**
         * <p>
         * The list of columns in the table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TableColumn>.Builder} avoiding the need to
         * create one manually via {@link List<TableColumn>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TableColumn>.Builder#build()} is called immediately and its
         * result is passed to {@link #tableColumns(List<TableColumn>)}.
         * 
         * @param tableColumns
         *        a consumer that will call methods on {@link List<TableColumn>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableColumns(List<TableColumn>)
         */
        Builder tableColumns(Consumer<TableColumn.Builder>... tableColumns);

        /**
         * <p>
         * Provides the pagination token to load the next page if there are more results matching the request. If a
         * pagination token is not present in the response, it means that all data matching the request has been loaded.
         * </p>
         * 
         * @param nextToken
         *        Provides the pagination token to load the next page if there are more results matching the request. If
         *        a pagination token is not present in the response, it means that all data matching the request has
         *        been loaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor
         * keeps increasing with every update and the increments are not sequential.
         * </p>
         * 
         * @param workbookCursor
         *        Indicates the cursor of the workbook at which the data returned by this request is read. Workbook
         *        cursor keeps increasing with every update and the increments are not sequential.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workbookCursor(Long workbookCursor);
    }

    static final class BuilderImpl extends HoneycodeResponse.BuilderImpl implements Builder {
        private List<TableColumn> tableColumns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Long workbookCursor;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTableColumnsResponse model) {
            super(model);
            tableColumns(model.tableColumns);
            nextToken(model.nextToken);
            workbookCursor(model.workbookCursor);
        }

        public final Collection<TableColumn.Builder> getTableColumns() {
            if (tableColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return tableColumns != null ? tableColumns.stream().map(TableColumn::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tableColumns(Collection<TableColumn> tableColumns) {
            this.tableColumns = TableColumnsCopier.copy(tableColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableColumns(TableColumn... tableColumns) {
            tableColumns(Arrays.asList(tableColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableColumns(Consumer<TableColumn.Builder>... tableColumns) {
            tableColumns(Stream.of(tableColumns).map(c -> TableColumn.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTableColumns(Collection<TableColumn.BuilderImpl> tableColumns) {
            this.tableColumns = TableColumnsCopier.copyFromBuilder(tableColumns);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Long getWorkbookCursor() {
            return workbookCursor;
        }

        @Override
        public final Builder workbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
            return this;
        }

        public final void setWorkbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
        }

        @Override
        public ListTableColumnsResponse build() {
            return new ListTableColumnsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
