/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryTableRowsRequest extends HoneycodeRequest implements
        ToCopyableBuilder<QueryTableRowsRequest.Builder, QueryTableRowsRequest> {
    private static final SdkField<String> WORKBOOK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workbookId").getter(getter(QueryTableRowsRequest::workbookId)).setter(setter(Builder::workbookId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workbookId").build()).build();

    private static final SdkField<String> TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableId").getter(getter(QueryTableRowsRequest::tableId)).setter(setter(Builder::tableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableId").build()).build();

    private static final SdkField<Filter> FILTER_FORMULA_FIELD = SdkField.<Filter> builder(MarshallingType.SDK_POJO)
            .memberName("filterFormula").getter(getter(QueryTableRowsRequest::filterFormula))
            .setter(setter(Builder::filterFormula)).constructor(Filter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterFormula").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(QueryTableRowsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(QueryTableRowsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKBOOK_ID_FIELD,
            TABLE_ID_FIELD, FILTER_FORMULA_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String workbookId;

    private final String tableId;

    private final Filter filterFormula;

    private final Integer maxResults;

    private final String nextToken;

    private QueryTableRowsRequest(BuilderImpl builder) {
        super(builder);
        this.workbookId = builder.workbookId;
        this.tableId = builder.tableId;
        this.filterFormula = builder.filterFormula;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the workbook whose table rows are being queried.
     * </p>
     * <p>
     * If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
     * </p>
     * 
     * @return The ID of the workbook whose table rows are being queried.</p>
     *         <p>
     *         If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
     */
    public String workbookId() {
        return workbookId;
    }

    /**
     * <p>
     * The ID of the table whose rows are being queried.
     * </p>
     * <p>
     * If a table with the specified id could not be found, this API throws ResourceNotFoundException.
     * </p>
     * 
     * @return The ID of the table whose rows are being queried.</p>
     *         <p>
     *         If a table with the specified id could not be found, this API throws ResourceNotFoundException.
     */
    public String tableId() {
        return tableId;
    }

    /**
     * <p>
     * An object that represents a filter formula along with the id of the context row under which the filter function
     * needs to evaluate.
     * </p>
     * 
     * @return An object that represents a filter formula along with the id of the context row under which the filter
     *         function needs to evaluate.
     */
    public Filter filterFormula() {
        return filterFormula;
    }

    /**
     * <p>
     * The maximum number of rows to return in each page of the results.
     * </p>
     * 
     * @return The maximum number of rows to return in each page of the results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
     * </p>
     * <p>
     * Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will
     * throw ValidationException.
     * </p>
     * 
     * @return This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
     *         <p>
     *         Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the
     *         API will throw ValidationException.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workbookId());
        hashCode = 31 * hashCode + Objects.hashCode(tableId());
        hashCode = 31 * hashCode + Objects.hashCode(filterFormula());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryTableRowsRequest)) {
            return false;
        }
        QueryTableRowsRequest other = (QueryTableRowsRequest) obj;
        return Objects.equals(workbookId(), other.workbookId()) && Objects.equals(tableId(), other.tableId())
                && Objects.equals(filterFormula(), other.filterFormula()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("QueryTableRowsRequest").add("WorkbookId", workbookId()).add("TableId", tableId())
                .add("FilterFormula", filterFormula()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workbookId":
            return Optional.ofNullable(clazz.cast(workbookId()));
        case "tableId":
            return Optional.ofNullable(clazz.cast(tableId()));
        case "filterFormula":
            return Optional.ofNullable(clazz.cast(filterFormula()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryTableRowsRequest, T> g) {
        return obj -> g.apply((QueryTableRowsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HoneycodeRequest.Builder, SdkPojo, CopyableBuilder<Builder, QueryTableRowsRequest> {
        /**
         * <p>
         * The ID of the workbook whose table rows are being queried.
         * </p>
         * <p>
         * If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
         * </p>
         * 
         * @param workbookId
         *        The ID of the workbook whose table rows are being queried.</p>
         *        <p>
         *        If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workbookId(String workbookId);

        /**
         * <p>
         * The ID of the table whose rows are being queried.
         * </p>
         * <p>
         * If a table with the specified id could not be found, this API throws ResourceNotFoundException.
         * </p>
         * 
         * @param tableId
         *        The ID of the table whose rows are being queried.</p>
         *        <p>
         *        If a table with the specified id could not be found, this API throws ResourceNotFoundException.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableId(String tableId);

        /**
         * <p>
         * An object that represents a filter formula along with the id of the context row under which the filter
         * function needs to evaluate.
         * </p>
         * 
         * @param filterFormula
         *        An object that represents a filter formula along with the id of the context row under which the filter
         *        function needs to evaluate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterFormula(Filter filterFormula);

        /**
         * <p>
         * An object that represents a filter formula along with the id of the context row under which the filter
         * function needs to evaluate.
         * </p>
         * This is a convenience that creates an instance of the {@link Filter.Builder} avoiding the need to create one
         * manually via {@link Filter#builder()}.
         *
         * When the {@link Consumer} completes, {@link Filter.Builder#build()} is called immediately and its result is
         * passed to {@link #filterFormula(Filter)}.
         * 
         * @param filterFormula
         *        a consumer that will call methods on {@link Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterFormula(Filter)
         */
        default Builder filterFormula(Consumer<Filter.Builder> filterFormula) {
            return filterFormula(Filter.builder().applyMutation(filterFormula).build());
        }

        /**
         * <p>
         * The maximum number of rows to return in each page of the results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of rows to return in each page of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
         * </p>
         * <p>
         * Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API
         * will throw ValidationException.
         * </p>
         * 
         * @param nextToken
         *        This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
         *        </p>
         *        <p>
         *        Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back,
         *        the API will throw ValidationException.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends HoneycodeRequest.BuilderImpl implements Builder {
        private String workbookId;

        private String tableId;

        private Filter filterFormula;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryTableRowsRequest model) {
            super(model);
            workbookId(model.workbookId);
            tableId(model.tableId);
            filterFormula(model.filterFormula);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getWorkbookId() {
            return workbookId;
        }

        @Override
        public final Builder workbookId(String workbookId) {
            this.workbookId = workbookId;
            return this;
        }

        public final void setWorkbookId(String workbookId) {
            this.workbookId = workbookId;
        }

        public final String getTableId() {
            return tableId;
        }

        @Override
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        public final Filter.Builder getFilterFormula() {
            return filterFormula != null ? filterFormula.toBuilder() : null;
        }

        @Override
        public final Builder filterFormula(Filter filterFormula) {
            this.filterFormula = filterFormula;
            return this;
        }

        public final void setFilterFormula(Filter.BuilderImpl filterFormula) {
            this.filterFormula = filterFormula != null ? filterFormula.build() : null;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public QueryTableRowsRequest build() {
            return new QueryTableRowsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
