/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTableDataImportJobRequest extends HoneycodeRequest implements
        ToCopyableBuilder<StartTableDataImportJobRequest.Builder, StartTableDataImportJobRequest> {
    private static final SdkField<String> WORKBOOK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workbookId").getter(getter(StartTableDataImportJobRequest::workbookId))
            .setter(setter(Builder::workbookId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workbookId").build()).build();

    private static final SdkField<ImportDataSource> DATA_SOURCE_FIELD = SdkField
            .<ImportDataSource> builder(MarshallingType.SDK_POJO).memberName("dataSource")
            .getter(getter(StartTableDataImportJobRequest::dataSource)).setter(setter(Builder::dataSource))
            .constructor(ImportDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()).build();

    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataFormat").getter(getter(StartTableDataImportJobRequest::dataFormatAsString))
            .setter(setter(Builder::dataFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFormat").build()).build();

    private static final SdkField<String> DESTINATION_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationTableId").getter(getter(StartTableDataImportJobRequest::destinationTableId))
            .setter(setter(Builder::destinationTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableId").build()).build();

    private static final SdkField<ImportOptions> IMPORT_OPTIONS_FIELD = SdkField
            .<ImportOptions> builder(MarshallingType.SDK_POJO).memberName("importOptions")
            .getter(getter(StartTableDataImportJobRequest::importOptions)).setter(setter(Builder::importOptions))
            .constructor(ImportOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importOptions").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken").getter(getter(StartTableDataImportJobRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKBOOK_ID_FIELD,
            DATA_SOURCE_FIELD, DATA_FORMAT_FIELD, DESTINATION_TABLE_ID_FIELD, IMPORT_OPTIONS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String workbookId;

    private final ImportDataSource dataSource;

    private final String dataFormat;

    private final String destinationTableId;

    private final ImportOptions importOptions;

    private final String clientRequestToken;

    private StartTableDataImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.workbookId = builder.workbookId;
        this.dataSource = builder.dataSource;
        this.dataFormat = builder.dataFormat;
        this.destinationTableId = builder.destinationTableId;
        this.importOptions = builder.importOptions;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The ID of the workbook where the rows are being imported.
     * </p>
     * <p>
     * If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
     * </p>
     * 
     * @return The ID of the workbook where the rows are being imported.</p>
     *         <p>
     *         If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
     */
    public String workbookId() {
        return workbookId;
    }

    /**
     * <p>
     * The source of the data that is being imported. The size of source must be no larger than 100 MB. Source must have
     * no more than 100,000 cells and no more than 1,000 rows.
     * </p>
     * 
     * @return The source of the data that is being imported. The size of source must be no larger than 100 MB. Source
     *         must have no more than 100,000 cells and no more than 1,000 rows.
     */
    public ImportDataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The format of the data that is being imported. Currently the only option supported is "DELIMITED_TEXT".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link ImportSourceDataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataFormatAsString}.
     * </p>
     * 
     * @return The format of the data that is being imported. Currently the only option supported is "DELIMITED_TEXT".
     * @see ImportSourceDataFormat
     */
    public ImportSourceDataFormat dataFormat() {
        return ImportSourceDataFormat.fromValue(dataFormat);
    }

    /**
     * <p>
     * The format of the data that is being imported. Currently the only option supported is "DELIMITED_TEXT".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link ImportSourceDataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataFormatAsString}.
     * </p>
     * 
     * @return The format of the data that is being imported. Currently the only option supported is "DELIMITED_TEXT".
     * @see ImportSourceDataFormat
     */
    public String dataFormatAsString() {
        return dataFormat;
    }

    /**
     * <p>
     * The ID of the table where the rows are being imported.
     * </p>
     * <p>
     * If a table with the specified id could not be found, this API throws ResourceNotFoundException.
     * </p>
     * 
     * @return The ID of the table where the rows are being imported.</p>
     *         <p>
     *         If a table with the specified id could not be found, this API throws ResourceNotFoundException.
     */
    public String destinationTableId() {
        return destinationTableId;
    }

    /**
     * <p>
     * The options for customizing this import request.
     * </p>
     * 
     * @return The options for customizing this import request.
     */
    public ImportOptions importOptions() {
        return importOptions;
    }

    /**
     * <p>
     * The request token for performing the update action. Request tokens help to identify duplicate requests. If a call
     * times out or fails due to a transient error like a failed network connection, you can retry the call with the
     * same request token. The service ensures that if the first call using that request token is successfully
     * performed, the second call will not perform the action again.
     * </p>
     * <p>
     * Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests
     * spanning hours or days.
     * </p>
     * 
     * @return The request token for performing the update action. Request tokens help to identify duplicate requests.
     *         If a call times out or fails due to a transient error like a failed network connection, you can retry the
     *         call with the same request token. The service ensures that if the first call using that request token is
     *         successfully performed, the second call will not perform the action again. </p>
     *         <p>
     *         Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe
     *         requests spanning hours or days.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workbookId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationTableId());
        hashCode = 31 * hashCode + Objects.hashCode(importOptions());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTableDataImportJobRequest)) {
            return false;
        }
        StartTableDataImportJobRequest other = (StartTableDataImportJobRequest) obj;
        return Objects.equals(workbookId(), other.workbookId()) && Objects.equals(dataSource(), other.dataSource())
                && Objects.equals(dataFormatAsString(), other.dataFormatAsString())
                && Objects.equals(destinationTableId(), other.destinationTableId())
                && Objects.equals(importOptions(), other.importOptions())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartTableDataImportJobRequest").add("WorkbookId", workbookId()).add("DataSource", dataSource())
                .add("DataFormat", dataFormatAsString()).add("DestinationTableId", destinationTableId())
                .add("ImportOptions", importOptions()).add("ClientRequestToken", clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workbookId":
            return Optional.ofNullable(clazz.cast(workbookId()));
        case "dataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "dataFormat":
            return Optional.ofNullable(clazz.cast(dataFormatAsString()));
        case "destinationTableId":
            return Optional.ofNullable(clazz.cast(destinationTableId()));
        case "importOptions":
            return Optional.ofNullable(clazz.cast(importOptions()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTableDataImportJobRequest, T> g) {
        return obj -> g.apply((StartTableDataImportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HoneycodeRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartTableDataImportJobRequest> {
        /**
         * <p>
         * The ID of the workbook where the rows are being imported.
         * </p>
         * <p>
         * If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
         * </p>
         * 
         * @param workbookId
         *        The ID of the workbook where the rows are being imported.</p>
         *        <p>
         *        If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workbookId(String workbookId);

        /**
         * <p>
         * The source of the data that is being imported. The size of source must be no larger than 100 MB. Source must
         * have no more than 100,000 cells and no more than 1,000 rows.
         * </p>
         * 
         * @param dataSource
         *        The source of the data that is being imported. The size of source must be no larger than 100 MB.
         *        Source must have no more than 100,000 cells and no more than 1,000 rows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(ImportDataSource dataSource);

        /**
         * <p>
         * The source of the data that is being imported. The size of source must be no larger than 100 MB. Source must
         * have no more than 100,000 cells and no more than 1,000 rows.
         * </p>
         * This is a convenience that creates an instance of the {@link ImportDataSource.Builder} avoiding the need to
         * create one manually via {@link ImportDataSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImportDataSource.Builder#build()} is called immediately and its
         * result is passed to {@link #dataSource(ImportDataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link ImportDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(ImportDataSource)
         */
        default Builder dataSource(Consumer<ImportDataSource.Builder> dataSource) {
            return dataSource(ImportDataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * The format of the data that is being imported. Currently the only option supported is "DELIMITED_TEXT".
         * </p>
         * 
         * @param dataFormat
         *        The format of the data that is being imported. Currently the only option supported is
         *        "DELIMITED_TEXT".
         * @see ImportSourceDataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportSourceDataFormat
         */
        Builder dataFormat(String dataFormat);

        /**
         * <p>
         * The format of the data that is being imported. Currently the only option supported is "DELIMITED_TEXT".
         * </p>
         * 
         * @param dataFormat
         *        The format of the data that is being imported. Currently the only option supported is
         *        "DELIMITED_TEXT".
         * @see ImportSourceDataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportSourceDataFormat
         */
        Builder dataFormat(ImportSourceDataFormat dataFormat);

        /**
         * <p>
         * The ID of the table where the rows are being imported.
         * </p>
         * <p>
         * If a table with the specified id could not be found, this API throws ResourceNotFoundException.
         * </p>
         * 
         * @param destinationTableId
         *        The ID of the table where the rows are being imported.</p>
         *        <p>
         *        If a table with the specified id could not be found, this API throws ResourceNotFoundException.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationTableId(String destinationTableId);

        /**
         * <p>
         * The options for customizing this import request.
         * </p>
         * 
         * @param importOptions
         *        The options for customizing this import request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importOptions(ImportOptions importOptions);

        /**
         * <p>
         * The options for customizing this import request.
         * </p>
         * This is a convenience that creates an instance of the {@link ImportOptions.Builder} avoiding the need to
         * create one manually via {@link ImportOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImportOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #importOptions(ImportOptions)}.
         * 
         * @param importOptions
         *        a consumer that will call methods on {@link ImportOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importOptions(ImportOptions)
         */
        default Builder importOptions(Consumer<ImportOptions.Builder> importOptions) {
            return importOptions(ImportOptions.builder().applyMutation(importOptions).build());
        }

        /**
         * <p>
         * The request token for performing the update action. Request tokens help to identify duplicate requests. If a
         * call times out or fails due to a transient error like a failed network connection, you can retry the call
         * with the same request token. The service ensures that if the first call using that request token is
         * successfully performed, the second call will not perform the action again.
         * </p>
         * <p>
         * Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests
         * spanning hours or days.
         * </p>
         * 
         * @param clientRequestToken
         *        The request token for performing the update action. Request tokens help to identify duplicate
         *        requests. If a call times out or fails due to a transient error like a failed network connection, you
         *        can retry the call with the same request token. The service ensures that if the first call using that
         *        request token is successfully performed, the second call will not perform the action again. </p>
         *        <p>
         *        Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe
         *        requests spanning hours or days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends HoneycodeRequest.BuilderImpl implements Builder {
        private String workbookId;

        private ImportDataSource dataSource;

        private String dataFormat;

        private String destinationTableId;

        private ImportOptions importOptions;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTableDataImportJobRequest model) {
            super(model);
            workbookId(model.workbookId);
            dataSource(model.dataSource);
            dataFormat(model.dataFormat);
            destinationTableId(model.destinationTableId);
            importOptions(model.importOptions);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getWorkbookId() {
            return workbookId;
        }

        @Override
        public final Builder workbookId(String workbookId) {
            this.workbookId = workbookId;
            return this;
        }

        public final void setWorkbookId(String workbookId) {
            this.workbookId = workbookId;
        }

        public final ImportDataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        @Override
        public final Builder dataSource(ImportDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(ImportDataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        public final String getDataFormat() {
            return dataFormat;
        }

        @Override
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public final Builder dataFormat(ImportSourceDataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        public final String getDestinationTableId() {
            return destinationTableId;
        }

        @Override
        public final Builder destinationTableId(String destinationTableId) {
            this.destinationTableId = destinationTableId;
            return this;
        }

        public final void setDestinationTableId(String destinationTableId) {
            this.destinationTableId = destinationTableId;
        }

        public final ImportOptions.Builder getImportOptions() {
            return importOptions != null ? importOptions.toBuilder() : null;
        }

        @Override
        public final Builder importOptions(ImportOptions importOptions) {
            this.importOptions = importOptions;
            return this;
        }

        public final void setImportOptions(ImportOptions.BuilderImpl importOptions) {
            this.importOptions = importOptions != null ? importOptions.build() : null;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTableDataImportJobRequest build() {
            return new StartTableDataImportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
