/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the properties of a table in a workbook.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Table implements SdkPojo, Serializable, ToCopyableBuilder<Table.Builder, Table> {
    private static final SdkField<String> TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableId").getter(getter(Table::tableId)).setter(setter(Builder::tableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableId").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableName").getter(getter(Table::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_ID_FIELD,
            TABLE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tableId;

    private final String tableName;

    private Table(BuilderImpl builder) {
        this.tableId = builder.tableId;
        this.tableName = builder.tableName;
    }

    /**
     * <p>
     * The id of the table.
     * </p>
     * 
     * @return The id of the table.
     */
    public String tableId() {
        return tableId;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public String tableName() {
        return tableName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableId());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Table)) {
            return false;
        }
        Table other = (Table) obj;
        return Objects.equals(tableId(), other.tableId()) && Objects.equals(tableName(), other.tableName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Table").add("TableId", tableId()).add("TableName", tableName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tableId":
            return Optional.ofNullable(clazz.cast(tableId()));
        case "tableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Table, T> g) {
        return obj -> g.apply((Table) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Table> {
        /**
         * <p>
         * The id of the table.
         * </p>
         * 
         * @param tableId
         *        The id of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableId(String tableId);

        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param tableName
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);
    }

    static final class BuilderImpl implements Builder {
        private String tableId;

        private String tableName;

        private BuilderImpl() {
        }

        private BuilderImpl(Table model) {
            tableId(model.tableId);
            tableName(model.tableName);
        }

        public final String getTableId() {
            return tableId;
        }

        @Override
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public Table build() {
            return new Table(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
