/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains attributes about a single column in a table
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableColumn implements SdkPojo, Serializable, ToCopyableBuilder<TableColumn.Builder, TableColumn> {
    private static final SdkField<String> TABLE_COLUMN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableColumnId").getter(getter(TableColumn::tableColumnId)).setter(setter(Builder::tableColumnId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableColumnId").build()).build();

    private static final SdkField<String> TABLE_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableColumnName").getter(getter(TableColumn::tableColumnName)).setter(setter(Builder::tableColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableColumnName").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(TableColumn::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_COLUMN_ID_FIELD,
            TABLE_COLUMN_NAME_FIELD, FORMAT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tableColumnId;

    private final String tableColumnName;

    private final String format;

    private TableColumn(BuilderImpl builder) {
        this.tableColumnId = builder.tableColumnId;
        this.tableColumnName = builder.tableColumnName;
        this.format = builder.format;
    }

    /**
     * <p>
     * The id of the column in the table.
     * </p>
     * 
     * @return The id of the column in the table.
     */
    public String tableColumnId() {
        return tableColumnId;
    }

    /**
     * <p>
     * The name of the column in the table.
     * </p>
     * 
     * @return The name of the column in the table.
     */
    public String tableColumnName() {
        return tableColumnName;
    }

    /**
     * <p>
     * The column level format that is applied in the table. An empty value in this field means that the column format
     * is the default value 'AUTO'.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The column level format that is applied in the table. An empty value in this field means that the column
     *         format is the default value 'AUTO'.
     * @see Format
     */
    public Format format() {
        return Format.fromValue(format);
    }

    /**
     * <p>
     * The column level format that is applied in the table. An empty value in this field means that the column format
     * is the default value 'AUTO'.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The column level format that is applied in the table. An empty value in this field means that the column
     *         format is the default value 'AUTO'.
     * @see Format
     */
    public String formatAsString() {
        return format;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableColumnId());
        hashCode = 31 * hashCode + Objects.hashCode(tableColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableColumn)) {
            return false;
        }
        TableColumn other = (TableColumn) obj;
        return Objects.equals(tableColumnId(), other.tableColumnId())
                && Objects.equals(tableColumnName(), other.tableColumnName())
                && Objects.equals(formatAsString(), other.formatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TableColumn").add("TableColumnId", tableColumnId()).add("TableColumnName", tableColumnName())
                .add("Format", formatAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tableColumnId":
            return Optional.ofNullable(clazz.cast(tableColumnId()));
        case "tableColumnName":
            return Optional.ofNullable(clazz.cast(tableColumnName()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableColumn, T> g) {
        return obj -> g.apply((TableColumn) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableColumn> {
        /**
         * <p>
         * The id of the column in the table.
         * </p>
         * 
         * @param tableColumnId
         *        The id of the column in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableColumnId(String tableColumnId);

        /**
         * <p>
         * The name of the column in the table.
         * </p>
         * 
         * @param tableColumnName
         *        The name of the column in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableColumnName(String tableColumnName);

        /**
         * <p>
         * The column level format that is applied in the table. An empty value in this field means that the column
         * format is the default value 'AUTO'.
         * </p>
         * 
         * @param format
         *        The column level format that is applied in the table. An empty value in this field means that the
         *        column format is the default value 'AUTO'.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(String format);

        /**
         * <p>
         * The column level format that is applied in the table. An empty value in this field means that the column
         * format is the default value 'AUTO'.
         * </p>
         * 
         * @param format
         *        The column level format that is applied in the table. An empty value in this field means that the
         *        column format is the default value 'AUTO'.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(Format format);
    }

    static final class BuilderImpl implements Builder {
        private String tableColumnId;

        private String tableColumnName;

        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(TableColumn model) {
            tableColumnId(model.tableColumnId);
            tableColumnName(model.tableColumnName);
            format(model.format);
        }

        public final String getTableColumnId() {
            return tableColumnId;
        }

        @Override
        public final Builder tableColumnId(String tableColumnId) {
            this.tableColumnId = tableColumnId;
            return this;
        }

        public final void setTableColumnId(String tableColumnId) {
            this.tableColumnId = tableColumnId;
        }

        public final String getTableColumnName() {
            return tableColumnName;
        }

        @Override
        public final Builder tableColumnName(String tableColumnName) {
            this.tableColumnName = tableColumnName;
            return this;
        }

        public final void setTableColumnName(String tableColumnName) {
            this.tableColumnName = tableColumnName;
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public TableColumn build() {
            return new TableColumn(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
