/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.honeycode.model.CellInput;
import software.amazon.awssdk.services.honeycode.model.RowDataInputCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRowData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateRowData> {
    private static final SdkField<String> BATCH_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("batchItemId").getter(CreateRowData.getter(CreateRowData::batchItemId)).setter(CreateRowData.setter(Builder::batchItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchItemId").build()}).build();
    private static final SdkField<Map<String, CellInput>> CELLS_TO_CREATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("cellsToCreate").getter(CreateRowData.getter(CreateRowData::cellsToCreate)).setter(CreateRowData.setter(Builder::cellsToCreate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cellsToCreate").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CellInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_ITEM_ID_FIELD, CELLS_TO_CREATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String batchItemId;
    private final Map<String, CellInput> cellsToCreate;

    private CreateRowData(BuilderImpl builder) {
        this.batchItemId = builder.batchItemId;
        this.cellsToCreate = builder.cellsToCreate;
    }

    public String batchItemId() {
        return this.batchItemId;
    }

    public boolean hasCellsToCreate() {
        return this.cellsToCreate != null && !(this.cellsToCreate instanceof SdkAutoConstructMap);
    }

    public Map<String, CellInput> cellsToCreate() {
        return this.cellsToCreate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.batchItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCellsToCreate() ? this.cellsToCreate() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRowData)) {
            return false;
        }
        CreateRowData other = (CreateRowData)obj;
        return Objects.equals(this.batchItemId(), other.batchItemId()) && this.hasCellsToCreate() == other.hasCellsToCreate() && Objects.equals(this.cellsToCreate(), other.cellsToCreate());
    }

    public String toString() {
        return ToString.builder((String)"CreateRowData").add("BatchItemId", (Object)this.batchItemId()).add("CellsToCreate", this.hasCellsToCreate() ? this.cellsToCreate() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "batchItemId": {
                return Optional.ofNullable(clazz.cast(this.batchItemId()));
            }
            case "cellsToCreate": {
                return Optional.ofNullable(clazz.cast(this.cellsToCreate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRowData, T> g) {
        return obj -> g.apply((CreateRowData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String batchItemId;
        private Map<String, CellInput> cellsToCreate = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRowData model) {
            this.batchItemId(model.batchItemId);
            this.cellsToCreate(model.cellsToCreate);
        }

        public final String getBatchItemId() {
            return this.batchItemId;
        }

        @Override
        public final Builder batchItemId(String batchItemId) {
            this.batchItemId = batchItemId;
            return this;
        }

        public final void setBatchItemId(String batchItemId) {
            this.batchItemId = batchItemId;
        }

        public final Map<String, CellInput.Builder> getCellsToCreate() {
            if (this.cellsToCreate instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.cellsToCreate != null ? CollectionUtils.mapValues(this.cellsToCreate, CellInput::toBuilder) : null;
        }

        @Override
        public final Builder cellsToCreate(Map<String, CellInput> cellsToCreate) {
            this.cellsToCreate = RowDataInputCopier.copy(cellsToCreate);
            return this;
        }

        public final void setCellsToCreate(Map<String, CellInput.BuilderImpl> cellsToCreate) {
            this.cellsToCreate = RowDataInputCopier.copyFromBuilder(cellsToCreate);
        }

        public CreateRowData build() {
            return new CreateRowData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateRowData> {
        public Builder batchItemId(String var1);

        public Builder cellsToCreate(Map<String, CellInput> var1);
    }
}

