/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.honeycode.model.HoneycodeResponse;
import software.amazon.awssdk.services.honeycode.model.Table;
import software.amazon.awssdk.services.honeycode.model.TablesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTablesResponse
extends HoneycodeResponse
implements ToCopyableBuilder<Builder, ListTablesResponse> {
    private static final SdkField<List<Table>> TABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tables").getter(ListTablesResponse.getter(ListTablesResponse::tables)).setter(ListTablesResponse.setter(Builder::tables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Table::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTablesResponse.getter(ListTablesResponse::nextToken)).setter(ListTablesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Long> WORKBOOK_CURSOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("workbookCursor").getter(ListTablesResponse.getter(ListTablesResponse::workbookCursor)).setter(ListTablesResponse.setter(Builder::workbookCursor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workbookCursor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLES_FIELD, NEXT_TOKEN_FIELD, WORKBOOK_CURSOR_FIELD));
    private final List<Table> tables;
    private final String nextToken;
    private final Long workbookCursor;

    private ListTablesResponse(BuilderImpl builder) {
        super(builder);
        this.tables = builder.tables;
        this.nextToken = builder.nextToken;
        this.workbookCursor = builder.workbookCursor;
    }

    public boolean hasTables() {
        return this.tables != null && !(this.tables instanceof SdkAutoConstructList);
    }

    public List<Table> tables() {
        return this.tables;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Long workbookCursor() {
        return this.workbookCursor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTables() ? this.tables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.workbookCursor());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTablesResponse)) {
            return false;
        }
        ListTablesResponse other = (ListTablesResponse)((Object)obj);
        return this.hasTables() == other.hasTables() && Objects.equals(this.tables(), other.tables()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.workbookCursor(), other.workbookCursor());
    }

    public String toString() {
        return ToString.builder((String)"ListTablesResponse").add("Tables", this.hasTables() ? this.tables() : null).add("NextToken", (Object)this.nextToken()).add("WorkbookCursor", (Object)this.workbookCursor()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tables": {
                return Optional.ofNullable(clazz.cast(this.tables()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "workbookCursor": {
                return Optional.ofNullable(clazz.cast(this.workbookCursor()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTablesResponse, T> g) {
        return obj -> g.apply((ListTablesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HoneycodeResponse.BuilderImpl
    implements Builder {
        private List<Table> tables = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Long workbookCursor;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTablesResponse model) {
            super(model);
            this.tables(model.tables);
            this.nextToken(model.nextToken);
            this.workbookCursor(model.workbookCursor);
        }

        public final Collection<Table.Builder> getTables() {
            if (this.tables instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tables != null ? (Collection)this.tables.stream().map(Table::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tables(Collection<Table> tables) {
            this.tables = TablesCopier.copy(tables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tables(Table ... tables) {
            this.tables(Arrays.asList(tables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tables(Consumer<Table.Builder> ... tables) {
            this.tables(Stream.of(tables).map(c -> (Table)((Table.Builder)Table.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTables(Collection<Table.BuilderImpl> tables) {
            this.tables = TablesCopier.copyFromBuilder(tables);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Long getWorkbookCursor() {
            return this.workbookCursor;
        }

        @Override
        public final Builder workbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
            return this;
        }

        public final void setWorkbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
        }

        @Override
        public ListTablesResponse build() {
            return new ListTablesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HoneycodeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTablesResponse> {
        public Builder tables(Collection<Table> var1);

        public Builder tables(Table ... var1);

        public Builder tables(Consumer<Table.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder workbookCursor(Long var1);
    }
}

