/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.honeycode.model.ImportDataSource;
import software.amazon.awssdk.services.honeycode.model.ImportJobSubmitter;
import software.amazon.awssdk.services.honeycode.model.ImportOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableDataImportJobMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableDataImportJobMetadata> {
    private static final SdkField<ImportJobSubmitter> SUBMITTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("submitter").getter(TableDataImportJobMetadata.getter(TableDataImportJobMetadata::submitter)).setter(TableDataImportJobMetadata.setter(Builder::submitter)).constructor(ImportJobSubmitter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submitter").build()}).build();
    private static final SdkField<Instant> SUBMIT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("submitTime").getter(TableDataImportJobMetadata.getter(TableDataImportJobMetadata::submitTime)).setter(TableDataImportJobMetadata.setter(Builder::submitTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submitTime").build()}).build();
    private static final SdkField<ImportOptions> IMPORT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("importOptions").getter(TableDataImportJobMetadata.getter(TableDataImportJobMetadata::importOptions)).setter(TableDataImportJobMetadata.setter(Builder::importOptions)).constructor(ImportOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importOptions").build()}).build();
    private static final SdkField<ImportDataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataSource").getter(TableDataImportJobMetadata.getter(TableDataImportJobMetadata::dataSource)).setter(TableDataImportJobMetadata.setter(Builder::dataSource)).constructor(ImportDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBMITTER_FIELD, SUBMIT_TIME_FIELD, IMPORT_OPTIONS_FIELD, DATA_SOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final ImportJobSubmitter submitter;
    private final Instant submitTime;
    private final ImportOptions importOptions;
    private final ImportDataSource dataSource;

    private TableDataImportJobMetadata(BuilderImpl builder) {
        this.submitter = builder.submitter;
        this.submitTime = builder.submitTime;
        this.importOptions = builder.importOptions;
        this.dataSource = builder.dataSource;
    }

    public ImportJobSubmitter submitter() {
        return this.submitter;
    }

    public Instant submitTime() {
        return this.submitTime;
    }

    public ImportOptions importOptions() {
        return this.importOptions;
    }

    public ImportDataSource dataSource() {
        return this.dataSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.submitter());
        hashCode = 31 * hashCode + Objects.hashCode(this.submitTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.importOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableDataImportJobMetadata)) {
            return false;
        }
        TableDataImportJobMetadata other = (TableDataImportJobMetadata)obj;
        return Objects.equals(this.submitter(), other.submitter()) && Objects.equals(this.submitTime(), other.submitTime()) && Objects.equals(this.importOptions(), other.importOptions()) && Objects.equals(this.dataSource(), other.dataSource());
    }

    public String toString() {
        return ToString.builder((String)"TableDataImportJobMetadata").add("Submitter", (Object)this.submitter()).add("SubmitTime", (Object)this.submitTime()).add("ImportOptions", (Object)this.importOptions()).add("DataSource", (Object)this.dataSource()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "submitter": {
                return Optional.ofNullable(clazz.cast(this.submitter()));
            }
            case "submitTime": {
                return Optional.ofNullable(clazz.cast(this.submitTime()));
            }
            case "importOptions": {
                return Optional.ofNullable(clazz.cast(this.importOptions()));
            }
            case "dataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableDataImportJobMetadata, T> g) {
        return obj -> g.apply((TableDataImportJobMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ImportJobSubmitter submitter;
        private Instant submitTime;
        private ImportOptions importOptions;
        private ImportDataSource dataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(TableDataImportJobMetadata model) {
            this.submitter(model.submitter);
            this.submitTime(model.submitTime);
            this.importOptions(model.importOptions);
            this.dataSource(model.dataSource);
        }

        public final ImportJobSubmitter.Builder getSubmitter() {
            return this.submitter != null ? this.submitter.toBuilder() : null;
        }

        @Override
        public final Builder submitter(ImportJobSubmitter submitter) {
            this.submitter = submitter;
            return this;
        }

        public final void setSubmitter(ImportJobSubmitter.BuilderImpl submitter) {
            this.submitter = submitter != null ? submitter.build() : null;
        }

        public final Instant getSubmitTime() {
            return this.submitTime;
        }

        @Override
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        public final ImportOptions.Builder getImportOptions() {
            return this.importOptions != null ? this.importOptions.toBuilder() : null;
        }

        @Override
        public final Builder importOptions(ImportOptions importOptions) {
            this.importOptions = importOptions;
            return this;
        }

        public final void setImportOptions(ImportOptions.BuilderImpl importOptions) {
            this.importOptions = importOptions != null ? importOptions.build() : null;
        }

        public final ImportDataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        @Override
        public final Builder dataSource(ImportDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(ImportDataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        public TableDataImportJobMetadata build() {
            return new TableDataImportJobMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableDataImportJobMetadata> {
        public Builder submitter(ImportJobSubmitter var1);

        default public Builder submitter(Consumer<ImportJobSubmitter.Builder> submitter) {
            return this.submitter((ImportJobSubmitter)((ImportJobSubmitter.Builder)ImportJobSubmitter.builder().applyMutation(submitter)).build());
        }

        public Builder submitTime(Instant var1);

        public Builder importOptions(ImportOptions var1);

        default public Builder importOptions(Consumer<ImportOptions.Builder> importOptions) {
            return this.importOptions((ImportOptions)((ImportOptions.Builder)ImportOptions.builder().applyMutation(importOptions)).build());
        }

        public Builder dataSource(ImportDataSource var1);

        default public Builder dataSource(Consumer<ImportDataSource.Builder> dataSource) {
            return this.dataSource((ImportDataSource)((ImportDataSource.Builder)ImportDataSource.builder().applyMutation(dataSource)).build());
        }
    }
}

