/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import static java.util.stream.Collectors.toMap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class ImportColumnMapCopier {
    static Map<String, SourceDataColumnProperties> copy(Map<String, SourceDataColumnProperties> importColumnMapParam) {
        if (importColumnMapParam == null || importColumnMapParam instanceof SdkAutoConstructMap) {
            return DefaultSdkAutoConstructMap.getInstance();
        }
        Map<String, SourceDataColumnProperties> importColumnMapParamCopy = importColumnMapParam.entrySet().stream()
                .collect(HashMap::new, (m, e) -> m.put(e.getKey(), e.getValue()), HashMap::putAll);
        return Collections.unmodifiableMap(importColumnMapParamCopy);
    }

    static Map<String, SourceDataColumnProperties> copyFromBuilder(
            Map<String, ? extends SourceDataColumnProperties.Builder> importColumnMapParam) {
        if (importColumnMapParam == null || importColumnMapParam instanceof DefaultSdkAutoConstructMap) {
            return DefaultSdkAutoConstructMap.getInstance();
        }
        return copy(importColumnMapParam.entrySet().stream().collect(toMap(Map.Entry::getKey, e -> e.getValue().build())));
    }
}
