/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.honeycode.HoneycodeClient;
import software.amazon.awssdk.services.honeycode.model.AccessDeniedException;
import software.amazon.awssdk.services.honeycode.model.AutomationExecutionException;
import software.amazon.awssdk.services.honeycode.model.AutomationExecutionTimeoutException;
import software.amazon.awssdk.services.honeycode.model.BatchCreateTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.BatchCreateTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.BatchDeleteTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.BatchDeleteTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.BatchUpdateTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.BatchUpdateTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.BatchUpsertTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.BatchUpsertTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.DescribeTableDataImportJobRequest;
import software.amazon.awssdk.services.honeycode.model.DescribeTableDataImportJobResponse;
import software.amazon.awssdk.services.honeycode.model.GetScreenDataRequest;
import software.amazon.awssdk.services.honeycode.model.GetScreenDataResponse;
import software.amazon.awssdk.services.honeycode.model.HoneycodeException;
import software.amazon.awssdk.services.honeycode.model.HoneycodeRequest;
import software.amazon.awssdk.services.honeycode.model.InternalServerException;
import software.amazon.awssdk.services.honeycode.model.InvokeScreenAutomationRequest;
import software.amazon.awssdk.services.honeycode.model.InvokeScreenAutomationResponse;
import software.amazon.awssdk.services.honeycode.model.ListTableColumnsRequest;
import software.amazon.awssdk.services.honeycode.model.ListTableColumnsResponse;
import software.amazon.awssdk.services.honeycode.model.ListTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.ListTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.ListTablesRequest;
import software.amazon.awssdk.services.honeycode.model.ListTablesResponse;
import software.amazon.awssdk.services.honeycode.model.QueryTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.QueryTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.RequestTimeoutException;
import software.amazon.awssdk.services.honeycode.model.ResourceNotFoundException;
import software.amazon.awssdk.services.honeycode.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.honeycode.model.ServiceUnavailableException;
import software.amazon.awssdk.services.honeycode.model.StartTableDataImportJobRequest;
import software.amazon.awssdk.services.honeycode.model.StartTableDataImportJobResponse;
import software.amazon.awssdk.services.honeycode.model.ThrottlingException;
import software.amazon.awssdk.services.honeycode.model.ValidationException;
import software.amazon.awssdk.services.honeycode.paginators.ListTableColumnsIterable;
import software.amazon.awssdk.services.honeycode.paginators.ListTableRowsIterable;
import software.amazon.awssdk.services.honeycode.paginators.ListTablesIterable;
import software.amazon.awssdk.services.honeycode.paginators.QueryTableRowsIterable;
import software.amazon.awssdk.services.honeycode.transform.BatchCreateTableRowsRequestMarshaller;
import software.amazon.awssdk.services.honeycode.transform.BatchDeleteTableRowsRequestMarshaller;
import software.amazon.awssdk.services.honeycode.transform.BatchUpdateTableRowsRequestMarshaller;
import software.amazon.awssdk.services.honeycode.transform.BatchUpsertTableRowsRequestMarshaller;
import software.amazon.awssdk.services.honeycode.transform.DescribeTableDataImportJobRequestMarshaller;
import software.amazon.awssdk.services.honeycode.transform.GetScreenDataRequestMarshaller;
import software.amazon.awssdk.services.honeycode.transform.InvokeScreenAutomationRequestMarshaller;
import software.amazon.awssdk.services.honeycode.transform.ListTableColumnsRequestMarshaller;
import software.amazon.awssdk.services.honeycode.transform.ListTableRowsRequestMarshaller;
import software.amazon.awssdk.services.honeycode.transform.ListTablesRequestMarshaller;
import software.amazon.awssdk.services.honeycode.transform.QueryTableRowsRequestMarshaller;
import software.amazon.awssdk.services.honeycode.transform.StartTableDataImportJobRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultHoneycodeClient
implements HoneycodeClient {
    private static final Logger log = Logger.loggerFor(DefaultHoneycodeClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultHoneycodeClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "honeycode";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchCreateTableRowsResponse batchCreateTableRows(BatchCreateTableRowsRequest batchCreateTableRowsRequest) throws AccessDeniedException, InternalServerException, RequestTimeoutException, ResourceNotFoundException, ServiceQuotaExceededException, ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, HoneycodeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchCreateTableRowsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultHoneycodeClient.resolveMetricPublishers(this.clientConfiguration, batchCreateTableRowsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Honeycode");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchCreateTableRows");
            BatchCreateTableRowsResponse batchCreateTableRowsResponse = (BatchCreateTableRowsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchCreateTableRows").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchCreateTableRowsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchCreateTableRowsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchCreateTableRowsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultHoneycodeClient.lambda$batchCreateTableRows$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDeleteTableRowsResponse batchDeleteTableRows(BatchDeleteTableRowsRequest batchDeleteTableRowsRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ServiceUnavailableException, ValidationException, RequestTimeoutException, ThrottlingException, AwsServiceException, SdkClientException, HoneycodeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteTableRowsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultHoneycodeClient.resolveMetricPublishers(this.clientConfiguration, batchDeleteTableRowsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Honeycode");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteTableRows");
            BatchDeleteTableRowsResponse batchDeleteTableRowsResponse = (BatchDeleteTableRowsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteTableRows").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDeleteTableRowsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDeleteTableRowsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDeleteTableRowsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultHoneycodeClient.lambda$batchDeleteTableRows$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchUpdateTableRowsResponse batchUpdateTableRows(BatchUpdateTableRowsRequest batchUpdateTableRowsRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ServiceUnavailableException, ValidationException, RequestTimeoutException, ThrottlingException, AwsServiceException, SdkClientException, HoneycodeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchUpdateTableRowsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultHoneycodeClient.resolveMetricPublishers(this.clientConfiguration, batchUpdateTableRowsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Honeycode");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchUpdateTableRows");
            BatchUpdateTableRowsResponse batchUpdateTableRowsResponse = (BatchUpdateTableRowsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchUpdateTableRows").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchUpdateTableRowsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchUpdateTableRowsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchUpdateTableRowsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultHoneycodeClient.lambda$batchUpdateTableRows$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchUpsertTableRowsResponse batchUpsertTableRows(BatchUpsertTableRowsRequest batchUpsertTableRowsRequest) throws AccessDeniedException, InternalServerException, RequestTimeoutException, ResourceNotFoundException, ServiceQuotaExceededException, ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, HoneycodeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchUpsertTableRowsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultHoneycodeClient.resolveMetricPublishers(this.clientConfiguration, batchUpsertTableRowsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Honeycode");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchUpsertTableRows");
            BatchUpsertTableRowsResponse batchUpsertTableRowsResponse = (BatchUpsertTableRowsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchUpsertTableRows").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchUpsertTableRowsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchUpsertTableRowsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchUpsertTableRowsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultHoneycodeClient.lambda$batchUpsertTableRows$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTableDataImportJobResponse describeTableDataImportJob(DescribeTableDataImportJobRequest describeTableDataImportJobRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, HoneycodeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTableDataImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultHoneycodeClient.resolveMetricPublishers(this.clientConfiguration, describeTableDataImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Honeycode");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTableDataImportJob");
            DescribeTableDataImportJobResponse describeTableDataImportJobResponse = (DescribeTableDataImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTableDataImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTableDataImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTableDataImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTableDataImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultHoneycodeClient.lambda$describeTableDataImportJob$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetScreenDataResponse getScreenData(GetScreenDataRequest getScreenDataRequest) throws AccessDeniedException, InternalServerException, RequestTimeoutException, ResourceNotFoundException, ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, HoneycodeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetScreenDataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultHoneycodeClient.resolveMetricPublishers(this.clientConfiguration, getScreenDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Honeycode");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetScreenData");
            GetScreenDataResponse getScreenDataResponse = (GetScreenDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetScreenData").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getScreenDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetScreenDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getScreenDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultHoneycodeClient.lambda$getScreenData$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InvokeScreenAutomationResponse invokeScreenAutomation(InvokeScreenAutomationRequest invokeScreenAutomationRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ValidationException, ThrottlingException, ServiceUnavailableException, AutomationExecutionException, AutomationExecutionTimeoutException, RequestTimeoutException, AwsServiceException, SdkClientException, HoneycodeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InvokeScreenAutomationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultHoneycodeClient.resolveMetricPublishers(this.clientConfiguration, invokeScreenAutomationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Honeycode");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"InvokeScreenAutomation");
            InvokeScreenAutomationResponse invokeScreenAutomationResponse = (InvokeScreenAutomationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("InvokeScreenAutomation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)invokeScreenAutomationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new InvokeScreenAutomationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return invokeScreenAutomationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultHoneycodeClient.lambda$invokeScreenAutomation$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTableColumnsResponse listTableColumns(ListTableColumnsRequest listTableColumnsRequest) throws AccessDeniedException, InternalServerException, RequestTimeoutException, ResourceNotFoundException, ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, HoneycodeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTableColumnsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultHoneycodeClient.resolveMetricPublishers(this.clientConfiguration, listTableColumnsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Honeycode");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTableColumns");
            ListTableColumnsResponse listTableColumnsResponse = (ListTableColumnsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTableColumns").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTableColumnsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTableColumnsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTableColumnsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultHoneycodeClient.lambda$listTableColumns$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTableColumnsIterable listTableColumnsPaginator(ListTableColumnsRequest listTableColumnsRequest) throws AccessDeniedException, InternalServerException, RequestTimeoutException, ResourceNotFoundException, ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, HoneycodeException {
        return new ListTableColumnsIterable(this, this.applyPaginatorUserAgent(listTableColumnsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTableRowsResponse listTableRows(ListTableRowsRequest listTableRowsRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ServiceUnavailableException, ValidationException, RequestTimeoutException, ThrottlingException, AwsServiceException, SdkClientException, HoneycodeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTableRowsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultHoneycodeClient.resolveMetricPublishers(this.clientConfiguration, listTableRowsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Honeycode");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTableRows");
            ListTableRowsResponse listTableRowsResponse = (ListTableRowsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTableRows").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTableRowsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTableRowsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTableRowsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultHoneycodeClient.lambda$listTableRows$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTableRowsIterable listTableRowsPaginator(ListTableRowsRequest listTableRowsRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ServiceUnavailableException, ValidationException, RequestTimeoutException, ThrottlingException, AwsServiceException, SdkClientException, HoneycodeException {
        return new ListTableRowsIterable(this, this.applyPaginatorUserAgent(listTableRowsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTablesResponse listTables(ListTablesRequest listTablesRequest) throws AccessDeniedException, InternalServerException, RequestTimeoutException, ResourceNotFoundException, ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, HoneycodeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTablesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultHoneycodeClient.resolveMetricPublishers(this.clientConfiguration, listTablesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Honeycode");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTables");
            ListTablesResponse listTablesResponse = (ListTablesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTables").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTablesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTablesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultHoneycodeClient.lambda$listTables$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTablesIterable listTablesPaginator(ListTablesRequest listTablesRequest) throws AccessDeniedException, InternalServerException, RequestTimeoutException, ResourceNotFoundException, ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, HoneycodeException {
        return new ListTablesIterable(this, this.applyPaginatorUserAgent(listTablesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryTableRowsResponse queryTableRows(QueryTableRowsRequest queryTableRowsRequest) throws AccessDeniedException, InternalServerException, RequestTimeoutException, ResourceNotFoundException, ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, HoneycodeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, QueryTableRowsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultHoneycodeClient.resolveMetricPublishers(this.clientConfiguration, queryTableRowsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Honeycode");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"QueryTableRows");
            QueryTableRowsResponse queryTableRowsResponse = (QueryTableRowsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("QueryTableRows").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)queryTableRowsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new QueryTableRowsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return queryTableRowsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultHoneycodeClient.lambda$queryTableRows$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public QueryTableRowsIterable queryTableRowsPaginator(QueryTableRowsRequest queryTableRowsRequest) throws AccessDeniedException, InternalServerException, RequestTimeoutException, ResourceNotFoundException, ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, HoneycodeException {
        return new QueryTableRowsIterable(this, this.applyPaginatorUserAgent(queryTableRowsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartTableDataImportJobResponse startTableDataImportJob(StartTableDataImportJobRequest startTableDataImportJobRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ServiceUnavailableException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, HoneycodeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTableDataImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultHoneycodeClient.resolveMetricPublishers(this.clientConfiguration, startTableDataImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Honeycode");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartTableDataImportJob");
            StartTableDataImportJobResponse startTableDataImportJobResponse = (StartTableDataImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTableDataImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startTableDataImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartTableDataImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startTableDataImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultHoneycodeClient.lambda$startTableDataImportJob$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(HoneycodeException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AutomationExecutionException").exceptionBuilderSupplier(AutomationExecutionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RequestTimeoutException").exceptionBuilderSupplier(RequestTimeoutException::builder).httpStatusCode(Integer.valueOf(504)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AutomationExecutionTimeoutException").exceptionBuilderSupplier(AutomationExecutionTimeoutException::builder).httpStatusCode(Integer.valueOf(504)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(503)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends HoneycodeRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.16.42").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((HoneycodeRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$startTableDataImportJob$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$queryTableRows$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTables$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTableRows$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTableColumns$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$invokeScreenAutomation$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getScreenData$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTableDataImportJob$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchUpsertTableRows$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchUpdateTableRows$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteTableRows$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchCreateTableRows$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

