/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportJobSubmitter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportJobSubmitter> {
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("email").getter(ImportJobSubmitter.getter(ImportJobSubmitter::email)).setter(ImportJobSubmitter.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()}).build();
    private static final SdkField<String> USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userArn").getter(ImportJobSubmitter.getter(ImportJobSubmitter::userArn)).setter(ImportJobSubmitter.setter(Builder::userArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_FIELD, USER_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String email;
    private final String userArn;

    private ImportJobSubmitter(BuilderImpl builder) {
        this.email = builder.email;
        this.userArn = builder.userArn;
    }

    public final String email() {
        return this.email;
    }

    public final String userArn() {
        return this.userArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportJobSubmitter)) {
            return false;
        }
        ImportJobSubmitter other = (ImportJobSubmitter)obj;
        return Objects.equals(this.email(), other.email()) && Objects.equals(this.userArn(), other.userArn());
    }

    public final String toString() {
        return ToString.builder((String)"ImportJobSubmitter").add("Email", (Object)(this.email() == null ? null : "*** Sensitive Data Redacted ***")).add("UserArn", (Object)this.userArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "userArn": {
                return Optional.ofNullable(clazz.cast(this.userArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportJobSubmitter, T> g) {
        return obj -> g.apply((ImportJobSubmitter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String email;
        private String userArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportJobSubmitter model) {
            this.email(model.email);
            this.userArn(model.userArn);
        }

        public final String getEmail() {
            return this.email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getUserArn() {
            return this.userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public ImportJobSubmitter build() {
            return new ImportJobSubmitter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportJobSubmitter> {
        public Builder email(String var1);

        public Builder userArn(String var1);
    }
}

