/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.honeycode.model.Cell;
import software.amazon.awssdk.services.honeycode.model.CellsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableRow
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableRow> {
    private static final SdkField<String> ROW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rowId").getter(TableRow.getter(TableRow::rowId)).setter(TableRow.setter(Builder::rowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowId").build()}).build();
    private static final SdkField<List<Cell>> CELLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cells").getter(TableRow.getter(TableRow::cells)).setter(TableRow.setter(Builder::cells)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cells").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Cell::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROW_ID_FIELD, CELLS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String rowId;
    private final List<Cell> cells;

    private TableRow(BuilderImpl builder) {
        this.rowId = builder.rowId;
        this.cells = builder.cells;
    }

    public final String rowId() {
        return this.rowId;
    }

    public final boolean hasCells() {
        return this.cells != null && !(this.cells instanceof SdkAutoConstructList);
    }

    public final List<Cell> cells() {
        return this.cells;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCells() ? this.cells() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableRow)) {
            return false;
        }
        TableRow other = (TableRow)obj;
        return Objects.equals(this.rowId(), other.rowId()) && this.hasCells() == other.hasCells() && Objects.equals(this.cells(), other.cells());
    }

    public final String toString() {
        return ToString.builder((String)"TableRow").add("RowId", (Object)this.rowId()).add("Cells", (Object)(this.cells() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "rowId": {
                return Optional.ofNullable(clazz.cast(this.rowId()));
            }
            case "cells": {
                return Optional.ofNullable(clazz.cast(this.cells()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableRow, T> g) {
        return obj -> g.apply((TableRow)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String rowId;
        private List<Cell> cells = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TableRow model) {
            this.rowId(model.rowId);
            this.cells(model.cells);
        }

        public final String getRowId() {
            return this.rowId;
        }

        @Override
        public final Builder rowId(String rowId) {
            this.rowId = rowId;
            return this;
        }

        public final void setRowId(String rowId) {
            this.rowId = rowId;
        }

        public final Collection<Cell.Builder> getCells() {
            if (this.cells instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cells != null ? (Collection)this.cells.stream().map(Cell::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cells(Collection<Cell> cells) {
            this.cells = CellsCopier.copy(cells);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cells(Cell ... cells) {
            this.cells(Arrays.asList(cells));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cells(Consumer<Cell.Builder> ... cells) {
            this.cells(Stream.of(cells).map(c -> (Cell)((Cell.Builder)Cell.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCells(Collection<Cell.BuilderImpl> cells) {
            this.cells = CellsCopier.copyFromBuilder(cells);
        }

        public TableRow build() {
            return new TableRow(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableRow> {
        public Builder rowId(String var1);

        public Builder cells(Collection<Cell> var1);

        public Builder cells(Cell ... var1);

        public Builder cells(Consumer<Cell.Builder> ... var1);
    }
}

