/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.honeycode.model.HoneycodeRequest;
import software.amazon.awssdk.services.honeycode.model.VariableValue;
import software.amazon.awssdk.services.honeycode.model.VariableValueMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetScreenDataRequest
extends HoneycodeRequest
implements ToCopyableBuilder<Builder, GetScreenDataRequest> {
    private static final SdkField<String> WORKBOOK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workbookId").getter(GetScreenDataRequest.getter(GetScreenDataRequest::workbookId)).setter(GetScreenDataRequest.setter(Builder::workbookId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workbookId").build()}).build();
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(GetScreenDataRequest.getter(GetScreenDataRequest::appId)).setter(GetScreenDataRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<String> SCREEN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("screenId").getter(GetScreenDataRequest.getter(GetScreenDataRequest::screenId)).setter(GetScreenDataRequest.setter(Builder::screenId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("screenId").build()}).build();
    private static final SdkField<Map<String, VariableValue>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("variables").getter(GetScreenDataRequest.getter(GetScreenDataRequest::variables)).setter(GetScreenDataRequest.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VariableValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetScreenDataRequest.getter(GetScreenDataRequest::maxResults)).setter(GetScreenDataRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetScreenDataRequest.getter(GetScreenDataRequest::nextToken)).setter(GetScreenDataRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKBOOK_ID_FIELD, APP_ID_FIELD, SCREEN_ID_FIELD, VARIABLES_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String workbookId;
    private final String appId;
    private final String screenId;
    private final Map<String, VariableValue> variables;
    private final Integer maxResults;
    private final String nextToken;

    private GetScreenDataRequest(BuilderImpl builder) {
        super(builder);
        this.workbookId = builder.workbookId;
        this.appId = builder.appId;
        this.screenId = builder.screenId;
        this.variables = builder.variables;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String workbookId() {
        return this.workbookId;
    }

    public final String appId() {
        return this.appId;
    }

    public final String screenId() {
        return this.screenId;
    }

    public final boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructMap);
    }

    public final Map<String, VariableValue> variables() {
        return this.variables;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workbookId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.screenId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariables() ? this.variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetScreenDataRequest)) {
            return false;
        }
        GetScreenDataRequest other = (GetScreenDataRequest)((Object)obj);
        return Objects.equals(this.workbookId(), other.workbookId()) && Objects.equals(this.appId(), other.appId()) && Objects.equals(this.screenId(), other.screenId()) && this.hasVariables() == other.hasVariables() && Objects.equals(this.variables(), other.variables()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetScreenDataRequest").add("WorkbookId", (Object)this.workbookId()).add("AppId", (Object)this.appId()).add("ScreenId", (Object)this.screenId()).add("Variables", (Object)(this.variables() == null ? null : "*** Sensitive Data Redacted ***")).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workbookId": {
                return Optional.ofNullable(clazz.cast(this.workbookId()));
            }
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "screenId": {
                return Optional.ofNullable(clazz.cast(this.screenId()));
            }
            case "variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetScreenDataRequest, T> g) {
        return obj -> g.apply((GetScreenDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HoneycodeRequest.BuilderImpl
    implements Builder {
        private String workbookId;
        private String appId;
        private String screenId;
        private Map<String, VariableValue> variables = DefaultSdkAutoConstructMap.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetScreenDataRequest model) {
            super(model);
            this.workbookId(model.workbookId);
            this.appId(model.appId);
            this.screenId(model.screenId);
            this.variables(model.variables);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getWorkbookId() {
            return this.workbookId;
        }

        @Override
        public final Builder workbookId(String workbookId) {
            this.workbookId = workbookId;
            return this;
        }

        public final void setWorkbookId(String workbookId) {
            this.workbookId = workbookId;
        }

        public final String getAppId() {
            return this.appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getScreenId() {
            return this.screenId;
        }

        @Override
        public final Builder screenId(String screenId) {
            this.screenId = screenId;
            return this;
        }

        public final void setScreenId(String screenId) {
            this.screenId = screenId;
        }

        public final Map<String, VariableValue.Builder> getVariables() {
            Map<String, VariableValue.Builder> result = VariableValueMapCopier.copyToBuilder(this.variables);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder variables(Map<String, VariableValue> variables) {
            this.variables = VariableValueMapCopier.copy(variables);
            return this;
        }

        public final void setVariables(Map<String, VariableValue.BuilderImpl> variables) {
            this.variables = VariableValueMapCopier.copyFromBuilder(variables);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetScreenDataRequest build() {
            return new GetScreenDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HoneycodeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetScreenDataRequest> {
        public Builder workbookId(String var1);

        public Builder appId(String var1);

        public Builder screenId(String var1);

        public Builder variables(Map<String, VariableValue> var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

