/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTableDataImportJobResponse extends HoneycodeResponse implements
        ToCopyableBuilder<DescribeTableDataImportJobResponse.Builder, DescribeTableDataImportJobResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobStatus").getter(getter(DescribeTableDataImportJobResponse::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobStatus").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(DescribeTableDataImportJobResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<TableDataImportJobMetadata> JOB_METADATA_FIELD = SdkField
            .<TableDataImportJobMetadata> builder(MarshallingType.SDK_POJO).memberName("jobMetadata")
            .getter(getter(DescribeTableDataImportJobResponse::jobMetadata)).setter(setter(Builder::jobMetadata))
            .constructor(TableDataImportJobMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD,
            MESSAGE_FIELD, JOB_METADATA_FIELD));

    private final String jobStatus;

    private final String message;

    private final TableDataImportJobMetadata jobMetadata;

    private DescribeTableDataImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.message = builder.message;
        this.jobMetadata = builder.jobMetadata;
    }

    /**
     * <p>
     * The current status of the import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link TableDataImportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the import job.
     * @see TableDataImportJobStatus
     */
    public final TableDataImportJobStatus jobStatus() {
        return TableDataImportJobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The current status of the import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link TableDataImportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the import job.
     * @see TableDataImportJobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * A message providing more details about the current status of the import job.
     * </p>
     * 
     * @return A message providing more details about the current status of the import job.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The metadata about the job that was submitted for import.
     * </p>
     * 
     * @return The metadata about the job that was submitted for import.
     */
    public final TableDataImportJobMetadata jobMetadata() {
        return jobMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(jobMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTableDataImportJobResponse)) {
            return false;
        }
        DescribeTableDataImportJobResponse other = (DescribeTableDataImportJobResponse) obj;
        return Objects.equals(jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(message(), other.message())
                && Objects.equals(jobMetadata(), other.jobMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTableDataImportJobResponse").add("JobStatus", jobStatusAsString())
                .add("Message", message()).add("JobMetadata", jobMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "jobMetadata":
            return Optional.ofNullable(clazz.cast(jobMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTableDataImportJobResponse, T> g) {
        return obj -> g.apply((DescribeTableDataImportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HoneycodeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTableDataImportJobResponse> {
        /**
         * <p>
         * The current status of the import job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the import job.
         * @see TableDataImportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableDataImportJobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The current status of the import job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the import job.
         * @see TableDataImportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableDataImportJobStatus
         */
        Builder jobStatus(TableDataImportJobStatus jobStatus);

        /**
         * <p>
         * A message providing more details about the current status of the import job.
         * </p>
         * 
         * @param message
         *        A message providing more details about the current status of the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The metadata about the job that was submitted for import.
         * </p>
         * 
         * @param jobMetadata
         *        The metadata about the job that was submitted for import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobMetadata(TableDataImportJobMetadata jobMetadata);

        /**
         * <p>
         * The metadata about the job that was submitted for import.
         * </p>
         * This is a convenience that creates an instance of the {@link TableDataImportJobMetadata.Builder} avoiding the
         * need to create one manually via {@link TableDataImportJobMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link TableDataImportJobMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #jobMetadata(TableDataImportJobMetadata)}.
         * 
         * @param jobMetadata
         *        a consumer that will call methods on {@link TableDataImportJobMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobMetadata(TableDataImportJobMetadata)
         */
        default Builder jobMetadata(Consumer<TableDataImportJobMetadata.Builder> jobMetadata) {
            return jobMetadata(TableDataImportJobMetadata.builder().applyMutation(jobMetadata).build());
        }
    }

    static final class BuilderImpl extends HoneycodeResponse.BuilderImpl implements Builder {
        private String jobStatus;

        private String message;

        private TableDataImportJobMetadata jobMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTableDataImportJobResponse model) {
            super(model);
            jobStatus(model.jobStatus);
            message(model.message);
            jobMetadata(model.jobMetadata);
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(TableDataImportJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final TableDataImportJobMetadata.Builder getJobMetadata() {
            return jobMetadata != null ? jobMetadata.toBuilder() : null;
        }

        @Override
        public final Builder jobMetadata(TableDataImportJobMetadata jobMetadata) {
            this.jobMetadata = jobMetadata;
            return this;
        }

        public final void setJobMetadata(TableDataImportJobMetadata.BuilderImpl jobMetadata) {
            this.jobMetadata = jobMetadata != null ? jobMetadata.build() : null;
        }

        @Override
        public DescribeTableDataImportJobResponse build() {
            return new DescribeTableDataImportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
