/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetScreenDataResponse extends HoneycodeResponse implements
        ToCopyableBuilder<GetScreenDataResponse.Builder, GetScreenDataResponse> {
    private static final SdkField<Map<String, ResultSet>> RESULTS_FIELD = SdkField
            .<Map<String, ResultSet>> builder(MarshallingType.MAP)
            .memberName("results")
            .getter(getter(GetScreenDataResponse::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("results").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ResultSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResultSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Long> WORKBOOK_CURSOR_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("workbookCursor").getter(getter(GetScreenDataResponse::workbookCursor))
            .setter(setter(Builder::workbookCursor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workbookCursor").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetScreenDataResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD,
            WORKBOOK_CURSOR_FIELD, NEXT_TOKEN_FIELD));

    private final Map<String, ResultSet> results;

    private final Long workbookCursor;

    private final String nextToken;

    private GetScreenDataResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.workbookCursor = builder.workbookCursor;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Results property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasResults() {
        return results != null && !(results instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of all the rows on the screen keyed by block name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResults()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of all the rows on the screen keyed by block name.
     */
    public final Map<String, ResultSet> results() {
        return results;
    }

    /**
     * <p>
     * Indicates the cursor of the workbook at which the data returned by this workbook is read. Workbook cursor keeps
     * increasing with every update and the increments are not sequential.
     * </p>
     * 
     * @return Indicates the cursor of the workbook at which the data returned by this workbook is read. Workbook cursor
     *         keeps increasing with every update and the increments are not sequential.
     */
    public final Long workbookCursor() {
        return workbookCursor;
    }

    /**
     * <p>
     * Provides the pagination token to load the next page if there are more results matching the request. If a
     * pagination token is not present in the response, it means that all data matching the query has been loaded.
     * </p>
     * 
     * @return Provides the pagination token to load the next page if there are more results matching the request. If a
     *         pagination token is not present in the response, it means that all data matching the query has been
     *         loaded.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResults() ? results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workbookCursor());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetScreenDataResponse)) {
            return false;
        }
        GetScreenDataResponse other = (GetScreenDataResponse) obj;
        return hasResults() == other.hasResults() && Objects.equals(results(), other.results())
                && Objects.equals(workbookCursor(), other.workbookCursor()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetScreenDataResponse")
                .add("Results", results() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WorkbookCursor", workbookCursor()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "results":
            return Optional.ofNullable(clazz.cast(results()));
        case "workbookCursor":
            return Optional.ofNullable(clazz.cast(workbookCursor()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetScreenDataResponse, T> g) {
        return obj -> g.apply((GetScreenDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HoneycodeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetScreenDataResponse> {
        /**
         * <p>
         * A map of all the rows on the screen keyed by block name.
         * </p>
         * 
         * @param results
         *        A map of all the rows on the screen keyed by block name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Map<String, ResultSet> results);

        /**
         * <p>
         * Indicates the cursor of the workbook at which the data returned by this workbook is read. Workbook cursor
         * keeps increasing with every update and the increments are not sequential.
         * </p>
         * 
         * @param workbookCursor
         *        Indicates the cursor of the workbook at which the data returned by this workbook is read. Workbook
         *        cursor keeps increasing with every update and the increments are not sequential.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workbookCursor(Long workbookCursor);

        /**
         * <p>
         * Provides the pagination token to load the next page if there are more results matching the request. If a
         * pagination token is not present in the response, it means that all data matching the query has been loaded.
         * </p>
         * 
         * @param nextToken
         *        Provides the pagination token to load the next page if there are more results matching the request. If
         *        a pagination token is not present in the response, it means that all data matching the query has been
         *        loaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends HoneycodeResponse.BuilderImpl implements Builder {
        private Map<String, ResultSet> results = DefaultSdkAutoConstructMap.getInstance();

        private Long workbookCursor;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetScreenDataResponse model) {
            super(model);
            results(model.results);
            workbookCursor(model.workbookCursor);
            nextToken(model.nextToken);
        }

        public final Map<String, ResultSet.Builder> getResults() {
            Map<String, ResultSet.Builder> result = ResultSetMapCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder results(Map<String, ResultSet> results) {
            this.results = ResultSetMapCopier.copy(results);
            return this;
        }

        public final void setResults(Map<String, ResultSet.BuilderImpl> results) {
            this.results = ResultSetMapCopier.copyFromBuilder(results);
        }

        public final Long getWorkbookCursor() {
            return workbookCursor;
        }

        @Override
        public final Builder workbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
            return this;
        }

        public final void setWorkbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetScreenDataResponse build() {
            return new GetScreenDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
