/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single row in the ResultSet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResultRow implements SdkPojo, Serializable, ToCopyableBuilder<ResultRow.Builder, ResultRow> {
    private static final SdkField<String> ROW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("rowId")
            .getter(getter(ResultRow::rowId)).setter(setter(Builder::rowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowId").build()).build();

    private static final SdkField<List<DataItem>> DATA_ITEMS_FIELD = SdkField
            .<List<DataItem>> builder(MarshallingType.LIST)
            .memberName("dataItems")
            .getter(getter(ResultRow::dataItems))
            .setter(setter(Builder::dataItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ROW_ID_FIELD, DATA_ITEMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String rowId;

    private final List<DataItem> dataItems;

    private ResultRow(BuilderImpl builder) {
        this.rowId = builder.rowId;
        this.dataItems = builder.dataItems;
    }

    /**
     * <p>
     * The ID for a particular row.
     * </p>
     * 
     * @return The ID for a particular row.
     */
    public final String rowId() {
        return rowId;
    }

    /**
     * Returns true if the DataItems property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDataItems() {
        return dataItems != null && !(dataItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of all the data cells in a row.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDataItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of all the data cells in a row.
     */
    public final List<DataItem> dataItems() {
        return dataItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rowId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataItems() ? dataItems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultRow)) {
            return false;
        }
        ResultRow other = (ResultRow) obj;
        return Objects.equals(rowId(), other.rowId()) && hasDataItems() == other.hasDataItems()
                && Objects.equals(dataItems(), other.dataItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResultRow").add("RowId", rowId())
                .add("DataItems", dataItems() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rowId":
            return Optional.ofNullable(clazz.cast(rowId()));
        case "dataItems":
            return Optional.ofNullable(clazz.cast(dataItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultRow, T> g) {
        return obj -> g.apply((ResultRow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResultRow> {
        /**
         * <p>
         * The ID for a particular row.
         * </p>
         * 
         * @param rowId
         *        The ID for a particular row.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowId(String rowId);

        /**
         * <p>
         * List of all the data cells in a row.
         * </p>
         * 
         * @param dataItems
         *        List of all the data cells in a row.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataItems(Collection<DataItem> dataItems);

        /**
         * <p>
         * List of all the data cells in a row.
         * </p>
         * 
         * @param dataItems
         *        List of all the data cells in a row.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataItems(DataItem... dataItems);

        /**
         * <p>
         * List of all the data cells in a row.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataItem>.Builder} avoiding the need to
         * create one manually via {@link List<DataItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataItem>.Builder#build()} is called immediately and its
         * result is passed to {@link #dataItems(List<DataItem>)}.
         * 
         * @param dataItems
         *        a consumer that will call methods on {@link List<DataItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataItems(List<DataItem>)
         */
        Builder dataItems(Consumer<DataItem.Builder>... dataItems);
    }

    static final class BuilderImpl implements Builder {
        private String rowId;

        private List<DataItem> dataItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResultRow model) {
            rowId(model.rowId);
            dataItems(model.dataItems);
        }

        public final String getRowId() {
            return rowId;
        }

        @Override
        public final Builder rowId(String rowId) {
            this.rowId = rowId;
            return this;
        }

        public final void setRowId(String rowId) {
            this.rowId = rowId;
        }

        public final List<DataItem.Builder> getDataItems() {
            List<DataItem.Builder> result = DataItemsCopier.copyToBuilder(this.dataItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder dataItems(Collection<DataItem> dataItems) {
            this.dataItems = DataItemsCopier.copy(dataItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataItems(DataItem... dataItems) {
            dataItems(Arrays.asList(dataItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataItems(Consumer<DataItem.Builder>... dataItems) {
            dataItems(Stream.of(dataItems).map(c -> DataItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDataItems(Collection<DataItem.BuilderImpl> dataItems) {
            this.dataItems = DataItemsCopier.copyFromBuilder(dataItems);
        }

        @Override
        public ResultRow build() {
            return new ResultRow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
