/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class RowDataInputCopier {
    static Map<String, CellInput> copy(Map<String, ? extends CellInput> rowDataInputParam) {
        Map<String, CellInput> map;
        if (rowDataInputParam == null || rowDataInputParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, CellInput> modifiableMap = new LinkedHashMap<>();
            rowDataInputParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, CellInput> copyFromBuilder(Map<String, ? extends CellInput.Builder> rowDataInputParam) {
        Map<String, CellInput> map;
        if (rowDataInputParam == null || rowDataInputParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, CellInput> modifiableMap = new LinkedHashMap<>();
            rowDataInputParam.forEach((key, value) -> {
                CellInput member = value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, CellInput.Builder> copyToBuilder(Map<String, ? extends CellInput> rowDataInputParam) {
        Map<String, CellInput.Builder> map;
        if (rowDataInputParam == null || rowDataInputParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, CellInput.Builder> modifiableMap = new LinkedHashMap<>();
            rowDataInputParam.forEach((key, value) -> {
                CellInput.Builder member = value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
