/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.honeycode.model.CellInput;
import software.amazon.awssdk.services.honeycode.model.Filter;
import software.amazon.awssdk.services.honeycode.model.RowDataInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpsertRowData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpsertRowData> {
    private static final SdkField<String> BATCH_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("batchItemId").getter(UpsertRowData.getter(UpsertRowData::batchItemId)).setter(UpsertRowData.setter(Builder::batchItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchItemId").build()}).build();
    private static final SdkField<Filter> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filter").getter(UpsertRowData.getter(UpsertRowData::filter)).setter(UpsertRowData.setter(Builder::filter)).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()}).build();
    private static final SdkField<Map<String, CellInput>> CELLS_TO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("cellsToUpdate").getter(UpsertRowData.getter(UpsertRowData::cellsToUpdate)).setter(UpsertRowData.setter(Builder::cellsToUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cellsToUpdate").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CellInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_ITEM_ID_FIELD, FILTER_FIELD, CELLS_TO_UPDATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String batchItemId;
    private final Filter filter;
    private final Map<String, CellInput> cellsToUpdate;

    private UpsertRowData(BuilderImpl builder) {
        this.batchItemId = builder.batchItemId;
        this.filter = builder.filter;
        this.cellsToUpdate = builder.cellsToUpdate;
    }

    public final String batchItemId() {
        return this.batchItemId;
    }

    public final Filter filter() {
        return this.filter;
    }

    public final boolean hasCellsToUpdate() {
        return this.cellsToUpdate != null && !(this.cellsToUpdate instanceof SdkAutoConstructMap);
    }

    public final Map<String, CellInput> cellsToUpdate() {
        return this.cellsToUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.batchItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCellsToUpdate() ? this.cellsToUpdate() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpsertRowData)) {
            return false;
        }
        UpsertRowData other = (UpsertRowData)obj;
        return Objects.equals(this.batchItemId(), other.batchItemId()) && Objects.equals(this.filter(), other.filter()) && this.hasCellsToUpdate() == other.hasCellsToUpdate() && Objects.equals(this.cellsToUpdate(), other.cellsToUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"UpsertRowData").add("BatchItemId", (Object)this.batchItemId()).add("Filter", (Object)this.filter()).add("CellsToUpdate", this.hasCellsToUpdate() ? this.cellsToUpdate() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "batchItemId": {
                return Optional.ofNullable(clazz.cast(this.batchItemId()));
            }
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "cellsToUpdate": {
                return Optional.ofNullable(clazz.cast(this.cellsToUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpsertRowData, T> g) {
        return obj -> g.apply((UpsertRowData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String batchItemId;
        private Filter filter;
        private Map<String, CellInput> cellsToUpdate = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpsertRowData model) {
            this.batchItemId(model.batchItemId);
            this.filter(model.filter);
            this.cellsToUpdate(model.cellsToUpdate);
        }

        public final String getBatchItemId() {
            return this.batchItemId;
        }

        @Override
        public final Builder batchItemId(String batchItemId) {
            this.batchItemId = batchItemId;
            return this;
        }

        public final void setBatchItemId(String batchItemId) {
            this.batchItemId = batchItemId;
        }

        public final Filter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(Filter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        public final Map<String, CellInput.Builder> getCellsToUpdate() {
            Map<String, CellInput.Builder> result = RowDataInputCopier.copyToBuilder(this.cellsToUpdate);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder cellsToUpdate(Map<String, CellInput> cellsToUpdate) {
            this.cellsToUpdate = RowDataInputCopier.copy(cellsToUpdate);
            return this;
        }

        public final void setCellsToUpdate(Map<String, CellInput.BuilderImpl> cellsToUpdate) {
            this.cellsToUpdate = RowDataInputCopier.copyFromBuilder(cellsToUpdate);
        }

        public UpsertRowData build() {
            return new UpsertRowData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpsertRowData> {
        public Builder batchItemId(String var1);

        public Builder filter(Filter var1);

        default public Builder filter(Consumer<Filter.Builder> filter) {
            return this.filter((Filter)((Filter.Builder)Filter.builder().applyMutation(filter)).build());
        }

        public Builder cellsToUpdate(Map<String, CellInput> var1);
    }
}

