/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateTableRowsResponse extends HoneycodeResponse implements
        ToCopyableBuilder<BatchCreateTableRowsResponse.Builder, BatchCreateTableRowsResponse> {
    private static final SdkField<Long> WORKBOOK_CURSOR_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("workbookCursor").getter(getter(BatchCreateTableRowsResponse::workbookCursor))
            .setter(setter(Builder::workbookCursor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workbookCursor").build()).build();

    private static final SdkField<Map<String, String>> CREATED_ROWS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("createdRows")
            .getter(getter(BatchCreateTableRowsResponse::createdRows))
            .setter(setter(Builder::createdRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdRows").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<FailedBatchItem>> FAILED_BATCH_ITEMS_FIELD = SdkField
            .<List<FailedBatchItem>> builder(MarshallingType.LIST)
            .memberName("failedBatchItems")
            .getter(getter(BatchCreateTableRowsResponse::failedBatchItems))
            .setter(setter(Builder::failedBatchItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedBatchItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedBatchItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedBatchItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKBOOK_CURSOR_FIELD,
            CREATED_ROWS_FIELD, FAILED_BATCH_ITEMS_FIELD));

    private final Long workbookCursor;

    private final Map<String, String> createdRows;

    private final List<FailedBatchItem> failedBatchItems;

    private BatchCreateTableRowsResponse(BuilderImpl builder) {
        super(builder);
        this.workbookCursor = builder.workbookCursor;
        this.createdRows = builder.createdRows;
        this.failedBatchItems = builder.failedBatchItems;
    }

    /**
     * <p>
     * The updated workbook cursor after adding the new rows at the end of the table.
     * </p>
     * 
     * @return The updated workbook cursor after adding the new rows at the end of the table.
     */
    public final Long workbookCursor() {
        return workbookCursor;
    }

    /**
     * Returns true if the CreatedRows property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCreatedRows() {
        return createdRows != null && !(createdRows instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The map of batch item id to the row id that was created for that item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCreatedRows()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The map of batch item id to the row id that was created for that item.
     */
    public final Map<String, String> createdRows() {
        return createdRows;
    }

    /**
     * Returns true if the FailedBatchItems property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasFailedBatchItems() {
        return failedBatchItems != null && !(failedBatchItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of batch items in the request that could not be added to the table. Each element in this list contains
     * one item from the request that could not be added to the table along with the reason why that item could not be
     * added.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailedBatchItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of batch items in the request that could not be added to the table. Each element in this list
     *         contains one item from the request that could not be added to the table along with the reason why that
     *         item could not be added.
     */
    public final List<FailedBatchItem> failedBatchItems() {
        return failedBatchItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workbookCursor());
        hashCode = 31 * hashCode + Objects.hashCode(hasCreatedRows() ? createdRows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedBatchItems() ? failedBatchItems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateTableRowsResponse)) {
            return false;
        }
        BatchCreateTableRowsResponse other = (BatchCreateTableRowsResponse) obj;
        return Objects.equals(workbookCursor(), other.workbookCursor()) && hasCreatedRows() == other.hasCreatedRows()
                && Objects.equals(createdRows(), other.createdRows()) && hasFailedBatchItems() == other.hasFailedBatchItems()
                && Objects.equals(failedBatchItems(), other.failedBatchItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateTableRowsResponse").add("WorkbookCursor", workbookCursor())
                .add("CreatedRows", hasCreatedRows() ? createdRows() : null)
                .add("FailedBatchItems", hasFailedBatchItems() ? failedBatchItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workbookCursor":
            return Optional.ofNullable(clazz.cast(workbookCursor()));
        case "createdRows":
            return Optional.ofNullable(clazz.cast(createdRows()));
        case "failedBatchItems":
            return Optional.ofNullable(clazz.cast(failedBatchItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateTableRowsResponse, T> g) {
        return obj -> g.apply((BatchCreateTableRowsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HoneycodeResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchCreateTableRowsResponse> {
        /**
         * <p>
         * The updated workbook cursor after adding the new rows at the end of the table.
         * </p>
         * 
         * @param workbookCursor
         *        The updated workbook cursor after adding the new rows at the end of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workbookCursor(Long workbookCursor);

        /**
         * <p>
         * The map of batch item id to the row id that was created for that item.
         * </p>
         * 
         * @param createdRows
         *        The map of batch item id to the row id that was created for that item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdRows(Map<String, String> createdRows);

        /**
         * <p>
         * The list of batch items in the request that could not be added to the table. Each element in this list
         * contains one item from the request that could not be added to the table along with the reason why that item
         * could not be added.
         * </p>
         * 
         * @param failedBatchItems
         *        The list of batch items in the request that could not be added to the table. Each element in this list
         *        contains one item from the request that could not be added to the table along with the reason why that
         *        item could not be added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedBatchItems(Collection<FailedBatchItem> failedBatchItems);

        /**
         * <p>
         * The list of batch items in the request that could not be added to the table. Each element in this list
         * contains one item from the request that could not be added to the table along with the reason why that item
         * could not be added.
         * </p>
         * 
         * @param failedBatchItems
         *        The list of batch items in the request that could not be added to the table. Each element in this list
         *        contains one item from the request that could not be added to the table along with the reason why that
         *        item could not be added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedBatchItems(FailedBatchItem... failedBatchItems);

        /**
         * <p>
         * The list of batch items in the request that could not be added to the table. Each element in this list
         * contains one item from the request that could not be added to the table along with the reason why that item
         * could not be added.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FailedBatchItem>.Builder} avoiding the need
         * to create one manually via {@link List<FailedBatchItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FailedBatchItem>.Builder#build()} is called immediately and
         * its result is passed to {@link #failedBatchItems(List<FailedBatchItem>)}.
         * 
         * @param failedBatchItems
         *        a consumer that will call methods on {@link List<FailedBatchItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedBatchItems(List<FailedBatchItem>)
         */
        Builder failedBatchItems(Consumer<FailedBatchItem.Builder>... failedBatchItems);
    }

    static final class BuilderImpl extends HoneycodeResponse.BuilderImpl implements Builder {
        private Long workbookCursor;

        private Map<String, String> createdRows = DefaultSdkAutoConstructMap.getInstance();

        private List<FailedBatchItem> failedBatchItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateTableRowsResponse model) {
            super(model);
            workbookCursor(model.workbookCursor);
            createdRows(model.createdRows);
            failedBatchItems(model.failedBatchItems);
        }

        public final Long getWorkbookCursor() {
            return workbookCursor;
        }

        @Override
        public final Builder workbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
            return this;
        }

        public final void setWorkbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
        }

        public final Map<String, String> getCreatedRows() {
            if (createdRows instanceof SdkAutoConstructMap) {
                return null;
            }
            return createdRows;
        }

        @Override
        public final Builder createdRows(Map<String, String> createdRows) {
            this.createdRows = CreatedRowsMapCopier.copy(createdRows);
            return this;
        }

        public final void setCreatedRows(Map<String, String> createdRows) {
            this.createdRows = CreatedRowsMapCopier.copy(createdRows);
        }

        public final List<FailedBatchItem.Builder> getFailedBatchItems() {
            List<FailedBatchItem.Builder> result = FailedBatchItemsCopier.copyToBuilder(this.failedBatchItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder failedBatchItems(Collection<FailedBatchItem> failedBatchItems) {
            this.failedBatchItems = FailedBatchItemsCopier.copy(failedBatchItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedBatchItems(FailedBatchItem... failedBatchItems) {
            failedBatchItems(Arrays.asList(failedBatchItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedBatchItems(Consumer<FailedBatchItem.Builder>... failedBatchItems) {
            failedBatchItems(Stream.of(failedBatchItems).map(c -> FailedBatchItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFailedBatchItems(Collection<FailedBatchItem.BuilderImpl> failedBatchItems) {
            this.failedBatchItems = FailedBatchItemsCopier.copyFromBuilder(failedBatchItems);
        }

        @Override
        public BatchCreateTableRowsResponse build() {
            return new BatchCreateTableRowsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
