/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CellInput object contains the data needed to create or update cells in a table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CellInput implements SdkPojo, Serializable, ToCopyableBuilder<CellInput.Builder, CellInput> {
    private static final SdkField<String> FACT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("fact")
            .getter(getter(CellInput::fact)).setter(setter(Builder::fact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fact").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fact;

    private CellInput(BuilderImpl builder) {
        this.fact = builder.fact;
    }

    /**
     * <p>
     * Fact represents the data that is entered into a cell. This data can be free text or a formula. Formulas need to
     * start with the equals (=) sign.
     * </p>
     * 
     * @return Fact represents the data that is entered into a cell. This data can be free text or a formula. Formulas
     *         need to start with the equals (=) sign.
     */
    public final String fact() {
        return fact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fact());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CellInput)) {
            return false;
        }
        CellInput other = (CellInput) obj;
        return Objects.equals(fact(), other.fact());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CellInput").add("Fact", fact() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fact":
            return Optional.ofNullable(clazz.cast(fact()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CellInput, T> g) {
        return obj -> g.apply((CellInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CellInput> {
        /**
         * <p>
         * Fact represents the data that is entered into a cell. This data can be free text or a formula. Formulas need
         * to start with the equals (=) sign.
         * </p>
         * 
         * @param fact
         *        Fact represents the data that is entered into a cell. This data can be free text or a formula.
         *        Formulas need to start with the equals (=) sign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fact(String fact);
    }

    static final class BuilderImpl implements Builder {
        private String fact;

        private BuilderImpl() {
        }

        private BuilderImpl(CellInput model) {
            fact(model.fact);
        }

        public final String getFact() {
            return fact;
        }

        @Override
        public final Builder fact(String fact) {
            this.fact = fact;
            return this;
        }

        public final void setFact(String fact) {
            this.fact = fact;
        }

        @Override
        public CellInput build() {
            return new CellInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
