/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains the properties for importing data to a specific column in a table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceDataColumnProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceDataColumnProperties.Builder, SourceDataColumnProperties> {
    private static final SdkField<Integer> COLUMN_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("columnIndex").getter(getter(SourceDataColumnProperties::columnIndex))
            .setter(setter(Builder::columnIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnIndex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_INDEX_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer columnIndex;

    private SourceDataColumnProperties(BuilderImpl builder) {
        this.columnIndex = builder.columnIndex;
    }

    /**
     * <p>
     * The index of the column in the input file.
     * </p>
     * 
     * @return The index of the column in the input file.
     */
    public final Integer columnIndex() {
        return columnIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceDataColumnProperties)) {
            return false;
        }
        SourceDataColumnProperties other = (SourceDataColumnProperties) obj;
        return Objects.equals(columnIndex(), other.columnIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceDataColumnProperties").add("ColumnIndex", columnIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "columnIndex":
            return Optional.ofNullable(clazz.cast(columnIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceDataColumnProperties, T> g) {
        return obj -> g.apply((SourceDataColumnProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceDataColumnProperties> {
        /**
         * <p>
         * The index of the column in the input file.
         * </p>
         * 
         * @param columnIndex
         *        The index of the column in the input file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnIndex(Integer columnIndex);
    }

    static final class BuilderImpl implements Builder {
        private Integer columnIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceDataColumnProperties model) {
            columnIndex(model.columnIndex);
        }

        public final Integer getColumnIndex() {
            return columnIndex;
        }

        @Override
        public final Builder columnIndex(Integer columnIndex) {
            this.columnIndex = columnIndex;
            return this;
        }

        public final void setColumnIndex(Integer columnIndex) {
            this.columnIndex = columnIndex;
        }

        @Override
        public SourceDataColumnProperties build() {
            return new SourceDataColumnProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
