/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTableDataImportJobResponse extends HoneycodeResponse implements
        ToCopyableBuilder<StartTableDataImportJobResponse.Builder, StartTableDataImportJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(StartTableDataImportJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobStatus").getter(getter(StartTableDataImportJobResponse::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(JOB_ID_FIELD, JOB_STATUS_FIELD));

    private final String jobId;

    private final String jobStatus;

    private StartTableDataImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.jobStatus = builder.jobStatus;
    }

    /**
     * <p>
     * The id that is assigned to this import job. Future requests to find out the status of this import job need to
     * send this id in the appropriate parameter in the request.
     * </p>
     * 
     * @return The id that is assigned to this import job. Future requests to find out the status of this import job
     *         need to send this id in the appropriate parameter in the request.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The status of the import job immediately after submitting the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link TableDataImportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the import job immediately after submitting the request.
     * @see TableDataImportJobStatus
     */
    public final TableDataImportJobStatus jobStatus() {
        return TableDataImportJobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The status of the import job immediately after submitting the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link TableDataImportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the import job immediately after submitting the request.
     * @see TableDataImportJobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTableDataImportJobResponse)) {
            return false;
        }
        StartTableDataImportJobResponse other = (StartTableDataImportJobResponse) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(jobStatusAsString(), other.jobStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartTableDataImportJobResponse").add("JobId", jobId()).add("JobStatus", jobStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "jobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTableDataImportJobResponse, T> g) {
        return obj -> g.apply((StartTableDataImportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HoneycodeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartTableDataImportJobResponse> {
        /**
         * <p>
         * The id that is assigned to this import job. Future requests to find out the status of this import job need to
         * send this id in the appropriate parameter in the request.
         * </p>
         * 
         * @param jobId
         *        The id that is assigned to this import job. Future requests to find out the status of this import job
         *        need to send this id in the appropriate parameter in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The status of the import job immediately after submitting the request.
         * </p>
         * 
         * @param jobStatus
         *        The status of the import job immediately after submitting the request.
         * @see TableDataImportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableDataImportJobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The status of the import job immediately after submitting the request.
         * </p>
         * 
         * @param jobStatus
         *        The status of the import job immediately after submitting the request.
         * @see TableDataImportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableDataImportJobStatus
         */
        Builder jobStatus(TableDataImportJobStatus jobStatus);
    }

    static final class BuilderImpl extends HoneycodeResponse.BuilderImpl implements Builder {
        private String jobId;

        private String jobStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTableDataImportJobResponse model) {
            super(model);
            jobId(model.jobId);
            jobStatus(model.jobStatus);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(TableDataImportJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public StartTableDataImportJobResponse build() {
            return new StartTableDataImportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
