/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.honeycode.model.HoneycodeRequest;
import software.amazon.awssdk.services.honeycode.model.RowIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteTableRowsRequest
extends HoneycodeRequest
implements ToCopyableBuilder<Builder, BatchDeleteTableRowsRequest> {
    private static final SdkField<String> WORKBOOK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workbookId").getter(BatchDeleteTableRowsRequest.getter(BatchDeleteTableRowsRequest::workbookId)).setter(BatchDeleteTableRowsRequest.setter(Builder::workbookId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workbookId").build()}).build();
    private static final SdkField<String> TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableId").getter(BatchDeleteTableRowsRequest.getter(BatchDeleteTableRowsRequest::tableId)).setter(BatchDeleteTableRowsRequest.setter(Builder::tableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableId").build()}).build();
    private static final SdkField<List<String>> ROW_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rowIds").getter(BatchDeleteTableRowsRequest.getter(BatchDeleteTableRowsRequest::rowIds)).setter(BatchDeleteTableRowsRequest.setter(Builder::rowIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(BatchDeleteTableRowsRequest.getter(BatchDeleteTableRowsRequest::clientRequestToken)).setter(BatchDeleteTableRowsRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKBOOK_ID_FIELD, TABLE_ID_FIELD, ROW_IDS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String workbookId;
    private final String tableId;
    private final List<String> rowIds;
    private final String clientRequestToken;

    private BatchDeleteTableRowsRequest(BuilderImpl builder) {
        super(builder);
        this.workbookId = builder.workbookId;
        this.tableId = builder.tableId;
        this.rowIds = builder.rowIds;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String workbookId() {
        return this.workbookId;
    }

    public final String tableId() {
        return this.tableId;
    }

    public final boolean hasRowIds() {
        return this.rowIds != null && !(this.rowIds instanceof SdkAutoConstructList);
    }

    public final List<String> rowIds() {
        return this.rowIds;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workbookId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRowIds() ? this.rowIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteTableRowsRequest)) {
            return false;
        }
        BatchDeleteTableRowsRequest other = (BatchDeleteTableRowsRequest)((Object)obj);
        return Objects.equals(this.workbookId(), other.workbookId()) && Objects.equals(this.tableId(), other.tableId()) && this.hasRowIds() == other.hasRowIds() && Objects.equals(this.rowIds(), other.rowIds()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteTableRowsRequest").add("WorkbookId", (Object)this.workbookId()).add("TableId", (Object)this.tableId()).add("RowIds", this.hasRowIds() ? this.rowIds() : null).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workbookId": {
                return Optional.ofNullable(clazz.cast(this.workbookId()));
            }
            case "tableId": {
                return Optional.ofNullable(clazz.cast(this.tableId()));
            }
            case "rowIds": {
                return Optional.ofNullable(clazz.cast(this.rowIds()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteTableRowsRequest, T> g) {
        return obj -> g.apply((BatchDeleteTableRowsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HoneycodeRequest.BuilderImpl
    implements Builder {
        private String workbookId;
        private String tableId;
        private List<String> rowIds = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteTableRowsRequest model) {
            super(model);
            this.workbookId(model.workbookId);
            this.tableId(model.tableId);
            this.rowIds(model.rowIds);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getWorkbookId() {
            return this.workbookId;
        }

        @Override
        public final Builder workbookId(String workbookId) {
            this.workbookId = workbookId;
            return this;
        }

        public final void setWorkbookId(String workbookId) {
            this.workbookId = workbookId;
        }

        public final String getTableId() {
            return this.tableId;
        }

        @Override
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        public final Collection<String> getRowIds() {
            if (this.rowIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rowIds;
        }

        @Override
        public final Builder rowIds(Collection<String> rowIds) {
            this.rowIds = RowIdListCopier.copy(rowIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowIds(String ... rowIds) {
            this.rowIds(Arrays.asList(rowIds));
            return this;
        }

        public final void setRowIds(Collection<String> rowIds) {
            this.rowIds = RowIdListCopier.copy(rowIds);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteTableRowsRequest build() {
            return new BatchDeleteTableRowsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HoneycodeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteTableRowsRequest> {
        public Builder workbookId(String var1);

        public Builder tableId(String var1);

        public Builder rowIds(Collection<String> var1);

        public Builder rowIds(String ... var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

