/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.honeycode.model.HoneycodeResponse;
import software.amazon.awssdk.services.honeycode.model.TableDataImportJobMetadata;
import software.amazon.awssdk.services.honeycode.model.TableDataImportJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTableDataImportJobResponse
extends HoneycodeResponse
implements ToCopyableBuilder<Builder, DescribeTableDataImportJobResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobStatus").getter(DescribeTableDataImportJobResponse.getter(DescribeTableDataImportJobResponse::jobStatusAsString)).setter(DescribeTableDataImportJobResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobStatus").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(DescribeTableDataImportJobResponse.getter(DescribeTableDataImportJobResponse::message)).setter(DescribeTableDataImportJobResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<TableDataImportJobMetadata> JOB_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobMetadata").getter(DescribeTableDataImportJobResponse.getter(DescribeTableDataImportJobResponse::jobMetadata)).setter(DescribeTableDataImportJobResponse.setter(Builder::jobMetadata)).constructor(TableDataImportJobMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD, MESSAGE_FIELD, JOB_METADATA_FIELD));
    private final String jobStatus;
    private final String message;
    private final TableDataImportJobMetadata jobMetadata;

    private DescribeTableDataImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.message = builder.message;
        this.jobMetadata = builder.jobMetadata;
    }

    public final TableDataImportJobStatus jobStatus() {
        return TableDataImportJobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final String message() {
        return this.message;
    }

    public final TableDataImportJobMetadata jobMetadata() {
        return this.jobMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTableDataImportJobResponse)) {
            return false;
        }
        DescribeTableDataImportJobResponse other = (DescribeTableDataImportJobResponse)((Object)obj);
        return Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.jobMetadata(), other.jobMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTableDataImportJobResponse").add("JobStatus", (Object)this.jobStatusAsString()).add("Message", (Object)this.message()).add("JobMetadata", (Object)this.jobMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "jobMetadata": {
                return Optional.ofNullable(clazz.cast(this.jobMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTableDataImportJobResponse, T> g) {
        return obj -> g.apply((DescribeTableDataImportJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HoneycodeResponse.BuilderImpl
    implements Builder {
        private String jobStatus;
        private String message;
        private TableDataImportJobMetadata jobMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTableDataImportJobResponse model) {
            super(model);
            this.jobStatus(model.jobStatus);
            this.message(model.message);
            this.jobMetadata(model.jobMetadata);
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(TableDataImportJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final TableDataImportJobMetadata.Builder getJobMetadata() {
            return this.jobMetadata != null ? this.jobMetadata.toBuilder() : null;
        }

        @Override
        public final Builder jobMetadata(TableDataImportJobMetadata jobMetadata) {
            this.jobMetadata = jobMetadata;
            return this;
        }

        public final void setJobMetadata(TableDataImportJobMetadata.BuilderImpl jobMetadata) {
            this.jobMetadata = jobMetadata != null ? jobMetadata.build() : null;
        }

        @Override
        public DescribeTableDataImportJobResponse build() {
            return new DescribeTableDataImportJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HoneycodeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTableDataImportJobResponse> {
        public Builder jobStatus(String var1);

        public Builder jobStatus(TableDataImportJobStatus var1);

        public Builder message(String var1);

        public Builder jobMetadata(TableDataImportJobMetadata var1);

        default public Builder jobMetadata(Consumer<TableDataImportJobMetadata.Builder> jobMetadata) {
            return this.jobMetadata((TableDataImportJobMetadata)((TableDataImportJobMetadata.Builder)TableDataImportJobMetadata.builder().applyMutation(jobMetadata)).build());
        }
    }
}

