/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpsertTableRowsRequest extends HoneycodeRequest implements
        ToCopyableBuilder<BatchUpsertTableRowsRequest.Builder, BatchUpsertTableRowsRequest> {
    private static final SdkField<String> WORKBOOK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workbookId").getter(getter(BatchUpsertTableRowsRequest::workbookId)).setter(setter(Builder::workbookId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workbookId").build()).build();

    private static final SdkField<String> TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableId").getter(getter(BatchUpsertTableRowsRequest::tableId)).setter(setter(Builder::tableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableId").build()).build();

    private static final SdkField<List<UpsertRowData>> ROWS_TO_UPSERT_FIELD = SdkField
            .<List<UpsertRowData>> builder(MarshallingType.LIST)
            .memberName("rowsToUpsert")
            .getter(getter(BatchUpsertTableRowsRequest::rowsToUpsert))
            .setter(setter(Builder::rowsToUpsert))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowsToUpsert").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpsertRowData> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpsertRowData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken").getter(getter(BatchUpsertTableRowsRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKBOOK_ID_FIELD,
            TABLE_ID_FIELD, ROWS_TO_UPSERT_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String workbookId;

    private final String tableId;

    private final List<UpsertRowData> rowsToUpsert;

    private final String clientRequestToken;

    private BatchUpsertTableRowsRequest(BuilderImpl builder) {
        super(builder);
        this.workbookId = builder.workbookId;
        this.tableId = builder.tableId;
        this.rowsToUpsert = builder.rowsToUpsert;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The ID of the workbook where the rows are being upserted.
     * </p>
     * <p>
     * If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
     * </p>
     * 
     * @return The ID of the workbook where the rows are being upserted.</p>
     *         <p>
     *         If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
     */
    public final String workbookId() {
        return workbookId;
    }

    /**
     * <p>
     * The ID of the table where the rows are being upserted.
     * </p>
     * <p>
     * If a table with the specified id could not be found, this API throws ResourceNotFoundException.
     * </p>
     * 
     * @return The ID of the table where the rows are being upserted.</p>
     *         <p>
     *         If a table with the specified id could not be found, this API throws ResourceNotFoundException.
     */
    public final String tableId() {
        return tableId;
    }

    /**
     * For responses, this returns true if the service returned a value for the RowsToUpsert property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRowsToUpsert() {
        return rowsToUpsert != null && !(rowsToUpsert instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of rows to upsert in the table. Each item in this list needs to have a batch item id to uniquely
     * identify the element in the request, a filter expression to find the rows to update for that element and the cell
     * values to set for each column in the upserted rows. You need to specify at least one item in this list.
     * </p>
     * <p>
     * Note that if one of the filter formulas in the request fails to evaluate because of an error or one of the column
     * ids in any of the rows does not exist in the table, then the request fails and no updates are made to the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRowsToUpsert} method.
     * </p>
     * 
     * @return The list of rows to upsert in the table. Each item in this list needs to have a batch item id to uniquely
     *         identify the element in the request, a filter expression to find the rows to update for that element and
     *         the cell values to set for each column in the upserted rows. You need to specify at least one item in
     *         this list. </p>
     *         <p>
     *         Note that if one of the filter formulas in the request fails to evaluate because of an error or one of
     *         the column ids in any of the rows does not exist in the table, then the request fails and no updates are
     *         made to the table.
     */
    public final List<UpsertRowData> rowsToUpsert() {
        return rowsToUpsert;
    }

    /**
     * <p>
     * The request token for performing the update action. Request tokens help to identify duplicate requests. If a call
     * times out or fails due to a transient error like a failed network connection, you can retry the call with the
     * same request token. The service ensures that if the first call using that request token is successfully
     * performed, the second call will not perform the action again.
     * </p>
     * <p>
     * Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests
     * spanning hours or days.
     * </p>
     * 
     * @return The request token for performing the update action. Request tokens help to identify duplicate requests.
     *         If a call times out or fails due to a transient error like a failed network connection, you can retry the
     *         call with the same request token. The service ensures that if the first call using that request token is
     *         successfully performed, the second call will not perform the action again. </p>
     *         <p>
     *         Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe
     *         requests spanning hours or days.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workbookId());
        hashCode = 31 * hashCode + Objects.hashCode(tableId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRowsToUpsert() ? rowsToUpsert() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpsertTableRowsRequest)) {
            return false;
        }
        BatchUpsertTableRowsRequest other = (BatchUpsertTableRowsRequest) obj;
        return Objects.equals(workbookId(), other.workbookId()) && Objects.equals(tableId(), other.tableId())
                && hasRowsToUpsert() == other.hasRowsToUpsert() && Objects.equals(rowsToUpsert(), other.rowsToUpsert())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpsertTableRowsRequest").add("WorkbookId", workbookId()).add("TableId", tableId())
                .add("RowsToUpsert", hasRowsToUpsert() ? rowsToUpsert() : null).add("ClientRequestToken", clientRequestToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workbookId":
            return Optional.ofNullable(clazz.cast(workbookId()));
        case "tableId":
            return Optional.ofNullable(clazz.cast(tableId()));
        case "rowsToUpsert":
            return Optional.ofNullable(clazz.cast(rowsToUpsert()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpsertTableRowsRequest, T> g) {
        return obj -> g.apply((BatchUpsertTableRowsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HoneycodeRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchUpsertTableRowsRequest> {
        /**
         * <p>
         * The ID of the workbook where the rows are being upserted.
         * </p>
         * <p>
         * If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
         * </p>
         * 
         * @param workbookId
         *        The ID of the workbook where the rows are being upserted.</p>
         *        <p>
         *        If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workbookId(String workbookId);

        /**
         * <p>
         * The ID of the table where the rows are being upserted.
         * </p>
         * <p>
         * If a table with the specified id could not be found, this API throws ResourceNotFoundException.
         * </p>
         * 
         * @param tableId
         *        The ID of the table where the rows are being upserted.</p>
         *        <p>
         *        If a table with the specified id could not be found, this API throws ResourceNotFoundException.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableId(String tableId);

        /**
         * <p>
         * The list of rows to upsert in the table. Each item in this list needs to have a batch item id to uniquely
         * identify the element in the request, a filter expression to find the rows to update for that element and the
         * cell values to set for each column in the upserted rows. You need to specify at least one item in this list.
         * </p>
         * <p>
         * Note that if one of the filter formulas in the request fails to evaluate because of an error or one of the
         * column ids in any of the rows does not exist in the table, then the request fails and no updates are made to
         * the table.
         * </p>
         * 
         * @param rowsToUpsert
         *        The list of rows to upsert in the table. Each item in this list needs to have a batch item id to
         *        uniquely identify the element in the request, a filter expression to find the rows to update for that
         *        element and the cell values to set for each column in the upserted rows. You need to specify at least
         *        one item in this list. </p>
         *        <p>
         *        Note that if one of the filter formulas in the request fails to evaluate because of an error or one of
         *        the column ids in any of the rows does not exist in the table, then the request fails and no updates
         *        are made to the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowsToUpsert(Collection<UpsertRowData> rowsToUpsert);

        /**
         * <p>
         * The list of rows to upsert in the table. Each item in this list needs to have a batch item id to uniquely
         * identify the element in the request, a filter expression to find the rows to update for that element and the
         * cell values to set for each column in the upserted rows. You need to specify at least one item in this list.
         * </p>
         * <p>
         * Note that if one of the filter formulas in the request fails to evaluate because of an error or one of the
         * column ids in any of the rows does not exist in the table, then the request fails and no updates are made to
         * the table.
         * </p>
         * 
         * @param rowsToUpsert
         *        The list of rows to upsert in the table. Each item in this list needs to have a batch item id to
         *        uniquely identify the element in the request, a filter expression to find the rows to update for that
         *        element and the cell values to set for each column in the upserted rows. You need to specify at least
         *        one item in this list. </p>
         *        <p>
         *        Note that if one of the filter formulas in the request fails to evaluate because of an error or one of
         *        the column ids in any of the rows does not exist in the table, then the request fails and no updates
         *        are made to the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowsToUpsert(UpsertRowData... rowsToUpsert);

        /**
         * <p>
         * The list of rows to upsert in the table. Each item in this list needs to have a batch item id to uniquely
         * identify the element in the request, a filter expression to find the rows to update for that element and the
         * cell values to set for each column in the upserted rows. You need to specify at least one item in this list.
         * </p>
         * <p>
         * Note that if one of the filter formulas in the request fails to evaluate because of an error or one of the
         * column ids in any of the rows does not exist in the table, then the request fails and no updates are made to
         * the table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UpsertRowData>.Builder} avoiding the need
         * to create one manually via {@link List<UpsertRowData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UpsertRowData>.Builder#build()} is called immediately and
         * its result is passed to {@link #rowsToUpsert(List<UpsertRowData>)}.
         * 
         * @param rowsToUpsert
         *        a consumer that will call methods on {@link List<UpsertRowData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowsToUpsert(List<UpsertRowData>)
         */
        Builder rowsToUpsert(Consumer<UpsertRowData.Builder>... rowsToUpsert);

        /**
         * <p>
         * The request token for performing the update action. Request tokens help to identify duplicate requests. If a
         * call times out or fails due to a transient error like a failed network connection, you can retry the call
         * with the same request token. The service ensures that if the first call using that request token is
         * successfully performed, the second call will not perform the action again.
         * </p>
         * <p>
         * Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests
         * spanning hours or days.
         * </p>
         * 
         * @param clientRequestToken
         *        The request token for performing the update action. Request tokens help to identify duplicate
         *        requests. If a call times out or fails due to a transient error like a failed network connection, you
         *        can retry the call with the same request token. The service ensures that if the first call using that
         *        request token is successfully performed, the second call will not perform the action again. </p>
         *        <p>
         *        Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe
         *        requests spanning hours or days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends HoneycodeRequest.BuilderImpl implements Builder {
        private String workbookId;

        private String tableId;

        private List<UpsertRowData> rowsToUpsert = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpsertTableRowsRequest model) {
            super(model);
            workbookId(model.workbookId);
            tableId(model.tableId);
            rowsToUpsert(model.rowsToUpsert);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getWorkbookId() {
            return workbookId;
        }

        public final void setWorkbookId(String workbookId) {
            this.workbookId = workbookId;
        }

        @Override
        @Transient
        public final Builder workbookId(String workbookId) {
            this.workbookId = workbookId;
            return this;
        }

        public final String getTableId() {
            return tableId;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        @Override
        @Transient
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final List<UpsertRowData.Builder> getRowsToUpsert() {
            List<UpsertRowData.Builder> result = UpsertRowDataListCopier.copyToBuilder(this.rowsToUpsert);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRowsToUpsert(Collection<UpsertRowData.BuilderImpl> rowsToUpsert) {
            this.rowsToUpsert = UpsertRowDataListCopier.copyFromBuilder(rowsToUpsert);
        }

        @Override
        @Transient
        public final Builder rowsToUpsert(Collection<UpsertRowData> rowsToUpsert) {
            this.rowsToUpsert = UpsertRowDataListCopier.copy(rowsToUpsert);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rowsToUpsert(UpsertRowData... rowsToUpsert) {
            rowsToUpsert(Arrays.asList(rowsToUpsert));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rowsToUpsert(Consumer<UpsertRowData.Builder>... rowsToUpsert) {
            rowsToUpsert(Stream.of(rowsToUpsert).map(c -> UpsertRowData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpsertTableRowsRequest build() {
            return new BatchUpsertTableRowsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
