/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data needed to create a single row in a table as part of the BatchCreateTableRows request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRowData implements SdkPojo, Serializable, ToCopyableBuilder<CreateRowData.Builder, CreateRowData> {
    private static final SdkField<String> BATCH_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("batchItemId").getter(getter(CreateRowData::batchItemId)).setter(setter(Builder::batchItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchItemId").build()).build();

    private static final SdkField<Map<String, CellInput>> CELLS_TO_CREATE_FIELD = SdkField
            .<Map<String, CellInput>> builder(MarshallingType.MAP)
            .memberName("cellsToCreate")
            .getter(getter(CreateRowData::cellsToCreate))
            .setter(setter(Builder::cellsToCreate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cellsToCreate").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CellInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(CellInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_ITEM_ID_FIELD,
            CELLS_TO_CREATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String batchItemId;

    private final Map<String, CellInput> cellsToCreate;

    private CreateRowData(BuilderImpl builder) {
        this.batchItemId = builder.batchItemId;
        this.cellsToCreate = builder.cellsToCreate;
    }

    /**
     * <p>
     * An external identifier that represents the single row that is being created as part of the BatchCreateTableRows
     * request. This can be any string that you can use to identify the row in the request. The BatchCreateTableRows API
     * puts the batch item id in the results to allow you to link data in the request to data in the results.
     * </p>
     * 
     * @return An external identifier that represents the single row that is being created as part of the
     *         BatchCreateTableRows request. This can be any string that you can use to identify the row in the request.
     *         The BatchCreateTableRows API puts the batch item id in the results to allow you to link data in the
     *         request to data in the results.
     */
    public final String batchItemId() {
        return batchItemId;
    }

    /**
     * For responses, this returns true if the service returned a value for the CellsToCreate property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCellsToCreate() {
        return cellsToCreate != null && !(cellsToCreate instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map representing the cells to create in the new row. The key is the column id of the cell and the value is the
     * CellInput object that represents the data to set in that cell.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCellsToCreate} method.
     * </p>
     * 
     * @return A map representing the cells to create in the new row. The key is the column id of the cell and the value
     *         is the CellInput object that represents the data to set in that cell.
     */
    public final Map<String, CellInput> cellsToCreate() {
        return cellsToCreate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(batchItemId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCellsToCreate() ? cellsToCreate() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRowData)) {
            return false;
        }
        CreateRowData other = (CreateRowData) obj;
        return Objects.equals(batchItemId(), other.batchItemId()) && hasCellsToCreate() == other.hasCellsToCreate()
                && Objects.equals(cellsToCreate(), other.cellsToCreate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRowData").add("BatchItemId", batchItemId())
                .add("CellsToCreate", hasCellsToCreate() ? cellsToCreate() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "batchItemId":
            return Optional.ofNullable(clazz.cast(batchItemId()));
        case "cellsToCreate":
            return Optional.ofNullable(clazz.cast(cellsToCreate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRowData, T> g) {
        return obj -> g.apply((CreateRowData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateRowData> {
        /**
         * <p>
         * An external identifier that represents the single row that is being created as part of the
         * BatchCreateTableRows request. This can be any string that you can use to identify the row in the request. The
         * BatchCreateTableRows API puts the batch item id in the results to allow you to link data in the request to
         * data in the results.
         * </p>
         * 
         * @param batchItemId
         *        An external identifier that represents the single row that is being created as part of the
         *        BatchCreateTableRows request. This can be any string that you can use to identify the row in the
         *        request. The BatchCreateTableRows API puts the batch item id in the results to allow you to link data
         *        in the request to data in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchItemId(String batchItemId);

        /**
         * <p>
         * A map representing the cells to create in the new row. The key is the column id of the cell and the value is
         * the CellInput object that represents the data to set in that cell.
         * </p>
         * 
         * @param cellsToCreate
         *        A map representing the cells to create in the new row. The key is the column id of the cell and the
         *        value is the CellInput object that represents the data to set in that cell.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cellsToCreate(Map<String, CellInput> cellsToCreate);
    }

    static final class BuilderImpl implements Builder {
        private String batchItemId;

        private Map<String, CellInput> cellsToCreate = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRowData model) {
            batchItemId(model.batchItemId);
            cellsToCreate(model.cellsToCreate);
        }

        public final String getBatchItemId() {
            return batchItemId;
        }

        public final void setBatchItemId(String batchItemId) {
            this.batchItemId = batchItemId;
        }

        @Override
        @Transient
        public final Builder batchItemId(String batchItemId) {
            this.batchItemId = batchItemId;
            return this;
        }

        public final Map<String, CellInput.Builder> getCellsToCreate() {
            Map<String, CellInput.Builder> result = RowDataInputCopier.copyToBuilder(this.cellsToCreate);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCellsToCreate(Map<String, CellInput.BuilderImpl> cellsToCreate) {
            this.cellsToCreate = RowDataInputCopier.copyFromBuilder(cellsToCreate);
        }

        @Override
        @Transient
        public final Builder cellsToCreate(Map<String, CellInput> cellsToCreate) {
            this.cellsToCreate = RowDataInputCopier.copy(cellsToCreate);
            return this;
        }

        @Override
        public CreateRowData build() {
            return new CreateRowData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
