/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data needed to upsert rows in a table as part of a single item in the BatchUpsertTableRows request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpsertRowData implements SdkPojo, Serializable, ToCopyableBuilder<UpsertRowData.Builder, UpsertRowData> {
    private static final SdkField<String> BATCH_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("batchItemId").getter(getter(UpsertRowData::batchItemId)).setter(setter(Builder::batchItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchItemId").build()).build();

    private static final SdkField<Filter> FILTER_FIELD = SdkField.<Filter> builder(MarshallingType.SDK_POJO).memberName("filter")
            .getter(getter(UpsertRowData::filter)).setter(setter(Builder::filter)).constructor(Filter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<Map<String, CellInput>> CELLS_TO_UPDATE_FIELD = SdkField
            .<Map<String, CellInput>> builder(MarshallingType.MAP)
            .memberName("cellsToUpdate")
            .getter(getter(UpsertRowData::cellsToUpdate))
            .setter(setter(Builder::cellsToUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cellsToUpdate").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CellInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(CellInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_ITEM_ID_FIELD,
            FILTER_FIELD, CELLS_TO_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String batchItemId;

    private final Filter filter;

    private final Map<String, CellInput> cellsToUpdate;

    private UpsertRowData(BuilderImpl builder) {
        this.batchItemId = builder.batchItemId;
        this.filter = builder.filter;
        this.cellsToUpdate = builder.cellsToUpdate;
    }

    /**
     * <p>
     * An external identifier that represents a single item in the request that is being upserted as part of the
     * BatchUpsertTableRows request. This can be any string that you can use to identify the item in the request. The
     * BatchUpsertTableRows API puts the batch item id in the results to allow you to link data in the request to data
     * in the results.
     * </p>
     * 
     * @return An external identifier that represents a single item in the request that is being upserted as part of the
     *         BatchUpsertTableRows request. This can be any string that you can use to identify the item in the
     *         request. The BatchUpsertTableRows API puts the batch item id in the results to allow you to link data in
     *         the request to data in the results.
     */
    public final String batchItemId() {
        return batchItemId;
    }

    /**
     * <p>
     * The filter formula to use to find existing matching rows to update. The formula needs to return zero or more
     * rows. If the formula returns 0 rows, then a new row will be appended in the target table. If the formula returns
     * one or more rows, then the returned rows will be updated.
     * </p>
     * <p>
     * Note that the filter formula needs to return rows from the target table for the upsert operation to succeed. If
     * the filter formula has a syntax error or it doesn't evaluate to zero or more rows in the target table for any one
     * item in the input list, then the entire BatchUpsertTableRows request fails and no updates are made to the table.
     * </p>
     * 
     * @return The filter formula to use to find existing matching rows to update. The formula needs to return zero or
     *         more rows. If the formula returns 0 rows, then a new row will be appended in the target table. If the
     *         formula returns one or more rows, then the returned rows will be updated. </p>
     *         <p>
     *         Note that the filter formula needs to return rows from the target table for the upsert operation to
     *         succeed. If the filter formula has a syntax error or it doesn't evaluate to zero or more rows in the
     *         target table for any one item in the input list, then the entire BatchUpsertTableRows request fails and
     *         no updates are made to the table.
     */
    public final Filter filter() {
        return filter;
    }

    /**
     * For responses, this returns true if the service returned a value for the CellsToUpdate property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCellsToUpdate() {
        return cellsToUpdate != null && !(cellsToUpdate instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map representing the cells to update for the matching rows or an appended row. The key is the column id of the
     * cell and the value is the CellInput object that represents the data to set in that cell.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCellsToUpdate} method.
     * </p>
     * 
     * @return A map representing the cells to update for the matching rows or an appended row. The key is the column id
     *         of the cell and the value is the CellInput object that represents the data to set in that cell.
     */
    public final Map<String, CellInput> cellsToUpdate() {
        return cellsToUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(batchItemId());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(hasCellsToUpdate() ? cellsToUpdate() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpsertRowData)) {
            return false;
        }
        UpsertRowData other = (UpsertRowData) obj;
        return Objects.equals(batchItemId(), other.batchItemId()) && Objects.equals(filter(), other.filter())
                && hasCellsToUpdate() == other.hasCellsToUpdate() && Objects.equals(cellsToUpdate(), other.cellsToUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpsertRowData").add("BatchItemId", batchItemId()).add("Filter", filter())
                .add("CellsToUpdate", hasCellsToUpdate() ? cellsToUpdate() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "batchItemId":
            return Optional.ofNullable(clazz.cast(batchItemId()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "cellsToUpdate":
            return Optional.ofNullable(clazz.cast(cellsToUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpsertRowData, T> g) {
        return obj -> g.apply((UpsertRowData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpsertRowData> {
        /**
         * <p>
         * An external identifier that represents a single item in the request that is being upserted as part of the
         * BatchUpsertTableRows request. This can be any string that you can use to identify the item in the request.
         * The BatchUpsertTableRows API puts the batch item id in the results to allow you to link data in the request
         * to data in the results.
         * </p>
         * 
         * @param batchItemId
         *        An external identifier that represents a single item in the request that is being upserted as part of
         *        the BatchUpsertTableRows request. This can be any string that you can use to identify the item in the
         *        request. The BatchUpsertTableRows API puts the batch item id in the results to allow you to link data
         *        in the request to data in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchItemId(String batchItemId);

        /**
         * <p>
         * The filter formula to use to find existing matching rows to update. The formula needs to return zero or more
         * rows. If the formula returns 0 rows, then a new row will be appended in the target table. If the formula
         * returns one or more rows, then the returned rows will be updated.
         * </p>
         * <p>
         * Note that the filter formula needs to return rows from the target table for the upsert operation to succeed.
         * If the filter formula has a syntax error or it doesn't evaluate to zero or more rows in the target table for
         * any one item in the input list, then the entire BatchUpsertTableRows request fails and no updates are made to
         * the table.
         * </p>
         * 
         * @param filter
         *        The filter formula to use to find existing matching rows to update. The formula needs to return zero
         *        or more rows. If the formula returns 0 rows, then a new row will be appended in the target table. If
         *        the formula returns one or more rows, then the returned rows will be updated. </p>
         *        <p>
         *        Note that the filter formula needs to return rows from the target table for the upsert operation to
         *        succeed. If the filter formula has a syntax error or it doesn't evaluate to zero or more rows in the
         *        target table for any one item in the input list, then the entire BatchUpsertTableRows request fails
         *        and no updates are made to the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Filter filter);

        /**
         * <p>
         * The filter formula to use to find existing matching rows to update. The formula needs to return zero or more
         * rows. If the formula returns 0 rows, then a new row will be appended in the target table. If the formula
         * returns one or more rows, then the returned rows will be updated.
         * </p>
         * <p>
         * Note that the filter formula needs to return rows from the target table for the upsert operation to succeed.
         * If the filter formula has a syntax error or it doesn't evaluate to zero or more rows in the target table for
         * any one item in the input list, then the entire BatchUpsertTableRows request fails and no updates are made to
         * the table.
         * </p>
         * This is a convenience that creates an instance of the {@link Filter.Builder} avoiding the need to create one
         * manually via {@link Filter#builder()}.
         *
         * When the {@link Consumer} completes, {@link Filter.Builder#build()} is called immediately and its result is
         * passed to {@link #filter(Filter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(Filter)
         */
        default Builder filter(Consumer<Filter.Builder> filter) {
            return filter(Filter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * A map representing the cells to update for the matching rows or an appended row. The key is the column id of
         * the cell and the value is the CellInput object that represents the data to set in that cell.
         * </p>
         * 
         * @param cellsToUpdate
         *        A map representing the cells to update for the matching rows or an appended row. The key is the column
         *        id of the cell and the value is the CellInput object that represents the data to set in that cell.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cellsToUpdate(Map<String, CellInput> cellsToUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String batchItemId;

        private Filter filter;

        private Map<String, CellInput> cellsToUpdate = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpsertRowData model) {
            batchItemId(model.batchItemId);
            filter(model.filter);
            cellsToUpdate(model.cellsToUpdate);
        }

        public final String getBatchItemId() {
            return batchItemId;
        }

        public final void setBatchItemId(String batchItemId) {
            this.batchItemId = batchItemId;
        }

        @Override
        @Transient
        public final Builder batchItemId(String batchItemId) {
            this.batchItemId = batchItemId;
            return this;
        }

        public final Filter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(Filter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        @Transient
        public final Builder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public final Map<String, CellInput.Builder> getCellsToUpdate() {
            Map<String, CellInput.Builder> result = RowDataInputCopier.copyToBuilder(this.cellsToUpdate);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCellsToUpdate(Map<String, CellInput.BuilderImpl> cellsToUpdate) {
            this.cellsToUpdate = RowDataInputCopier.copyFromBuilder(cellsToUpdate);
        }

        @Override
        @Transient
        public final Builder cellsToUpdate(Map<String, CellInput> cellsToUpdate) {
            this.cellsToUpdate = RowDataInputCopier.copy(cellsToUpdate);
            return this;
        }

        @Override
        public UpsertRowData build() {
            return new UpsertRowData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
