/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.honeycode.model.Filter;
import software.amazon.awssdk.services.honeycode.model.HoneycodeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryTableRowsRequest
extends HoneycodeRequest
implements ToCopyableBuilder<Builder, QueryTableRowsRequest> {
    private static final SdkField<String> WORKBOOK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workbookId").getter(QueryTableRowsRequest.getter(QueryTableRowsRequest::workbookId)).setter(QueryTableRowsRequest.setter(Builder::workbookId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workbookId").build()}).build();
    private static final SdkField<String> TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableId").getter(QueryTableRowsRequest.getter(QueryTableRowsRequest::tableId)).setter(QueryTableRowsRequest.setter(Builder::tableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableId").build()}).build();
    private static final SdkField<Filter> FILTER_FORMULA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filterFormula").getter(QueryTableRowsRequest.getter(QueryTableRowsRequest::filterFormula)).setter(QueryTableRowsRequest.setter(Builder::filterFormula)).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterFormula").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(QueryTableRowsRequest.getter(QueryTableRowsRequest::maxResults)).setter(QueryTableRowsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(QueryTableRowsRequest.getter(QueryTableRowsRequest::nextToken)).setter(QueryTableRowsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKBOOK_ID_FIELD, TABLE_ID_FIELD, FILTER_FORMULA_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String workbookId;
    private final String tableId;
    private final Filter filterFormula;
    private final Integer maxResults;
    private final String nextToken;

    private QueryTableRowsRequest(BuilderImpl builder) {
        super(builder);
        this.workbookId = builder.workbookId;
        this.tableId = builder.tableId;
        this.filterFormula = builder.filterFormula;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String workbookId() {
        return this.workbookId;
    }

    public final String tableId() {
        return this.tableId;
    }

    public final Filter filterFormula() {
        return this.filterFormula;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workbookId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterFormula());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryTableRowsRequest)) {
            return false;
        }
        QueryTableRowsRequest other = (QueryTableRowsRequest)((Object)obj);
        return Objects.equals(this.workbookId(), other.workbookId()) && Objects.equals(this.tableId(), other.tableId()) && Objects.equals(this.filterFormula(), other.filterFormula()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"QueryTableRowsRequest").add("WorkbookId", (Object)this.workbookId()).add("TableId", (Object)this.tableId()).add("FilterFormula", (Object)this.filterFormula()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workbookId": {
                return Optional.ofNullable(clazz.cast(this.workbookId()));
            }
            case "tableId": {
                return Optional.ofNullable(clazz.cast(this.tableId()));
            }
            case "filterFormula": {
                return Optional.ofNullable(clazz.cast(this.filterFormula()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryTableRowsRequest, T> g) {
        return obj -> g.apply((QueryTableRowsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HoneycodeRequest.BuilderImpl
    implements Builder {
        private String workbookId;
        private String tableId;
        private Filter filterFormula;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryTableRowsRequest model) {
            super(model);
            this.workbookId(model.workbookId);
            this.tableId(model.tableId);
            this.filterFormula(model.filterFormula);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getWorkbookId() {
            return this.workbookId;
        }

        public final void setWorkbookId(String workbookId) {
            this.workbookId = workbookId;
        }

        @Override
        @Transient
        public final Builder workbookId(String workbookId) {
            this.workbookId = workbookId;
            return this;
        }

        public final String getTableId() {
            return this.tableId;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        @Override
        @Transient
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final Filter.Builder getFilterFormula() {
            return this.filterFormula != null ? this.filterFormula.toBuilder() : null;
        }

        public final void setFilterFormula(Filter.BuilderImpl filterFormula) {
            this.filterFormula = filterFormula != null ? filterFormula.build() : null;
        }

        @Override
        @Transient
        public final Builder filterFormula(Filter filterFormula) {
            this.filterFormula = filterFormula;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public QueryTableRowsRequest build() {
            return new QueryTableRowsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HoneycodeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, QueryTableRowsRequest> {
        public Builder workbookId(String var1);

        public Builder tableId(String var1);

        public Builder filterFormula(Filter var1);

        default public Builder filterFormula(Consumer<Filter.Builder> filterFormula) {
            return this.filterFormula((Filter)((Filter.Builder)Filter.builder().applyMutation(filterFormula)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

