/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains attributes about a single row in a table
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableRow implements SdkPojo, Serializable, ToCopyableBuilder<TableRow.Builder, TableRow> {
    private static final SdkField<String> ROW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("rowId")
            .getter(getter(TableRow::rowId)).setter(setter(Builder::rowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowId").build()).build();

    private static final SdkField<List<Cell>> CELLS_FIELD = SdkField
            .<List<Cell>> builder(MarshallingType.LIST)
            .memberName("cells")
            .getter(getter(TableRow::cells))
            .setter(setter(Builder::cells))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cells").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Cell> builder(MarshallingType.SDK_POJO)
                                            .constructor(Cell::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROW_ID_FIELD, CELLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String rowId;

    private final List<Cell> cells;

    private TableRow(BuilderImpl builder) {
        this.rowId = builder.rowId;
        this.cells = builder.cells;
    }

    /**
     * <p>
     * The id of the row in the table.
     * </p>
     * 
     * @return The id of the row in the table.
     */
    public final String rowId() {
        return rowId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Cells property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCells() {
        return cells != null && !(cells instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cells in the table row. The cells appear in the same order as the columns of the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCells} method.
     * </p>
     * 
     * @return A list of cells in the table row. The cells appear in the same order as the columns of the table.
     */
    public final List<Cell> cells() {
        return cells;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rowId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCells() ? cells() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableRow)) {
            return false;
        }
        TableRow other = (TableRow) obj;
        return Objects.equals(rowId(), other.rowId()) && hasCells() == other.hasCells() && Objects.equals(cells(), other.cells());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableRow").add("RowId", rowId())
                .add("Cells", cells() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rowId":
            return Optional.ofNullable(clazz.cast(rowId()));
        case "cells":
            return Optional.ofNullable(clazz.cast(cells()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableRow, T> g) {
        return obj -> g.apply((TableRow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableRow> {
        /**
         * <p>
         * The id of the row in the table.
         * </p>
         * 
         * @param rowId
         *        The id of the row in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowId(String rowId);

        /**
         * <p>
         * A list of cells in the table row. The cells appear in the same order as the columns of the table.
         * </p>
         * 
         * @param cells
         *        A list of cells in the table row. The cells appear in the same order as the columns of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cells(Collection<Cell> cells);

        /**
         * <p>
         * A list of cells in the table row. The cells appear in the same order as the columns of the table.
         * </p>
         * 
         * @param cells
         *        A list of cells in the table row. The cells appear in the same order as the columns of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cells(Cell... cells);

        /**
         * <p>
         * A list of cells in the table row. The cells appear in the same order as the columns of the table.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Cell>.Builder} avoiding the need to
         * create one manually via {@link List<Cell>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Cell>.Builder#build()} is called immediately and its result
         * is passed to {@link #cells(List<Cell>)}.
         * 
         * @param cells
         *        a consumer that will call methods on {@link List<Cell>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cells(List<Cell>)
         */
        Builder cells(Consumer<Cell.Builder>... cells);
    }

    static final class BuilderImpl implements Builder {
        private String rowId;

        private List<Cell> cells = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TableRow model) {
            rowId(model.rowId);
            cells(model.cells);
        }

        public final String getRowId() {
            return rowId;
        }

        public final void setRowId(String rowId) {
            this.rowId = rowId;
        }

        @Override
        public final Builder rowId(String rowId) {
            this.rowId = rowId;
            return this;
        }

        public final List<Cell.Builder> getCells() {
            List<Cell.Builder> result = CellsCopier.copyToBuilder(this.cells);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCells(Collection<Cell.BuilderImpl> cells) {
            this.cells = CellsCopier.copyFromBuilder(cells);
        }

        @Override
        public final Builder cells(Collection<Cell> cells) {
            this.cells = CellsCopier.copy(cells);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cells(Cell... cells) {
            cells(Arrays.asList(cells));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cells(Consumer<Cell.Builder>... cells) {
            cells(Stream.of(cells).map(c -> Cell.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TableRow build() {
            return new TableRow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
