/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata associated with the table data import job that was submitted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableDataImportJobMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<TableDataImportJobMetadata.Builder, TableDataImportJobMetadata> {
    private static final SdkField<ImportJobSubmitter> SUBMITTER_FIELD = SdkField
            .<ImportJobSubmitter> builder(MarshallingType.SDK_POJO).memberName("submitter")
            .getter(getter(TableDataImportJobMetadata::submitter)).setter(setter(Builder::submitter))
            .constructor(ImportJobSubmitter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submitter").build()).build();

    private static final SdkField<Instant> SUBMIT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("submitTime").getter(getter(TableDataImportJobMetadata::submitTime)).setter(setter(Builder::submitTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submitTime").build()).build();

    private static final SdkField<ImportOptions> IMPORT_OPTIONS_FIELD = SdkField
            .<ImportOptions> builder(MarshallingType.SDK_POJO).memberName("importOptions")
            .getter(getter(TableDataImportJobMetadata::importOptions)).setter(setter(Builder::importOptions))
            .constructor(ImportOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importOptions").build()).build();

    private static final SdkField<ImportDataSource> DATA_SOURCE_FIELD = SdkField
            .<ImportDataSource> builder(MarshallingType.SDK_POJO).memberName("dataSource")
            .getter(getter(TableDataImportJobMetadata::dataSource)).setter(setter(Builder::dataSource))
            .constructor(ImportDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBMITTER_FIELD,
            SUBMIT_TIME_FIELD, IMPORT_OPTIONS_FIELD, DATA_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ImportJobSubmitter submitter;

    private final Instant submitTime;

    private final ImportOptions importOptions;

    private final ImportDataSource dataSource;

    private TableDataImportJobMetadata(BuilderImpl builder) {
        this.submitter = builder.submitter;
        this.submitTime = builder.submitTime;
        this.importOptions = builder.importOptions;
        this.dataSource = builder.dataSource;
    }

    /**
     * <p>
     * Details about the submitter of the import request.
     * </p>
     * 
     * @return Details about the submitter of the import request.
     */
    public final ImportJobSubmitter submitter() {
        return submitter;
    }

    /**
     * <p>
     * The timestamp when the job was submitted for import.
     * </p>
     * 
     * @return The timestamp when the job was submitted for import.
     */
    public final Instant submitTime() {
        return submitTime;
    }

    /**
     * <p>
     * The options that was specified at the time of submitting the import request.
     * </p>
     * 
     * @return The options that was specified at the time of submitting the import request.
     */
    public final ImportOptions importOptions() {
        return importOptions;
    }

    /**
     * <p>
     * The source of the data that was submitted for import.
     * </p>
     * 
     * @return The source of the data that was submitted for import.
     */
    public final ImportDataSource dataSource() {
        return dataSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(submitter());
        hashCode = 31 * hashCode + Objects.hashCode(submitTime());
        hashCode = 31 * hashCode + Objects.hashCode(importOptions());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableDataImportJobMetadata)) {
            return false;
        }
        TableDataImportJobMetadata other = (TableDataImportJobMetadata) obj;
        return Objects.equals(submitter(), other.submitter()) && Objects.equals(submitTime(), other.submitTime())
                && Objects.equals(importOptions(), other.importOptions()) && Objects.equals(dataSource(), other.dataSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableDataImportJobMetadata").add("Submitter", submitter()).add("SubmitTime", submitTime())
                .add("ImportOptions", importOptions()).add("DataSource", dataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "submitter":
            return Optional.ofNullable(clazz.cast(submitter()));
        case "submitTime":
            return Optional.ofNullable(clazz.cast(submitTime()));
        case "importOptions":
            return Optional.ofNullable(clazz.cast(importOptions()));
        case "dataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableDataImportJobMetadata, T> g) {
        return obj -> g.apply((TableDataImportJobMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableDataImportJobMetadata> {
        /**
         * <p>
         * Details about the submitter of the import request.
         * </p>
         * 
         * @param submitter
         *        Details about the submitter of the import request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitter(ImportJobSubmitter submitter);

        /**
         * <p>
         * Details about the submitter of the import request.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportJobSubmitter.Builder} avoiding the
         * need to create one manually via {@link ImportJobSubmitter#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImportJobSubmitter.Builder#build()} is called immediately and its
         * result is passed to {@link #submitter(ImportJobSubmitter)}.
         * 
         * @param submitter
         *        a consumer that will call methods on {@link ImportJobSubmitter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #submitter(ImportJobSubmitter)
         */
        default Builder submitter(Consumer<ImportJobSubmitter.Builder> submitter) {
            return submitter(ImportJobSubmitter.builder().applyMutation(submitter).build());
        }

        /**
         * <p>
         * The timestamp when the job was submitted for import.
         * </p>
         * 
         * @param submitTime
         *        The timestamp when the job was submitted for import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTime(Instant submitTime);

        /**
         * <p>
         * The options that was specified at the time of submitting the import request.
         * </p>
         * 
         * @param importOptions
         *        The options that was specified at the time of submitting the import request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importOptions(ImportOptions importOptions);

        /**
         * <p>
         * The options that was specified at the time of submitting the import request.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportOptions.Builder} avoiding the need
         * to create one manually via {@link ImportOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImportOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #importOptions(ImportOptions)}.
         * 
         * @param importOptions
         *        a consumer that will call methods on {@link ImportOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importOptions(ImportOptions)
         */
        default Builder importOptions(Consumer<ImportOptions.Builder> importOptions) {
            return importOptions(ImportOptions.builder().applyMutation(importOptions).build());
        }

        /**
         * <p>
         * The source of the data that was submitted for import.
         * </p>
         * 
         * @param dataSource
         *        The source of the data that was submitted for import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(ImportDataSource dataSource);

        /**
         * <p>
         * The source of the data that was submitted for import.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportDataSource.Builder} avoiding the
         * need to create one manually via {@link ImportDataSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImportDataSource.Builder#build()} is called immediately and its
         * result is passed to {@link #dataSource(ImportDataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link ImportDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(ImportDataSource)
         */
        default Builder dataSource(Consumer<ImportDataSource.Builder> dataSource) {
            return dataSource(ImportDataSource.builder().applyMutation(dataSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ImportJobSubmitter submitter;

        private Instant submitTime;

        private ImportOptions importOptions;

        private ImportDataSource dataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(TableDataImportJobMetadata model) {
            submitter(model.submitter);
            submitTime(model.submitTime);
            importOptions(model.importOptions);
            dataSource(model.dataSource);
        }

        public final ImportJobSubmitter.Builder getSubmitter() {
            return submitter != null ? submitter.toBuilder() : null;
        }

        public final void setSubmitter(ImportJobSubmitter.BuilderImpl submitter) {
            this.submitter = submitter != null ? submitter.build() : null;
        }

        @Override
        public final Builder submitter(ImportJobSubmitter submitter) {
            this.submitter = submitter;
            return this;
        }

        public final Instant getSubmitTime() {
            return submitTime;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        @Override
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final ImportOptions.Builder getImportOptions() {
            return importOptions != null ? importOptions.toBuilder() : null;
        }

        public final void setImportOptions(ImportOptions.BuilderImpl importOptions) {
            this.importOptions = importOptions != null ? importOptions.build() : null;
        }

        @Override
        public final Builder importOptions(ImportOptions importOptions) {
            this.importOptions = importOptions;
            return this;
        }

        public final ImportDataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(ImportDataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(ImportDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @Override
        public TableDataImportJobMetadata build() {
            return new TableDataImportJobMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
