/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.honeycode.HoneycodeClient;
import software.amazon.awssdk.services.honeycode.model.QueryTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.QueryTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.TableRow;

public class QueryTableRowsIterable
implements SdkIterable<QueryTableRowsResponse> {
    private final HoneycodeClient client;
    private final QueryTableRowsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public QueryTableRowsIterable(HoneycodeClient client, QueryTableRowsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new QueryTableRowsResponseFetcher();
    }

    public Iterator<QueryTableRowsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TableRow> rows() {
        Function<QueryTableRowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.rows() != null) {
                return response.rows().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class QueryTableRowsResponseFetcher
    implements SyncPageFetcher<QueryTableRowsResponse> {
        private QueryTableRowsResponseFetcher() {
        }

        public boolean hasNextPage(QueryTableRowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public QueryTableRowsResponse nextPage(QueryTableRowsResponse previousPage) {
            if (previousPage == null) {
                return QueryTableRowsIterable.this.client.queryTableRows(QueryTableRowsIterable.this.firstRequest);
            }
            return QueryTableRowsIterable.this.client.queryTableRows((QueryTableRowsRequest)((Object)QueryTableRowsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

