/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTableRowsResponse extends HoneycodeResponse implements
        ToCopyableBuilder<ListTableRowsResponse.Builder, ListTableRowsResponse> {
    private static final SdkField<List<String>> COLUMN_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("columnIds")
            .getter(getter(ListTableRowsResponse::columnIds))
            .setter(setter(Builder::columnIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TableRow>> ROWS_FIELD = SdkField
            .<List<TableRow>> builder(MarshallingType.LIST)
            .memberName("rows")
            .getter(getter(ListTableRowsResponse::rows))
            .setter(setter(Builder::rows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TableRow> builder(MarshallingType.SDK_POJO)
                                            .constructor(TableRow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ROW_IDS_NOT_FOUND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("rowIdsNotFound")
            .getter(getter(ListTableRowsResponse::rowIdsNotFound))
            .setter(setter(Builder::rowIdsNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowIdsNotFound").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTableRowsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Long> WORKBOOK_CURSOR_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("workbookCursor").getter(getter(ListTableRowsResponse::workbookCursor))
            .setter(setter(Builder::workbookCursor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workbookCursor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_IDS_FIELD, ROWS_FIELD,
            ROW_IDS_NOT_FOUND_FIELD, NEXT_TOKEN_FIELD, WORKBOOK_CURSOR_FIELD));

    private final List<String> columnIds;

    private final List<TableRow> rows;

    private final List<String> rowIdsNotFound;

    private final String nextToken;

    private final Long workbookCursor;

    private ListTableRowsResponse(BuilderImpl builder) {
        super(builder);
        this.columnIds = builder.columnIds;
        this.rows = builder.rows;
        this.rowIdsNotFound = builder.rowIdsNotFound;
        this.nextToken = builder.nextToken;
        this.workbookCursor = builder.workbookCursor;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasColumnIds() {
        return columnIds != null && !(columnIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of columns in the table whose row data is returned in the result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnIds} method.
     * </p>
     * 
     * @return The list of columns in the table whose row data is returned in the result.
     */
    public final List<String> columnIds() {
        return columnIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rows property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRows() {
        return rows != null && !(rows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of rows in the table. Note that this result is paginated, so this list contains a maximum of 100 rows.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRows} method.
     * </p>
     * 
     * @return The list of rows in the table. Note that this result is paginated, so this list contains a maximum of 100
     *         rows.
     */
    public final List<TableRow> rows() {
        return rows;
    }

    /**
     * For responses, this returns true if the service returned a value for the RowIdsNotFound property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRowIdsNotFound() {
        return rowIdsNotFound != null && !(rowIdsNotFound instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of row ids included in the request that were not found in the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRowIdsNotFound} method.
     * </p>
     * 
     * @return The list of row ids included in the request that were not found in the table.
     */
    public final List<String> rowIdsNotFound() {
        return rowIdsNotFound;
    }

    /**
     * <p>
     * Provides the pagination token to load the next page if there are more results matching the request. If a
     * pagination token is not present in the response, it means that all data matching the request has been loaded.
     * </p>
     * 
     * @return Provides the pagination token to load the next page if there are more results matching the request. If a
     *         pagination token is not present in the response, it means that all data matching the request has been
     *         loaded.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps
     * increasing with every update and the increments are not sequential.
     * </p>
     * 
     * @return Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor
     *         keeps increasing with every update and the increments are not sequential.
     */
    public final Long workbookCursor() {
        return workbookCursor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnIds() ? columnIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRows() ? rows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRowIdsNotFound() ? rowIdsNotFound() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(workbookCursor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTableRowsResponse)) {
            return false;
        }
        ListTableRowsResponse other = (ListTableRowsResponse) obj;
        return hasColumnIds() == other.hasColumnIds() && Objects.equals(columnIds(), other.columnIds())
                && hasRows() == other.hasRows() && Objects.equals(rows(), other.rows())
                && hasRowIdsNotFound() == other.hasRowIdsNotFound() && Objects.equals(rowIdsNotFound(), other.rowIdsNotFound())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(workbookCursor(), other.workbookCursor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTableRowsResponse").add("ColumnIds", hasColumnIds() ? columnIds() : null)
                .add("Rows", hasRows() ? rows() : null).add("RowIdsNotFound", hasRowIdsNotFound() ? rowIdsNotFound() : null)
                .add("NextToken", nextToken()).add("WorkbookCursor", workbookCursor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "columnIds":
            return Optional.ofNullable(clazz.cast(columnIds()));
        case "rows":
            return Optional.ofNullable(clazz.cast(rows()));
        case "rowIdsNotFound":
            return Optional.ofNullable(clazz.cast(rowIdsNotFound()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "workbookCursor":
            return Optional.ofNullable(clazz.cast(workbookCursor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTableRowsResponse, T> g) {
        return obj -> g.apply((ListTableRowsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HoneycodeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTableRowsResponse> {
        /**
         * <p>
         * The list of columns in the table whose row data is returned in the result.
         * </p>
         * 
         * @param columnIds
         *        The list of columns in the table whose row data is returned in the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnIds(Collection<String> columnIds);

        /**
         * <p>
         * The list of columns in the table whose row data is returned in the result.
         * </p>
         * 
         * @param columnIds
         *        The list of columns in the table whose row data is returned in the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnIds(String... columnIds);

        /**
         * <p>
         * The list of rows in the table. Note that this result is paginated, so this list contains a maximum of 100
         * rows.
         * </p>
         * 
         * @param rows
         *        The list of rows in the table. Note that this result is paginated, so this list contains a maximum of
         *        100 rows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(Collection<TableRow> rows);

        /**
         * <p>
         * The list of rows in the table. Note that this result is paginated, so this list contains a maximum of 100
         * rows.
         * </p>
         * 
         * @param rows
         *        The list of rows in the table. Note that this result is paginated, so this list contains a maximum of
         *        100 rows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(TableRow... rows);

        /**
         * <p>
         * The list of rows in the table. Note that this result is paginated, so this list contains a maximum of 100
         * rows.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TableRow>.Builder} avoiding the need to
         * create one manually via {@link List<TableRow>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TableRow>.Builder#build()} is called immediately and its
         * result is passed to {@link #rows(List<TableRow>)}.
         * 
         * @param rows
         *        a consumer that will call methods on {@link List<TableRow>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rows(List<TableRow>)
         */
        Builder rows(Consumer<TableRow.Builder>... rows);

        /**
         * <p>
         * The list of row ids included in the request that were not found in the table.
         * </p>
         * 
         * @param rowIdsNotFound
         *        The list of row ids included in the request that were not found in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowIdsNotFound(Collection<String> rowIdsNotFound);

        /**
         * <p>
         * The list of row ids included in the request that were not found in the table.
         * </p>
         * 
         * @param rowIdsNotFound
         *        The list of row ids included in the request that were not found in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowIdsNotFound(String... rowIdsNotFound);

        /**
         * <p>
         * Provides the pagination token to load the next page if there are more results matching the request. If a
         * pagination token is not present in the response, it means that all data matching the request has been loaded.
         * </p>
         * 
         * @param nextToken
         *        Provides the pagination token to load the next page if there are more results matching the request. If
         *        a pagination token is not present in the response, it means that all data matching the request has
         *        been loaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor
         * keeps increasing with every update and the increments are not sequential.
         * </p>
         * 
         * @param workbookCursor
         *        Indicates the cursor of the workbook at which the data returned by this request is read. Workbook
         *        cursor keeps increasing with every update and the increments are not sequential.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workbookCursor(Long workbookCursor);
    }

    static final class BuilderImpl extends HoneycodeResponse.BuilderImpl implements Builder {
        private List<String> columnIds = DefaultSdkAutoConstructList.getInstance();

        private List<TableRow> rows = DefaultSdkAutoConstructList.getInstance();

        private List<String> rowIdsNotFound = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Long workbookCursor;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTableRowsResponse model) {
            super(model);
            columnIds(model.columnIds);
            rows(model.rows);
            rowIdsNotFound(model.rowIdsNotFound);
            nextToken(model.nextToken);
            workbookCursor(model.workbookCursor);
        }

        public final Collection<String> getColumnIds() {
            if (columnIds instanceof SdkAutoConstructList) {
                return null;
            }
            return columnIds;
        }

        public final void setColumnIds(Collection<String> columnIds) {
            this.columnIds = ResourceIdsCopier.copy(columnIds);
        }

        @Override
        @Transient
        public final Builder columnIds(Collection<String> columnIds) {
            this.columnIds = ResourceIdsCopier.copy(columnIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columnIds(String... columnIds) {
            columnIds(Arrays.asList(columnIds));
            return this;
        }

        public final List<TableRow.Builder> getRows() {
            List<TableRow.Builder> result = TableRowsCopier.copyToBuilder(this.rows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRows(Collection<TableRow.BuilderImpl> rows) {
            this.rows = TableRowsCopier.copyFromBuilder(rows);
        }

        @Override
        @Transient
        public final Builder rows(Collection<TableRow> rows) {
            this.rows = TableRowsCopier.copy(rows);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rows(TableRow... rows) {
            rows(Arrays.asList(rows));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rows(Consumer<TableRow.Builder>... rows) {
            rows(Stream.of(rows).map(c -> TableRow.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRowIdsNotFound() {
            if (rowIdsNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return rowIdsNotFound;
        }

        public final void setRowIdsNotFound(Collection<String> rowIdsNotFound) {
            this.rowIdsNotFound = RowIdListCopier.copy(rowIdsNotFound);
        }

        @Override
        @Transient
        public final Builder rowIdsNotFound(Collection<String> rowIdsNotFound) {
            this.rowIdsNotFound = RowIdListCopier.copy(rowIdsNotFound);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rowIdsNotFound(String... rowIdsNotFound) {
            rowIdsNotFound(Arrays.asList(rowIdsNotFound));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getWorkbookCursor() {
            return workbookCursor;
        }

        public final void setWorkbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
        }

        @Override
        @Transient
        public final Builder workbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
            return this;
        }

        @Override
        public ListTableRowsResponse build() {
            return new ListTableRowsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
