/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a filter formula along with the id of the context row under which the filter function needs
 * to evaluate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filter implements SdkPojo, Serializable, ToCopyableBuilder<Filter.Builder, Filter> {
    private static final SdkField<String> FORMULA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("formula")
            .getter(getter(Filter::formula)).setter(setter(Builder::formula))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formula").build()).build();

    private static final SdkField<String> CONTEXT_ROW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contextRowId").getter(getter(Filter::contextRowId)).setter(setter(Builder::contextRowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contextRowId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMULA_FIELD,
            CONTEXT_ROW_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String formula;

    private final String contextRowId;

    private Filter(BuilderImpl builder) {
        this.formula = builder.formula;
        this.contextRowId = builder.contextRowId;
    }

    /**
     * <p>
     * A formula representing a filter function that returns zero or more matching rows from a table. Valid formulas in
     * this field return a list of rows from a table. The most common ways of writing a formula to return a list of rows
     * are to use the FindRow() or Filter() functions. Any other formula that returns zero or more rows is also
     * acceptable. For example, you can use a formula that points to a cell that contains a filter function.
     * </p>
     * 
     * @return A formula representing a filter function that returns zero or more matching rows from a table. Valid
     *         formulas in this field return a list of rows from a table. The most common ways of writing a formula to
     *         return a list of rows are to use the FindRow() or Filter() functions. Any other formula that returns zero
     *         or more rows is also acceptable. For example, you can use a formula that points to a cell that contains a
     *         filter function.
     */
    public final String formula() {
        return formula;
    }

    /**
     * <p>
     * The optional contextRowId attribute can be used to specify the row id of the context row if the filter formula
     * contains unqualified references to table columns and needs a context row to evaluate them successfully.
     * </p>
     * 
     * @return The optional contextRowId attribute can be used to specify the row id of the context row if the filter
     *         formula contains unqualified references to table columns and needs a context row to evaluate them
     *         successfully.
     */
    public final String contextRowId() {
        return contextRowId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(formula());
        hashCode = 31 * hashCode + Objects.hashCode(contextRowId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter) obj;
        return Objects.equals(formula(), other.formula()) && Objects.equals(contextRowId(), other.contextRowId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Filter").add("Formula", formula() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ContextRowId", contextRowId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "formula":
            return Optional.ofNullable(clazz.cast(formula()));
        case "contextRowId":
            return Optional.ofNullable(clazz.cast(contextRowId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filter> {
        /**
         * <p>
         * A formula representing a filter function that returns zero or more matching rows from a table. Valid formulas
         * in this field return a list of rows from a table. The most common ways of writing a formula to return a list
         * of rows are to use the FindRow() or Filter() functions. Any other formula that returns zero or more rows is
         * also acceptable. For example, you can use a formula that points to a cell that contains a filter function.
         * </p>
         * 
         * @param formula
         *        A formula representing a filter function that returns zero or more matching rows from a table. Valid
         *        formulas in this field return a list of rows from a table. The most common ways of writing a formula
         *        to return a list of rows are to use the FindRow() or Filter() functions. Any other formula that
         *        returns zero or more rows is also acceptable. For example, you can use a formula that points to a cell
         *        that contains a filter function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formula(String formula);

        /**
         * <p>
         * The optional contextRowId attribute can be used to specify the row id of the context row if the filter
         * formula contains unqualified references to table columns and needs a context row to evaluate them
         * successfully.
         * </p>
         * 
         * @param contextRowId
         *        The optional contextRowId attribute can be used to specify the row id of the context row if the filter
         *        formula contains unqualified references to table columns and needs a context row to evaluate them
         *        successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextRowId(String contextRowId);
    }

    static final class BuilderImpl implements Builder {
        private String formula;

        private String contextRowId;

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            formula(model.formula);
            contextRowId(model.contextRowId);
        }

        public final String getFormula() {
            return formula;
        }

        public final void setFormula(String formula) {
            this.formula = formula;
        }

        @Override
        @Transient
        public final Builder formula(String formula) {
            this.formula = formula;
            return this;
        }

        public final String getContextRowId() {
            return contextRowId;
        }

        public final void setContextRowId(String contextRowId) {
            this.contextRowId = contextRowId;
        }

        @Override
        @Transient
        public final Builder contextRowId(String contextRowId) {
            this.contextRowId = contextRowId;
            return this;
        }

        @Override
        public Filter build() {
            return new Filter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
