/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeScreenAutomationRequest extends HoneycodeRequest implements
        ToCopyableBuilder<InvokeScreenAutomationRequest.Builder, InvokeScreenAutomationRequest> {
    private static final SdkField<String> WORKBOOK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workbookId").getter(getter(InvokeScreenAutomationRequest::workbookId))
            .setter(setter(Builder::workbookId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workbookId").build()).build();

    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(InvokeScreenAutomationRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()).build();

    private static final SdkField<String> SCREEN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("screenId").getter(getter(InvokeScreenAutomationRequest::screenId)).setter(setter(Builder::screenId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("screenId").build()).build();

    private static final SdkField<String> SCREEN_AUTOMATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("screenAutomationId").getter(getter(InvokeScreenAutomationRequest::screenAutomationId))
            .setter(setter(Builder::screenAutomationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("automationId").build()).build();

    private static final SdkField<Map<String, VariableValue>> VARIABLES_FIELD = SdkField
            .<Map<String, VariableValue>> builder(MarshallingType.MAP)
            .memberName("variables")
            .getter(getter(InvokeScreenAutomationRequest::variables))
            .setter(setter(Builder::variables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<VariableValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(VariableValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ROW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("rowId")
            .getter(getter(InvokeScreenAutomationRequest::rowId)).setter(setter(Builder::rowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowId").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken").getter(getter(InvokeScreenAutomationRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(WORKBOOK_ID_FIELD, APP_ID_FIELD, SCREEN_ID_FIELD, SCREEN_AUTOMATION_ID_FIELD,
                    VARIABLES_FIELD, ROW_ID_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String workbookId;

    private final String appId;

    private final String screenId;

    private final String screenAutomationId;

    private final Map<String, VariableValue> variables;

    private final String rowId;

    private final String clientRequestToken;

    private InvokeScreenAutomationRequest(BuilderImpl builder) {
        super(builder);
        this.workbookId = builder.workbookId;
        this.appId = builder.appId;
        this.screenId = builder.screenId;
        this.screenAutomationId = builder.screenAutomationId;
        this.variables = builder.variables;
        this.rowId = builder.rowId;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The ID of the workbook that contains the screen automation.
     * </p>
     * 
     * @return The ID of the workbook that contains the screen automation.
     */
    public final String workbookId() {
        return workbookId;
    }

    /**
     * <p>
     * The ID of the app that contains the screen automation.
     * </p>
     * 
     * @return The ID of the app that contains the screen automation.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The ID of the screen that contains the screen automation.
     * </p>
     * 
     * @return The ID of the screen that contains the screen automation.
     */
    public final String screenId() {
        return screenId;
    }

    /**
     * <p>
     * The ID of the automation action to be performed.
     * </p>
     * 
     * @return The ID of the automation action to be performed.
     */
    public final String screenAutomationId() {
        return screenAutomationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Variables property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVariables() {
        return variables != null && !(variables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Variables are specified as a map where the key is the name of the variable as defined on the screen. The value is
     * an object which currently has only one property, rawValue, which holds the value of the variable to be passed to
     * the screen. Any variables defined in a screen are required to be passed in the call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVariables} method.
     * </p>
     * 
     * @return Variables are specified as a map where the key is the name of the variable as defined on the screen. The
     *         value is an object which currently has only one property, rawValue, which holds the value of the variable
     *         to be passed to the screen. Any variables defined in a screen are required to be passed in the call.
     */
    public final Map<String, VariableValue> variables() {
        return variables;
    }

    /**
     * <p>
     * The row ID for the automation if the automation is defined inside a block with source or list.
     * </p>
     * 
     * @return The row ID for the automation if the automation is defined inside a block with source or list.
     */
    public final String rowId() {
        return rowId;
    }

    /**
     * <p>
     * The request token for performing the automation action. Request tokens help to identify duplicate requests. If a
     * call times out or fails due to a transient error like a failed network connection, you can retry the call with
     * the same request token. The service ensures that if the first call using that request token is successfully
     * performed, the second call will return the response of the previous call rather than performing the action again.
     * </p>
     * <p>
     * Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests
     * spanning hours or days.
     * </p>
     * 
     * @return The request token for performing the automation action. Request tokens help to identify duplicate
     *         requests. If a call times out or fails due to a transient error like a failed network connection, you can
     *         retry the call with the same request token. The service ensures that if the first call using that request
     *         token is successfully performed, the second call will return the response of the previous call rather
     *         than performing the action again. </p>
     *         <p>
     *         Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe
     *         requests spanning hours or days.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workbookId());
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(screenId());
        hashCode = 31 * hashCode + Objects.hashCode(screenAutomationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasVariables() ? variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(rowId());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeScreenAutomationRequest)) {
            return false;
        }
        InvokeScreenAutomationRequest other = (InvokeScreenAutomationRequest) obj;
        return Objects.equals(workbookId(), other.workbookId()) && Objects.equals(appId(), other.appId())
                && Objects.equals(screenId(), other.screenId())
                && Objects.equals(screenAutomationId(), other.screenAutomationId()) && hasVariables() == other.hasVariables()
                && Objects.equals(variables(), other.variables()) && Objects.equals(rowId(), other.rowId())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeScreenAutomationRequest").add("WorkbookId", workbookId()).add("AppId", appId())
                .add("ScreenId", screenId()).add("ScreenAutomationId", screenAutomationId())
                .add("Variables", variables() == null ? null : "*** Sensitive Data Redacted ***").add("RowId", rowId())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workbookId":
            return Optional.ofNullable(clazz.cast(workbookId()));
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "screenId":
            return Optional.ofNullable(clazz.cast(screenId()));
        case "screenAutomationId":
            return Optional.ofNullable(clazz.cast(screenAutomationId()));
        case "variables":
            return Optional.ofNullable(clazz.cast(variables()));
        case "rowId":
            return Optional.ofNullable(clazz.cast(rowId()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokeScreenAutomationRequest, T> g) {
        return obj -> g.apply((InvokeScreenAutomationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HoneycodeRequest.Builder, SdkPojo, CopyableBuilder<Builder, InvokeScreenAutomationRequest> {
        /**
         * <p>
         * The ID of the workbook that contains the screen automation.
         * </p>
         * 
         * @param workbookId
         *        The ID of the workbook that contains the screen automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workbookId(String workbookId);

        /**
         * <p>
         * The ID of the app that contains the screen automation.
         * </p>
         * 
         * @param appId
         *        The ID of the app that contains the screen automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The ID of the screen that contains the screen automation.
         * </p>
         * 
         * @param screenId
         *        The ID of the screen that contains the screen automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder screenId(String screenId);

        /**
         * <p>
         * The ID of the automation action to be performed.
         * </p>
         * 
         * @param screenAutomationId
         *        The ID of the automation action to be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder screenAutomationId(String screenAutomationId);

        /**
         * <p>
         * Variables are specified as a map where the key is the name of the variable as defined on the screen. The
         * value is an object which currently has only one property, rawValue, which holds the value of the variable to
         * be passed to the screen. Any variables defined in a screen are required to be passed in the call.
         * </p>
         * 
         * @param variables
         *        Variables are specified as a map where the key is the name of the variable as defined on the screen.
         *        The value is an object which currently has only one property, rawValue, which holds the value of the
         *        variable to be passed to the screen. Any variables defined in a screen are required to be passed in
         *        the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(Map<String, VariableValue> variables);

        /**
         * <p>
         * The row ID for the automation if the automation is defined inside a block with source or list.
         * </p>
         * 
         * @param rowId
         *        The row ID for the automation if the automation is defined inside a block with source or list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowId(String rowId);

        /**
         * <p>
         * The request token for performing the automation action. Request tokens help to identify duplicate requests.
         * If a call times out or fails due to a transient error like a failed network connection, you can retry the
         * call with the same request token. The service ensures that if the first call using that request token is
         * successfully performed, the second call will return the response of the previous call rather than performing
         * the action again.
         * </p>
         * <p>
         * Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests
         * spanning hours or days.
         * </p>
         * 
         * @param clientRequestToken
         *        The request token for performing the automation action. Request tokens help to identify duplicate
         *        requests. If a call times out or fails due to a transient error like a failed network connection, you
         *        can retry the call with the same request token. The service ensures that if the first call using that
         *        request token is successfully performed, the second call will return the response of the previous call
         *        rather than performing the action again. </p>
         *        <p>
         *        Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe
         *        requests spanning hours or days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends HoneycodeRequest.BuilderImpl implements Builder {
        private String workbookId;

        private String appId;

        private String screenId;

        private String screenAutomationId;

        private Map<String, VariableValue> variables = DefaultSdkAutoConstructMap.getInstance();

        private String rowId;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeScreenAutomationRequest model) {
            super(model);
            workbookId(model.workbookId);
            appId(model.appId);
            screenId(model.screenId);
            screenAutomationId(model.screenAutomationId);
            variables(model.variables);
            rowId(model.rowId);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getWorkbookId() {
            return workbookId;
        }

        public final void setWorkbookId(String workbookId) {
            this.workbookId = workbookId;
        }

        @Override
        @Transient
        public final Builder workbookId(String workbookId) {
            this.workbookId = workbookId;
            return this;
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        @Transient
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getScreenId() {
            return screenId;
        }

        public final void setScreenId(String screenId) {
            this.screenId = screenId;
        }

        @Override
        @Transient
        public final Builder screenId(String screenId) {
            this.screenId = screenId;
            return this;
        }

        public final String getScreenAutomationId() {
            return screenAutomationId;
        }

        public final void setScreenAutomationId(String screenAutomationId) {
            this.screenAutomationId = screenAutomationId;
        }

        @Override
        @Transient
        public final Builder screenAutomationId(String screenAutomationId) {
            this.screenAutomationId = screenAutomationId;
            return this;
        }

        public final Map<String, VariableValue.Builder> getVariables() {
            Map<String, VariableValue.Builder> result = VariableValueMapCopier.copyToBuilder(this.variables);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setVariables(Map<String, VariableValue.BuilderImpl> variables) {
            this.variables = VariableValueMapCopier.copyFromBuilder(variables);
        }

        @Override
        @Transient
        public final Builder variables(Map<String, VariableValue> variables) {
            this.variables = VariableValueMapCopier.copy(variables);
            return this;
        }

        public final String getRowId() {
            return rowId;
        }

        public final void setRowId(String rowId) {
            this.rowId = rowId;
        }

        @Override
        @Transient
        public final Builder rowId(String rowId) {
            this.rowId = rowId;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeScreenAutomationRequest build() {
            return new InvokeScreenAutomationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
